/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.nlogo.api.Refreshable;
import org.nlogo.core.I18N$;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.DocumentAction;
import org.nlogo.editor.QuickHelpAction;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$;
import org.nlogo.swing.UserAction$KeyBindings$;
import org.nlogo.swing.WrappedAction;
import org.nlogo.window.ClipboardUtils$;
import org.nlogo.window.CopyPasteTarget;
import org.nlogo.window.TextMenuActions$;

public final class TextMenuActions {
    public static WrappedAction CopyAction() {
        return TextMenuActions$.MODULE$.CopyAction();
    }

    public static WrappedAction CutAction() {
        return TextMenuActions$.MODULE$.CutAction();
    }

    public static WrappedAction DeleteAction() {
        return TextMenuActions$.MODULE$.DeleteAction();
    }

    public static WrappedPasteAction PasteAction() {
        return TextMenuActions$.MODULE$.PasteAction();
    }

    public static WrappedAction SelectAllAction() {
        return TextMenuActions$.MODULE$.SelectAllAction();
    }

    public static KeyboardQuickHelpAction keyboardQuickHelp(Colorizer colorizer) {
        return TextMenuActions$.MODULE$.keyboardQuickHelp(colorizer);
    }

    public static class KeyboardQuickHelpAction
    extends DocumentAction
    implements QuickHelpAction,
    UserAction.MenuAction {
        private final Colorizer colorizer;

        public KeyboardQuickHelpAction(Colorizer colorizer) {
            this.colorizer = colorizer;
            super(I18N$.MODULE$.gui().get("menu.help.lookUpInDictionary"));
            this.category_$eq(UserAction$.MODULE$.HelpCategory());
            this.group_$eq(UserAction$.MODULE$.HelpContextGroup());
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(112, UserAction$KeyBindings$.MODULE$.keystroke$default$2(), UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
        }

        @Override
        public Colorizer colorizer() {
            return this.colorizer;
        }

        @Override
        public void perform(JTextComponent component, Document document, ActionEvent e) {
            int targetOffset = component.getSelectionEnd();
            this.doHelp(component.getDocument(), targetOffset, component);
        }
    }

    public static class WrappedPasteAction
    extends WrappedAction
    implements Refreshable {
        public WrappedPasteAction(Action base) {
            super(base, UserAction$.MODULE$.EditCategory(), null, UserAction$.MODULE$.EditClipboardGroup(), UserAction$KeyBindings$.MODULE$.keystroke(86, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
        }

        @Override
        public void refresh() {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                this.setEnabled(clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) || clipboard.isDataFlavorAvailable(ClipboardUtils$.MODULE$.widgetsFlavor()));
            }
            catch (IllegalStateException illegalStateException) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (component instanceof CopyPasteTarget) {
                Component target = (Component)((Object)((CopyPasteTarget)((Object)component)));
                ((CopyPasteTarget)((Object)target)).paste();
                return;
            }
            super.actionPerformed(e);
        }
    }
}

