/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import javax.swing.JLabel;
import org.nlogo.api.Dump$;
import org.nlogo.api.World;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.Events;
import org.nlogo.window.TickCounterLabel$;
import scala.Option;

public class TickCounterLabel
extends JLabel
implements Events.AfterLoadEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.PeriodicUpdateEvent.Handler,
ThemeSync {
    private final World world;
    private String _label;

    public TickCounterLabel(World world) {
        this.world = world;
        this._label = TickCounterLabel$.org$nlogo$window$TickCounterLabel$$$TickCounterLabelDefault;
    }

    @Override
    public void handle(Events.LoadBeginEvent e) {
        this.setText("");
        this._label = TickCounterLabel$.org$nlogo$window$TickCounterLabel$$$TickCounterLabelDefault;
        this.setVisible(true);
    }

    @Override
    public void handle(Events.AfterLoadEvent e) {
        this.redrawTickCounter();
    }

    @Override
    public void handle(Events.PeriodicUpdateEvent e) {
        this.redrawTickCounter();
    }

    public void redrawTickCounter() {
        double ticks = this.world.ticks();
        String tickText = ticks == (double)-1 ? "" : Dump$.MODULE$.number(StrictMath.floor(ticks));
        this.setText((this._label + ": " + tickText).trim());
    }

    public void visibility_$eq(boolean visible) {
        this.setVisible(visible);
    }

    public boolean visibility() {
        return this.isVisible();
    }

    public void label_$eq(Option<String> label) {
        this._label = (String)label.getOrElse(TickCounterLabel::label_$eq$$anonfun$1);
        this.redrawTickCounter();
    }

    public String label() {
        return this._label;
    }

    @Override
    public void syncTheme() {
        this.setForeground(InterfaceColors$.MODULE$.toolbarText());
    }

    private static final String label_$eq$$anonfun$1() {
        return TickCounterLabel$.org$nlogo$window$TickCounterLabel$$$TickCounterLabelDefault;
    }
}

