/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import org.nlogo.api.AgentException;
import org.nlogo.api.Approximate;
import org.nlogo.api.Exceptions;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.awt.Mouse;

public class ViewMouseHandler
implements MouseMotionListener,
MouseListener {
    private final World world;
    private final ViewSettings settings;
    private final JComponent parent;
    boolean mouseDown = false;
    protected double mouseXCor = 0.0;
    protected double mouseYCor = 0.0;
    private boolean mouseInside = false;
    private Point pt = null;

    public ViewMouseHandler(JComponent parent, World world, ViewSettings settings) {
        this.world = world;
        this.settings = settings;
        this.parent = parent;
    }

    public void mouseDown(boolean mouseDown) {
        this.mouseDown = mouseDown;
    }

    public boolean mouseDown() {
        return this.mouseDown;
    }

    public double mouseXCor() {
        return this.mouseXCor;
    }

    public void mouseXCor(double mouseXCor) {
        this.mouseXCor = mouseXCor;
    }

    public double mouseYCor() {
        return this.mouseYCor;
    }

    public void mouseYCor(double mouseYCor) {
        this.mouseYCor = mouseYCor;
    }

    public boolean mouseInside() {
        return this.mouseInside;
    }

    public void resetMouseCors() {
        this.mouseXCor = 0.0;
        this.mouseYCor = 0.0;
    }

    public void updateMouseCors() {
        if (this.mouseInside() && this.pt != null) {
            this.translatePointToXCorYCor(this.pt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger() && Mouse.hasButton1(e)) {
            this.mouseDown(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (Mouse.hasButton1(e)) {
            this.mouseDown(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInside = this.parent.contains(e.getPoint());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!e.isPopupTrigger() && Mouse.hasButton1(e)) {
            this.mouseDown(true);
            if (this.parent.contains(e.getPoint())) {
                this.updateMouseInside(e.getPoint());
                this.translatePointToXCorYCor(e.getPoint());
                this.pt = e.getPoint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateMouseInside(e.getPoint());
        this.translatePointToXCorYCor(e.getPoint());
        this.pt = e.getPoint();
    }

    private void updateMouseInside(Point p) {
        double x1 = this.translatePointToUnboundedX(p.x);
        double y1 = this.translatePointToUnboundedY(p.y);
        try {
            this.mouseInside = this.world.wrapX(x1) == x1 && this.world.wrapY(y1) == y1;
        }
        catch (AgentException e) {
            this.mouseInside = false;
        }
    }

    double translatePointToUnboundedX(int x) {
        Rectangle rect = this.parent.getBounds();
        double xOff = this.settings.viewOffsetX();
        double dx = (double)x / (double)rect.width;
        double xcor = dx * this.settings.viewWidth() + ((double)this.world.minPxcor() - 0.5);
        xcor = Math.min(Math.max(xcor + xOff, (double)this.world.minPxcor() - 0.4999999), (double)this.world.maxPxcor() + 0.4999999);
        try {
            xcor = this.world.wrapX(xcor);
        }
        catch (AgentException e) {
            Exceptions.ignore(e);
        }
        if (this.settings.patchSize() <= 1.0) {
            xcor = Approximate.approximate(xcor, 0);
        }
        return xcor;
    }

    double translatePointToUnboundedY(int y) {
        Rectangle rect = this.parent.getBounds();
        double yOff = this.settings.viewOffsetY();
        double dy = (double)y / (double)rect.height;
        double ycor = (double)this.world.maxPycor() + 0.4999999 - this.settings.viewHeight() * dy;
        ycor = Math.min(Math.max(ycor + yOff, (double)this.world.minPycor() - 0.5), (double)this.world.maxPycor() + 0.5);
        try {
            ycor = this.world.wrapY(ycor);
        }
        catch (AgentException e) {
            Exceptions.ignore(e);
        }
        if (this.settings.patchSize() <= 1.0) {
            ycor = Approximate.approximate(ycor, 0);
        }
        return ycor;
    }

    void translatePointToXCorYCor(Point p) {
        Rectangle rect = this.parent.getBounds();
        int minx = this.world.minPxcor();
        int maxx = this.world.maxPxcor();
        int miny = this.world.minPycor();
        int maxy = this.world.maxPycor();
        double xOff = this.settings.viewOffsetX();
        double yOff = this.settings.viewOffsetY();
        double dx = (double)p.x / (double)rect.width;
        double newMouseX = dx * this.settings.viewWidth() + ((double)minx - 0.5);
        newMouseX += xOff;
        try {
            newMouseX = this.world.wrapX(newMouseX);
        }
        catch (AgentException e) {
            return;
        }
        if (newMouseX < (double)minx - 0.5) {
            newMouseX = (double)minx - 0.5;
        } else if (newMouseX >= (double)maxx + 0.5) {
            newMouseX = (double)maxx + 0.4999999;
        }
        if (this.settings.patchSize() <= 1.0) {
            newMouseX = Approximate.approximate(newMouseX, 0);
        }
        double dy = (double)p.y / (double)rect.height;
        double newMouseY = (double)maxy + 0.4999999 - this.settings.viewHeight() * dy;
        newMouseY += yOff;
        try {
            newMouseY = this.world.wrapY(newMouseY);
        }
        catch (AgentException e) {
            return;
        }
        if (newMouseY < (double)miny - 0.5) {
            newMouseY = (double)miny - 0.5;
        } else if (newMouseY >= (double)maxy + 0.5) {
            newMouseY = (double)maxy + 0.4999999;
        }
        if (this.settings.patchSize() <= 1.0) {
            newMouseY = Approximate.approximate(newMouseY, 0);
        }
        this.mouseXCor(newMouseX);
        this.mouseYCor(newMouseY);
    }
}

