/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.border.LineBorder;
import org.nlogo.api.Approximate$;
import org.nlogo.api.Version$;
import org.nlogo.swing.PopupMenu;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.DisplaySwitch;
import org.nlogo.window.Editable;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.MouseMode;
import org.nlogo.window.TickCounterLabel;
import org.nlogo.window.View;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WorldViewSettings;
import org.nlogo.window.WorldViewSettings2D;
import org.nlogo.window.WorldViewSettings3D;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class ViewWidget
extends Widget
implements ViewWidgetInterface {
    private final GUIWorkspace workspace;
    private final View view;
    private final TickCounterLabel tickCounter;
    private final DisplaySwitch displaySwitch;
    private final WorldViewSettings settings;

    public ViewWidget(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.view = new View(workspace);
        this.tickCounter = new TickCounterLabel(workspace.world());
        this.displaySwitch = new DisplaySwitch(workspace);
        this.setLayout(null);
        this.add(this.view());
        this.settings = Version$.MODULE$.is3D() ? new WorldViewSettings3D(workspace, this, this.tickCounter()) : new WorldViewSettings2D(workspace, this, this.tickCounter());
    }

    public View view() {
        return this.view;
    }

    public TickCounterLabel tickCounter() {
        return this.tickCounter;
    }

    public DisplaySwitch displaySwitch() {
        return this.displaySwitch;
    }

    public WorldViewSettings settings() {
        return this.settings;
    }

    @Override
    public String classDisplayName() {
        return "World & View";
    }

    public final int getExtraHeight() {
        return this.getInsets().top + this.getInsets().bottom;
    }

    @Override
    public int getAdditionalHeight() {
        return this.getExtraHeight();
    }

    @Override
    public void doLayout() {
        int availableWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
        double patchSize = this.computePatchSize(availableWidth, this.workspace.world().worldWidth());
        int graphicsHeight = (int)StrictMath.round(patchSize * (double)this.workspace.world().worldHeight());
        this.view().visualPatchSize(patchSize);
        this.view().setBounds(this.getInsets().left, this.getInsets().top, availableWidth, graphicsHeight);
    }

    @Override
    public Option<Editable> getEditable() {
        return Option$.MODULE$.apply((Object)this.settings());
    }

    public double computePatchSize(int width, int numPatches) {
        double exactPatchSize = (double)width / (double)numPatches;
        Option roundedPatchSize2 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 15).map((Function1)(JFunction1.mcDI.sp & Serializable)precision -> Approximate$.MODULE$.approximate(exactPatchSize, precision)).find((Function1)(JFunction1.mcZD.sp & Serializable)roundedPatchSize -> (int)((double)numPatches * roundedPatchSize) == width);
        return BoxesRunTime.unboxToDouble((Object)roundedPatchSize2.getOrElse(() -> ViewWidget.computePatchSize$$anonfun$1(exactPatchSize)));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension gSize = this.view().getMinimumSize();
        return new Dimension((int)gSize.getWidth(), this.getExtraHeight() + gSize.height);
    }

    public int insetWidth() {
        return this.getInsets().left + this.getInsets().right;
    }

    public int calculateWidth(int worldWidth, double patchSize) {
        return (int)((double)worldWidth * patchSize);
    }

    public int calculateHeight(int worldHeight, double patchSize) {
        return (int)(patchSize * (double)worldHeight);
    }

    public void resetSize() {
        this.view().setSize(this.workspace.world().worldWidth(), this.workspace.world().worldHeight(), this.workspace.world().patchSize());
        Dimension dim = this.view().getPreferredSize();
        this.setSize(dim.width + this.insetWidth(), dim.height + this.getExtraHeight());
        this.doLayout();
        this.resetZoomInfo();
    }

    public boolean shouldAdjustSize() {
        return (double)this.view().getWidth() > this.workspace.world().patchSize() * (double)this.workspace.world().worldWidth() || (double)this.view().getHeight() > this.workspace.world().patchSize() * (double)this.workspace.world().worldHeight();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (width != bounds.width || height != bounds.height || x != bounds.x || y != bounds.y) {
            super.setBounds(x, y, width, height);
            this.resetSizeInfo();
            return;
        }
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public Rectangle constrainDrag(Rectangle newBounds, Rectangle originalBounds, MouseMode mouseMode) {
        int newY;
        int newX;
        int newHeight;
        int newWidth;
        block17: {
            block19: {
                MouseMode mouseMode2;
                MouseMode mouseMode3;
                block21: {
                    MouseMode mouseMode4;
                    block20: {
                        MouseMode mouseMode5;
                        MouseMode mouseMode6;
                        block18: {
                            block16: {
                                block13: {
                                    MouseMode mouseMode7;
                                    MouseMode mouseMode8;
                                    block15: {
                                        block14: {
                                            MouseMode mouseMode9;
                                            MouseMode mouseMode10;
                                            block12: {
                                                double patchSizeBasedOnNewWidth = this.computePatchSize(newBounds.width - this.getInsets().left + this.getInsets().right, this.workspace.world().worldWidth());
                                                double patchSizeBasedOnNewHeight = this.computePatchSize(newBounds.height - this.getExtraHeight(), this.workspace.world().worldHeight());
                                                double newPatchSize = newBounds.height == originalBounds.height ? patchSizeBasedOnNewWidth : (newBounds.width == originalBounds.width ? patchSizeBasedOnNewHeight : StrictMath.max(patchSizeBasedOnNewWidth, patchSizeBasedOnNewHeight));
                                                this.workspace.world().patchSize(newPatchSize);
                                                this.view().setSize(this.workspace.world().worldWidth(), this.workspace.world().worldHeight(), newPatchSize);
                                                this.view().renderer.trailDrawer().rescaleDrawing();
                                                newWidth = (int)(newPatchSize * (double)this.workspace.world().worldWidth() + (double)this.insetWidth());
                                                newHeight = (int)(newPatchSize * (double)this.workspace.world().worldHeight() + (double)this.getExtraHeight());
                                                int widthAdjust = newBounds.width - newWidth;
                                                int heightAdjust = newBounds.height - newHeight;
                                                newX = newBounds.x;
                                                newY = newBounds.y;
                                                MouseMode mouseMode11 = mouseMode;
                                                MouseMode mouseMode12 = MouseMode.NE;
                                                MouseMode mouseMode13 = mouseMode11;
                                                if (!(mouseMode12 != null ? !((Object)((Object)mouseMode12)).equals((Object)mouseMode13) : mouseMode13 != null)) {
                                                    newY += heightAdjust;
                                                } else {
                                                    MouseMode mouseMode14 = MouseMode.NW;
                                                    MouseMode mouseMode15 = mouseMode11;
                                                    if (!(mouseMode14 != null ? !((Object)((Object)mouseMode14)).equals((Object)mouseMode15) : mouseMode15 != null)) {
                                                        newX += widthAdjust;
                                                        newY += heightAdjust;
                                                    } else {
                                                        MouseMode mouseMode16 = MouseMode.SW;
                                                        MouseMode mouseMode17 = mouseMode11;
                                                        if (!(mouseMode16 != null ? !((Object)((Object)mouseMode16)).equals((Object)mouseMode17) : mouseMode17 != null)) {
                                                            newX += widthAdjust;
                                                        } else {
                                                            MouseMode mouseMode18 = MouseMode.W;
                                                            MouseMode mouseMode19 = mouseMode11;
                                                            if (!(mouseMode18 != null ? !((Object)((Object)mouseMode18)).equals((Object)mouseMode19) : mouseMode19 != null)) {
                                                                newX += widthAdjust;
                                                            } else {
                                                                MouseMode mouseMode20 = MouseMode.N;
                                                                MouseMode mouseMode21 = mouseMode11;
                                                                if (!(mouseMode20 != null ? !((Object)((Object)mouseMode20)).equals((Object)mouseMode21) : mouseMode21 != null)) {
                                                                    newY += heightAdjust;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                mouseMode4 = mouseMode;
                                                mouseMode10 = MouseMode.N;
                                                mouseMode9 = mouseMode4;
                                                if (mouseMode10 != null) break block12;
                                                if (mouseMode9 == null) break block13;
                                                break block14;
                                            }
                                            if (((Object)((Object)mouseMode10)).equals((Object)mouseMode9)) break block13;
                                        }
                                        mouseMode8 = MouseMode.S;
                                        mouseMode7 = mouseMode4;
                                        if (mouseMode8 != null) break block15;
                                        if (mouseMode7 == null) break block13;
                                        break block16;
                                    }
                                    if (!((Object)((Object)mouseMode8)).equals((Object)mouseMode7)) break block16;
                                }
                                int midpointX = originalBounds.x + originalBounds.width / 2;
                                newX = midpointX - newWidth / 2;
                                break block17;
                            }
                            mouseMode6 = MouseMode.E;
                            mouseMode5 = mouseMode4;
                            if (mouseMode6 != null) break block18;
                            if (mouseMode5 == null) break block19;
                            break block20;
                        }
                        if (((Object)((Object)mouseMode6)).equals((Object)mouseMode5)) break block19;
                    }
                    mouseMode3 = MouseMode.W;
                    mouseMode2 = mouseMode4;
                    if (mouseMode3 != null) break block21;
                    if (mouseMode2 == null) break block19;
                    break block17;
                }
                if (!((Object)((Object)mouseMode3)).equals((Object)mouseMode2)) break block17;
            }
            int midpointY = originalBounds.y + originalBounds.height / 2;
            newY = midpointY - newHeight / 2;
        }
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    @Override
    public void syncTheme() {
        this.setBackgroundColor(InterfaceColors$.MODULE$.viewBackground());
        this.setBorder(new LineBorder(InterfaceColors$.MODULE$.viewBorder(), 2));
        this.tickCounter().syncTheme();
    }

    public void applyNewFontSize(int newFontSize) {
        Font font = this.view().getFont();
        int zoomDiff = font.getSize() - this.view().fontSize();
        this.view().applyNewFontSize(newFontSize, zoomDiff);
    }

    @Override
    public boolean hasContextMenu() {
        return true;
    }

    @Override
    public void populateContextMenu(PopupMenu menu, Point p) {
        this.view().populateContextMenu(menu, p);
    }

    public void displaySwitchOn(boolean on) {
        this.displaySwitch().actionPerformed(null);
    }

    @Override
    public org.nlogo.core.Widget model() {
        return this.settings().model();
    }

    @Override
    public void load(org.nlogo.core.Widget view) {
        this.settings().load(view);
    }

    @Override
    public boolean copyable() {
        return false;
    }

    private static final double computePatchSize$$anonfun$1(double exactPatchSize$2) {
        return exactPatchSize$2;
    }
}

