/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.io.Serializable;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.core.CompilerException;
import org.nlogo.core.I18N$;
import org.nlogo.core.UpdateMode;
import org.nlogo.core.View;
import org.nlogo.core.Widget;
import org.nlogo.core.WorldDimensions;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OriginConfiguration;
import org.nlogo.window.OriginType;
import org.nlogo.window.OriginType$Center$;
import org.nlogo.window.OriginType$Corner$;
import org.nlogo.window.OriginType$Custom$;
import org.nlogo.window.OriginType$Edge$;
import org.nlogo.window.TickCounterLabel;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WorldIntegerEditor;
import org.nlogo.workspace.WorldLoaderInterface;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public abstract class WorldViewSettings
implements Editable,
WorldLoaderInterface,
WorldPropertiesInterface {
    private final GUIWorkspace workspace;
    private final ViewWidget gWidget;
    private final TickCounterLabel tickCounter;
    private OriginType originType;
    private Option<OriginConfiguration> originConfig;
    private OriginType originalType;
    private Option<OriginConfiguration> originalConfig;
    private boolean wrappingChanged;
    private boolean edgesChanged;
    private boolean patchSizeChanged;
    private boolean fontSizeChanged;
    private double newPatchSize;
    private int newMinX;
    private int newMaxX;
    private int newMinY;
    private int newMaxY;
    private boolean newWrapX;
    private boolean newWrapY;
    private int newFontSize;
    private Option<CompilerException> _error;
    private final Seq<OriginType> originTypes;

    public WorldViewSettings(GUIWorkspace workspace, ViewWidget gWidget, TickCounterLabel tickCounter) {
        this.workspace = workspace;
        this.gWidget = gWidget;
        this.tickCounter = tickCounter;
        this.originType = OriginType$Center$.MODULE$;
        this.originConfig = None$.MODULE$;
        this.originalType = this.originType();
        this.originalConfig = this.originConfig();
        this.wrappingChanged = false;
        this.edgesChanged = false;
        this.patchSizeChanged = false;
        this.fontSizeChanged = false;
        this.newPatchSize = 0.0;
        this.newMinX = 0;
        this.newMaxX = 0;
        this.newMinY = 0;
        this.newMaxY = 0;
        this.newWrapX = false;
        this.newWrapY = false;
        this.newFontSize = 0;
        this._error = None$.MODULE$;
        this.originTypes = (Seq)((SeqOps)new .colon.colon((Object)OriginType$Center$.MODULE$, (List)new .colon.colon((Object)OriginType$Corner$.MODULE$, (List)new .colon.colon((Object)OriginType$Edge$.MODULE$, (List)new .colon.colon((Object)OriginType$Custom$.MODULE$, (List)Nil$.MODULE$)))));
    }

    public GUIWorkspace workspace() {
        return this.workspace;
    }

    public ViewWidget gWidget() {
        return this.gWidget;
    }

    public OriginType originType() {
        return this.originType;
    }

    public void originType_$eq(OriginType x$1) {
        this.originType = x$1;
    }

    public Option<OriginConfiguration> originConfig() {
        return this.originConfig;
    }

    public void originConfig_$eq(Option<OriginConfiguration> x$1) {
        this.originConfig = x$1;
    }

    public OriginType originalType() {
        return this.originalType;
    }

    public void originalType_$eq(OriginType x$1) {
        this.originalType = x$1;
    }

    public Option<OriginConfiguration> originalConfig() {
        return this.originalConfig;
    }

    public void originalConfig_$eq(Option<OriginConfiguration> x$1) {
        this.originalConfig = x$1;
    }

    public boolean wrappingChanged() {
        return this.wrappingChanged;
    }

    public void wrappingChanged_$eq(boolean x$1) {
        this.wrappingChanged = x$1;
    }

    public boolean edgesChanged() {
        return this.edgesChanged;
    }

    public void edgesChanged_$eq(boolean x$1) {
        this.edgesChanged = x$1;
    }

    public boolean patchSizeChanged() {
        return this.patchSizeChanged;
    }

    public void patchSizeChanged_$eq(boolean x$1) {
        this.patchSizeChanged = x$1;
    }

    public boolean fontSizeChanged() {
        return this.fontSizeChanged;
    }

    public void fontSizeChanged_$eq(boolean x$1) {
        this.fontSizeChanged = x$1;
    }

    public double newPatchSize() {
        return this.newPatchSize;
    }

    public void newPatchSize_$eq(double x$1) {
        this.newPatchSize = x$1;
    }

    public int newMinX() {
        return this.newMinX;
    }

    public void newMinX_$eq(int x$1) {
        this.newMinX = x$1;
    }

    public int newMaxX() {
        return this.newMaxX;
    }

    public void newMaxX_$eq(int x$1) {
        this.newMaxX = x$1;
    }

    public int newMinY() {
        return this.newMinY;
    }

    public void newMinY_$eq(int x$1) {
        this.newMinY = x$1;
    }

    public int newMaxY() {
        return this.newMaxY;
    }

    public void newMaxY_$eq(int x$1) {
        this.newMaxY = x$1;
    }

    public boolean newWrapX() {
        return this.newWrapX;
    }

    public void newWrapX_$eq(boolean x$1) {
        this.newWrapX = x$1;
    }

    public boolean newWrapY() {
        return this.newWrapY;
    }

    public void newWrapY_$eq(boolean x$1) {
        this.newWrapY = x$1;
    }

    public int newFontSize() {
        return this.newFontSize;
    }

    public void newFontSize_$eq(int x$1) {
        this.newFontSize = x$1;
    }

    public Option<CompilerException> _error() {
        return this._error;
    }

    public void _error_$eq(Option<CompilerException> x$1) {
        this._error = x$1;
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("edit.viewSettings.modelSettings");
    }

    public abstract void resizeWithProgress(boolean var1);

    public EditPanel editPanel3D() {
        return this.editPanel();
    }

    public abstract Widget model();

    public Seq<OriginType> originTypes() {
        return this.originTypes;
    }

    public abstract Seq<OriginConfiguration> cornerConfigs();

    public abstract Seq<OriginConfiguration> edgeConfigs();

    public OriginType getSelectedType() {
        return this.originType();
    }

    public Option<OriginConfiguration> getSelectedConfig() {
        return this.originConfig();
    }

    public void setOriginType(OriginType originType) {
        this.originType_$eq(originType);
        this.originConfig_$eq((Option<OriginConfiguration>)None$.MODULE$);
    }

    public void setOriginConfig(Option<OriginConfiguration> originConfig) {
        this.originConfig_$eq(originConfig);
    }

    public void setTypeAndConfig() {
        Tuple3<Object, Object, Object> tuple3 = this.getNorms();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        float x = BoxesRunTime.unboxToFloat((Object)tuple3._1());
        float y = BoxesRunTime.unboxToFloat((Object)tuple3._2());
        float z = BoxesRunTime.unboxToFloat((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)x), (Object)BoxesRunTime.boxToFloat((float)y), (Object)BoxesRunTime.boxToFloat((float)z));
        float x2 = BoxesRunTime.unboxToFloat((Object)tuple32._1());
        float y2 = BoxesRunTime.unboxToFloat((Object)tuple32._2());
        float z2 = BoxesRunTime.unboxToFloat((Object)tuple32._3());
        if ((double)x2 == 0.5 && (double)y2 == 0.5 && (double)z2 == 0.5) {
            this.originType_$eq(OriginType$Center$.MODULE$);
            this.originConfig_$eq((Option<OriginConfiguration>)None$.MODULE$);
        } else {
            Option corner = this.cornerConfigs().find((Function1 & Serializable)config -> config.x() == (double)x2 && config.y() == (double)y2 && config.z() == (double)z2);
            if (corner.isDefined()) {
                this.originType_$eq(OriginType$Corner$.MODULE$);
                this.originConfig_$eq((Option<OriginConfiguration>)corner);
            } else {
                Option edge = this.edgeConfigs().find((Function1 & Serializable)config -> config.x() == (double)x2 && config.y() == (double)y2 && config.z() == (double)z2);
                if (edge.isDefined()) {
                    this.originType_$eq(OriginType$Edge$.MODULE$);
                    this.originConfig_$eq((Option<OriginConfiguration>)edge);
                } else {
                    this.originType_$eq(OriginType$Custom$.MODULE$);
                    this.originConfig_$eq((Option<OriginConfiguration>)None$.MODULE$);
                }
            }
        }
        this.originalType_$eq(this.originType());
        this.originalConfig_$eq(this.originConfig());
    }

    public abstract Tuple3<Object, Object, Object> getNorms();

    public abstract void configureEditors(Seq<WorldIntegerEditor> var1);

    public void apply() {
        this.originalType_$eq(this.originType());
        this.originalConfig_$eq(this.originConfig());
    }

    public void revert() {
        this.originType_$eq(this.originalType());
        this.originConfig_$eq(this.originalConfig());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean changed() {
        OriginType originType = this.originType();
        OriginType originType2 = this.originalType();
        if (originType == null) {
            if (originType2 != null) {
                return true;
            }
        } else if (!originType.equals(originType2)) return true;
        Option<OriginConfiguration> option = this.originConfig();
        Option<OriginConfiguration> option2 = this.originalConfig();
        if (option == null) {
            if (option2 == null) return false;
            return true;
        } else if (option.equals(option2)) return false;
        return true;
    }

    public Object load(Widget view) {
        this.workspace().world().displayOn(false);
        this.workspace().loadWorld((View)view, this);
        this.workspace().world().tickCounter().clear();
        this.workspace().world().clearPatches();
        this.workspace().world().displayOn(true);
        return this;
    }

    public boolean smooth() {
        return this.workspace().glView().antiAliasingOn();
    }

    public void smooth(boolean smooth) {
        if (this.workspace().glView().antiAliasingOn() != smooth) {
            this.workspace().glView().antiAliasingOn(smooth);
            return;
        }
    }

    public boolean wireframe() {
        return this.workspace().glView().wireframeOn();
    }

    public void wireframe(boolean on) {
        if (on != this.wireframe()) {
            this.workspace().glView().setWireframeOn(on);
            this.workspace().glView().repaint();
            return;
        }
    }

    public boolean dualView() {
        return this.workspace().dualView();
    }

    public void dualView(boolean on) {
        this.workspace().dualView(on);
    }

    @Override
    public Option<String> helpLink() {
        return Option$.MODULE$.empty();
    }

    @Override
    public boolean liveUpdate() {
        return false;
    }

    public void minPxcor(int minPxcor) {
        if (minPxcor <= 0) {
            this.newMinX_$eq(minPxcor);
            this.edgesChanged_$eq(this.edgesChanged() || this.newMinX() != this.workspace().world().minPxcor());
            return;
        }
    }

    public int minPxcor() {
        return this.newMinX();
    }

    public void maxPxcor(int maxPxcor) {
        if (maxPxcor >= 0) {
            this.newMaxX_$eq(maxPxcor);
            this.edgesChanged_$eq(this.edgesChanged() || this.newMaxX() != this.workspace().world().maxPxcor());
            return;
        }
    }

    public int maxPxcor() {
        return this.newMaxX();
    }

    public void minPycor(int minPycor) {
        if (minPycor <= 0) {
            this.newMinY_$eq(minPycor);
            this.edgesChanged_$eq(this.edgesChanged() || this.newMinY() != this.workspace().world().minPycor());
            return;
        }
    }

    public int minPycor() {
        return this.newMinY();
    }

    public void maxPycor(int maxPycor) {
        if (maxPycor >= 0) {
            this.newMaxY_$eq(maxPycor);
            this.edgesChanged_$eq(this.edgesChanged() || this.newMaxY() != this.workspace().world().maxPycor());
            return;
        }
    }

    public int maxPycor() {
        return this.newMaxY();
    }

    @Override
    public void patchSize(double size) {
        this.newPatchSize_$eq(size);
        this.patchSizeChanged_$eq(this.patchSizeChanged() || size != this.patchSize());
    }

    public double patchSize() {
        return this.workspace().world().patchSize();
    }

    public UpdateMode updateMode() {
        return this.workspace().updateMode();
    }

    @Override
    public void updateMode(UpdateMode updateMode) {
        this.workspace().updateMode(updateMode);
    }

    public boolean wrappingX() {
        if (!this.wrappingChanged()) {
            this.newWrapX_$eq(this.workspace().world().wrappingAllowedInX());
        }
        return this.newWrapX();
    }

    public void wrappingX(boolean value) {
        this.newWrapX_$eq(value);
        this.wrappingChanged_$eq(this.wrappingChanged() || this.newWrapX() != this.workspace().world().wrappingAllowedInX());
    }

    public boolean wrappingY() {
        if (!this.wrappingChanged()) {
            this.newWrapY_$eq(this.workspace().world().wrappingAllowedInY());
        }
        return this.newWrapY();
    }

    public void wrappingY(boolean value) {
        this.newWrapY_$eq(value);
        this.wrappingChanged_$eq(this.wrappingChanged() || this.newWrapY() != this.workspace().world().wrappingAllowedInY());
    }

    @Override
    public int fontSize() {
        return this.gWidget().view().fontSize();
    }

    @Override
    public void fontSize(int newSize) {
        this.newFontSize_$eq(newSize);
        if (newSize != this.fontSize()) {
            this.fontSizeChanged_$eq(true);
        }
        this.workspace().viewManager().applyNewFontSize(newSize);
    }

    @Override
    public double frameRate() {
        return this.workspace().frameRate();
    }

    @Override
    public void frameRate(double frameRate) {
        this.workspace().frameRate(frameRate);
    }

    @Override
    public void showTickCounter(boolean visible) {
        this.tickCounter.visibility_$eq(visible);
    }

    @Override
    public boolean showTickCounter() {
        return this.tickCounter.visibility();
    }

    @Override
    public void tickCounterLabel(Option<String> label) {
        this.tickCounter.label_$eq(label);
    }

    @Override
    public String tickCounterLabel() {
        return this.tickCounter.label();
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.workspace().changeTopology(wrapX, wrapY);
    }

    @Override
    public void clearTurtles() {
        this.workspace().world().clearTurtles();
    }

    @Override
    public boolean anyErrors() {
        return this._error().isDefined();
    }

    public void error(Exception e) {
        Exception exception = e;
        if (exception instanceof CompilerException) {
            CompilerException e2 = (CompilerException)exception;
            this._error_$eq((Option<CompilerException>)Some$.MODULE$.apply((Object)e2));
            return;
        }
        throw new IllegalStateException(e);
    }

    @Override
    public void error(Object o, Exception e) {
        this.error(e);
    }

    public Option<Exception> error() {
        return this._error();
    }

    @Override
    public Option<Exception> error(Object a) {
        return this._error();
    }

    @Override
    public void setSize(int x, int y) {
        this.gWidget().setSize(x, y);
    }

    @Override
    public int getMinimumWidth() {
        return this.gWidget().getMinimumSize().width;
    }

    @Override
    public int insetWidth() {
        return this.gWidget().insetWidth();
    }

    @Override
    public double computePatchSize(int width, int numPatches) {
        return this.gWidget().computePatchSize(width, numPatches);
    }

    @Override
    public int calculateHeight(int worldHeight, double patchSize) {
        return this.gWidget().calculateHeight(worldHeight, patchSize);
    }

    @Override
    public int calculateWidth(int worldWidth, double patchSize) {
        return this.gWidget().calculateWidth(worldWidth, patchSize);
    }

    @Override
    public void setDimensions(WorldDimensions d, double newPatchSize) {
        boolean patchSizeChanged = newPatchSize != this.workspace().world().patchSize();
        this.workspace().world().patchSize(newPatchSize);
        this.setDimensions(d.minPxcor(), d.maxPxcor(), d.minPycor(), d.maxPycor(), patchSizeChanged);
        this.patchSize(newPatchSize);
    }

    public void setDimensions(WorldDimensions d) {
        this.setDimensions(d.minPxcor(), d.maxPxcor(), d.minPycor(), d.maxPycor(), false);
    }

    public void setDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor, boolean patchSizeChanged) {
        this.newMinX_$eq(minPxcor);
        this.newMaxX_$eq(maxPxcor);
        this.newMinY_$eq(minPycor);
        this.newMaxY_$eq(maxPycor);
        if (minPxcor != this.workspace().world().minPxcor() || maxPxcor != this.workspace().world().maxPxcor() || minPycor != this.workspace().world().minPycor() || maxPycor != this.workspace().world().maxPycor() || patchSizeChanged) {
            this.prepareForWorldResize();
            this.workspace().world().createPatches(minPxcor, maxPxcor, minPycor, maxPycor);
            this.finishWorldResize();
            return;
        }
    }

    public void prepareForWorldResize() {
        this.workspace().jobManager.haltNonObserverJobs();
        this.workspace().world().clearTurtles();
        this.workspace().world().clearLinks();
    }

    public void finishWorldResize() {
        this.workspace().patchesCreatedNotify();
        this.gWidget().resetSize();
        this.workspace().clearDrawing();
    }

    @Override
    public int sourceOffset() {
        throw new IllegalStateException();
    }
}

