/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import org.nlogo.window.View;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetWrapperInterface;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

public class Zoomer {
    private final Container container;
    private double _zoomFactor;
    private final Map<Component, Dimension> sizes;
    private final Map<Component, Object> sizeZooms;
    private final Map<Component, Point> locations;
    private final Map<Component, Object> locationZooms;
    private final Map<Component, Font> fonts;
    private final Map<Component, Object> fontZooms;

    public Zoomer(Container container) {
        this.container = container;
        this._zoomFactor = 1.0;
        this.sizes = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.sizeZooms = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.locations = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.locationZooms = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.fonts = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.fontZooms = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public double zoomFactor() {
        return this._zoomFactor;
    }

    public void zoomWidgets(double newZoom) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.container.getComponents());
        ArrayOps$.MODULE$.foreach$extension(object, component -> {
            Component component2 = component;
            if (component2 instanceof WidgetWrapperInterface) {
                Component w = (Component)((Object)((WidgetWrapperInterface)((Object)component2)));
                this.zoomWidget((WidgetWrapperInterface)((Object)w), false, false, this._zoomFactor, newZoom);
                return;
            }
        });
        this._zoomFactor = newZoom;
    }

    public void zoomWidget(WidgetWrapperInterface wrapper, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        if (oldZoom != newZoom) {
            this.zoomWidgetSize(wrapper, newWidget, loadingWidget, oldZoom, newZoom);
            this.zoomWidgetLocation(wrapper, newWidget, loadingWidget, oldZoom, newZoom);
            this.zoomWidgetFont(wrapper, wrapper.widget(), newWidget, loadingWidget, oldZoom, newZoom);
            return;
        }
    }

    public void zoomWidgetSize(WidgetWrapperInterface wrapper, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        Widget component = wrapper.widget();
        Option originalSize = this.sizes.get((Object)component);
        Option originalZoom = this.sizeZooms.get((Object)component);
        if (originalSize.isEmpty()) {
            originalSize = Some$.MODULE$.apply((Object)component.getSize());
            originalZoom = Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)oldZoom));
            if (!newWidget || loadingWidget) {
                this.sizes.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)component, originalSize.get()));
                this.sizeZooms.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)component, originalZoom.get()));
            }
        }
        if (!newWidget || loadingWidget) {
            wrapper.setSize(this.zoomSize((Dimension)originalSize.get(), BoxesRunTime.unboxToDouble((Object)originalZoom.get()), newZoom));
        }
        wrapper.widget().setZoomFactor(newZoom);
    }

    public Dimension zoomSize(Dimension originalSize, double oldZoom, double newZoom) {
        return new Dimension((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)originalSize.width * newZoom / oldZoom)), (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)originalSize.height * newZoom / oldZoom)));
    }

    public Dimension zoomSize(Dimension originalSize) {
        return this.zoomSize(originalSize, 1.0, this.zoomFactor());
    }

    public void zoomWidgetLocation(WidgetWrapperInterface wrapper, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        Widget component = wrapper.widget();
        Option originalLocation = this.locations.get((Object)component);
        Option originalZoom = this.locationZooms.get((Object)component);
        if (originalLocation.isEmpty()) {
            originalLocation = Some$.MODULE$.apply((Object)wrapper.getUnselectedLocation());
            originalZoom = Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)oldZoom));
            if (!newWidget || loadingWidget) {
                this.locations.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)component, originalLocation.get()));
                this.locationZooms.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)component, originalZoom.get()));
            }
        }
        if (!newWidget || loadingWidget) {
            wrapper.setLocation(this.zoomLocation((Point)originalLocation.get(), BoxesRunTime.unboxToDouble((Object)originalZoom.get()), newZoom));
            return;
        }
    }

    private Point zoomLocation(Point originalLocation, double oldZoom, double newZoom) {
        return new Point((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)originalLocation.x * newZoom / oldZoom)), (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)originalLocation.y * newZoom / oldZoom)));
    }

    public void zoomWidgetFont(WidgetWrapperInterface wrapper, Widget widget, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        if (!this.fonts.contains((Object)widget)) {
            this.storeComponentFont(widget, true, newWidget, loadingWidget, oldZoom);
        }
        this.scaleComponentFont(widget, newZoom, oldZoom, true);
        if (wrapper != null) {
            wrapper.validate();
            return;
        }
    }

    private void storeComponentFont(Component component2, boolean recursive, boolean newWidget, boolean loadingWidget, double oldZoom) {
        if (!(component2 instanceof ViewWidgetInterface && newWidget && !loadingWidget || this.fonts.contains((Object)component2))) {
            this.fonts.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)component2, (Object)component2.getFont()));
            this.fontZooms.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)component2, (Object)BoxesRunTime.boxToDouble((double)oldZoom)));
        }
        if (recursive) {
            Component component3 = component2;
            if (component3 instanceof Container) {
                Container c = (Container)component3;
                Object object = Predef$.MODULE$.refArrayOps((Object[])c.getComponents());
                ArrayOps$.MODULE$.foreach$extension(object, component -> this.storeComponentFont((Component)component, true, newWidget, loadingWidget, oldZoom));
                return;
            }
            return;
        }
    }

    public void scaleComponentFont(Component component2, double newZoom, double oldZoom, boolean recursive) {
        if (!this.fonts.contains((Object)component2)) {
            this.storeComponentFont(component2, recursive, false, false, oldZoom);
        }
        component2.invalidate();
        component2.setFont(component2.getFont().deriveFont((float)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)((Font)this.fonts.apply((Object)component2)).getSize() * newZoom / BoxesRunTime.unboxToDouble((Object)this.fontZooms.apply((Object)component2))))));
        if (recursive) {
            Component component3 = component2;
            if (component3 instanceof Container) {
                Container c = (Container)component3;
                Object object = Predef$.MODULE$.refArrayOps((Object[])c.getComponents());
                ArrayOps$.MODULE$.foreach$extension(object, component -> this.scaleComponentFont((Component)component, newZoom, oldZoom, true));
                return;
            }
            return;
        }
    }

    public void forgetAllZoomInfo() {
        this.sizes.clear();
        this.sizeZooms.clear();
        this.locations.clear();
        this.locationZooms.clear();
        this.fonts.keys().foreach(component -> {
            if (!(component instanceof View)) {
                this.fonts.remove(component);
                this.fontZooms.remove(component);
                return;
            }
        });
    }

    public void updateZoomInfo(Component component) {
        Container container = component.getParent();
        if (container instanceof WidgetWrapperInterface) {
            Container wrapper = (Container)((Object)((WidgetWrapperInterface)((Object)container)));
            this.sizes.get((Object)component).foreach(size -> {
                Dimension dimension = component.getSize();
                Dimension dimension2 = this.zoomSize((Dimension)size, BoxesRunTime.unboxToDouble((Object)this.sizeZooms.apply((Object)component)), this.zoomFactor());
                if (dimension == null ? dimension2 != null : !((Object)dimension).equals(dimension2)) {
                    this.sizes.$minus$eq((Object)component);
                    this.sizeZooms.$minus$eq((Object)component);
                    return;
                }
            });
            this.locations.get((Object)component).foreach(location -> {
                Point point = ((WidgetWrapperInterface)((Object)wrapper)).getUnselectedLocation();
                Point point2 = this.zoomLocation((Point)location, BoxesRunTime.unboxToDouble((Object)this.locationZooms.apply((Object)component)), this.zoomFactor());
                if (point == null ? point2 != null : !((Object)point).equals(point2)) {
                    this.locations.$minus$eq((Object)component);
                    this.locationZooms.$minus$eq((Object)component);
                    return;
                }
            });
            Component component2 = component;
            if (component2 instanceof ViewWidget) {
                ViewWidget v = (ViewWidget)component2;
                this.fonts.remove((Object)v.view());
                this.fontZooms.remove((Object)v.view());
                return;
            }
            return;
        }
    }

    public Rectangle getUnzoomedBounds(Component component) {
        Dimension dimension;
        Point point;
        Option option;
        Rectangle r = component.getBounds();
        if (component.getParent() != null) {
            r.x += component.getParent().getLocation().x;
            r.y += component.getParent().getLocation().y;
        }
        if ((option = this.locations.get((Object)component)) instanceof Some) {
            Point location = (Point)((Some)option).value();
            point = this.zoomLocation(location, BoxesRunTime.unboxToDouble((Object)this.locationZooms.apply((Object)component)), 1.0);
        } else if (None$.MODULE$.equals(option)) {
            point = this.zoomLocation(r.getLocation(), this.zoomFactor(), 1.0);
        } else {
            throw new MatchError((Object)option);
        }
        Point unzoomedLocation = point;
        Option option2 = this.sizes.get((Object)component);
        if (option2 instanceof Some) {
            Dimension size = (Dimension)((Some)option2).value();
            dimension = this.zoomSize(size, BoxesRunTime.unboxToDouble((Object)this.sizeZooms.apply((Object)component)), 1.0);
        } else if (None$.MODULE$.equals(option2)) {
            dimension = this.zoomSize(r.getSize(), this.zoomFactor(), 1.0);
        } else {
            throw new MatchError((Object)option2);
        }
        Dimension unzoomedSize = dimension;
        return new Rectangle(unzoomedLocation, unzoomedSize);
    }

    public int getFontForSave(Component component) {
        Option option = this.fonts.get((Object)component);
        if (option instanceof Some) {
            Font font = (Font)((Some)option).value();
            return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)font.getSize() / BoxesRunTime.unboxToDouble((Object)this.fontZooms.apply((Object)component))));
        }
        if (None$.MODULE$.equals(option)) {
            return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)component.getFont().getSize() / this.zoomFactor()));
        }
        throw new MatchError((Object)option);
    }
}

