/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.nlogo.agent.Agent;
import org.nlogo.agent.ImporterJ;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.World;
import org.nlogo.api.AggregateManagerInterface;
import org.nlogo.api.Exceptions;
import org.nlogo.api.ExportPlotWarningAction;
import org.nlogo.api.ExportPlotWarningActionJ;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExternalResourceManager;
import org.nlogo.api.GlobalsIdentifier;
import org.nlogo.api.HubNetWorkspaceInterface;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LocalFile;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoThunkFactory;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.PreviewCommands;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.core.CompilerException;
import org.nlogo.core.Femto;
import org.nlogo.core.File;
import org.nlogo.core.FileModeJ;
import org.nlogo.core.I18N;
import org.nlogo.core.UpdateMode;
import org.nlogo.core.UpdateModeJ;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.EditorWorkspace;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerInterface;
import org.nlogo.nvm.MutableLong;
import org.nlogo.nvm.PresentationCompilerInterface;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import org.nlogo.workspace.BufferedReaderImporter;
import org.nlogo.workspace.Evaluator;
import org.nlogo.workspace.ExtendableWorkspace;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.JarLoader;
import scala.Option;
import scala.collection.immutable.ListMap;
import scala.collection.mutable.WeakHashMap;

public abstract class AbstractWorkspace
implements Workspace,
EditorWorkspace,
ExtendableWorkspace,
LogoThunkFactory,
HubNetWorkspaceInterface,
GlobalsIdentifier {
    public final World _world;
    public final JobManagerInterface jobManager;
    public final Evaluator evaluator;
    public final ExtensionManager extensionManager;
    protected final ExternalResourceManager resourceManager;
    private boolean _shouldUpdatePlots = true;
    private boolean _triedToExportPlot = false;
    private ExportPlotWarningAction _exportPlotWarningAction = ExportPlotWarningActionJ.WARN();
    private PreviewCommands _previewCommands = PreviewCommands.DEFAULT();
    private static boolean isApp = false;
    public WeakHashMap<String, Procedure> codeBits = new WeakHashMap();
    private UpdateMode updateMode = UpdateModeJ.CONTINUOUS();

    @Override
    public abstract WeakHashMap<Job, WeakHashMap<Agent, WeakHashMap<Command, MutableLong>>> lastRunTimes();

    @Override
    public boolean shouldUpdatePlots() {
        return this._shouldUpdatePlots;
    }

    @Override
    public void setShouldUpdatePlots(boolean update) {
        this._shouldUpdatePlots = update;
    }

    @Override
    public boolean triedToExportPlot() {
        return this._triedToExportPlot;
    }

    @Override
    public void setTriedToExportPlot(boolean triedToExport) {
        this._triedToExportPlot = triedToExport;
    }

    @Override
    public ExportPlotWarningAction exportPlotWarningAction() {
        return this._exportPlotWarningAction;
    }

    @Override
    public void setExportPlotWarningAction(ExportPlotWarningAction action) {
        this._exportPlotWarningAction = action;
    }

    @Override
    public PreviewCommands previewCommands() {
        return this._previewCommands;
    }

    public void setPreviewCommands(PreviewCommands commands) {
        this._previewCommands = commands;
    }

    protected AbstractWorkspace(World world) {
        this._world = world;
        this.evaluator = new Evaluator(this);
        this.jobManager = (JobManagerInterface)Femto.getJ(JobManagerInterface.class, "org.nlogo.job.JobManager", new Object[]{this, world, world});
        this.extensionManager = new ExtensionManager(this, new JarLoader(this));
        this.resourceManager = new ExternalResourceManager();
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public boolean isExtensionName(String name) {
        return this.extensionManager.isExtensionName(name);
    }

    @Override
    public void importExtensionData(String name, List<String[]> data, ImportErrorHandler handler) throws ExtensionException {
        this.extensionManager.importExtensionData(name, data, handler);
    }

    @Override
    public ExternalResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void dispose() throws InterruptedException {
        this.jobManager.die();
        this.getExtensionManager().reset();
    }

    @Override
    public boolean warningMessage(String message) {
        System.err.println();
        System.err.println("WARNING: " + message);
        System.err.println();
        return true;
    }

    public static boolean isApp() {
        return isApp;
    }

    public static void isApp(boolean isApp) {
        AbstractWorkspace.isApp = isApp;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return null;
    }

    public static URL toURL(java.io.File file) throws MalformedURLException {
        return file.toURL();
    }

    @Override
    public abstract ListMap<String, Procedure> procedures();

    public abstract void setProcedures(ListMap<String, Procedure> var1);

    public abstract void init();

    @Override
    public abstract PresentationCompilerInterface compiler();

    public abstract AggregateManagerInterface aggregateManager();

    @Override
    public void joinForeverButtons(Agent agent) {
        this.jobManager.joinForeverButtons(agent);
    }

    @Override
    public void addJobFromJobThread(Job job) {
        this.jobManager.addJobFromJobThread(job);
    }

    @Override
    public abstract void magicOpen(String var1);

    @Override
    public Procedure compileForRun(String source, Context context, boolean reporter) throws CompilerException {
        String key = source + "@" + context.activation.procedure().args().size() + "@" + context.agentBit + (reporter ? "-reporter" : "-command");
        Option storedProc = this.codeBits.get((Object)key);
        if (storedProc.isEmpty()) {
            Procedure proc = this.evaluator.compileForRun(source, context, reporter);
            this.codeBits.put((Object)key, (Object)proc);
            return proc;
        }
        return (Procedure)storedProc.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkGlobalVariable(String name, List<Object> values) throws Exception {
        String upperName = name.toUpperCase(Locale.ENGLISH);
        if (!this._world.isDimensionVariable(upperName) && !name.equalsIgnoreCase("RANDOM-SEED")) {
            World world = this._world;
            synchronized (world) {
                if (this._world.observerOwnsIndexOf(upperName) == -1) {
                    throw new Exception(I18N.guiJ().getN("edit.behaviorSpace.noGlobal", name));
                }
            }
        }
        for (Object o : values) {
            try {
                this._world.observer().assertConstraint(this._world.observer().variableIndex(upperName), o);
            }
            catch (Exception e) {
                throw new Exception(I18N.guiJ().getN("edit.behaviorSpace.invalidValue", name));
            }
        }
    }

    public UpdateMode updateMode() {
        return this.updateMode;
    }

    public void updateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public abstract void openString(String var1) throws CompilerException, LogoException;

    public void halt() {
        this.jobManager.haltPrimary();
        this._world.displayOn(true);
    }

    @Override
    public abstract void requestDisplayUpdate(boolean var1);

    public abstract void breathe();

    @Override
    public void breathe(Context context) {
        this.breathe();
    }

    public abstract void sendOutput(OutputObject var1, boolean var2) throws LogoException;

    @Override
    public void setOutputAreaContents(String text) {
        try {
            this.clearOutput();
            if (text.length() > 0) {
                this.sendOutput(new OutputObject("", text, false, false), true);
            }
        }
        catch (LogoException e) {
            Exceptions.handle(e);
        }
    }

    @Override
    public abstract void clearDrawing();

    @Override
    public abstract void clearAll();

    protected abstract ImporterJ.ErrorHandler importerErrorHandler();

    @Override
    public void importWorld(String filename) throws IOException {
        this.clearAll();
        this.doImport(new BufferedReaderImporter(filename){

            @Override
            public void doImport(BufferedReader reader) throws IOException {
                AbstractWorkspace.this._world.importWorld(AbstractWorkspace.this.importerErrorHandler(), AbstractWorkspace.this, AbstractWorkspace.this.stringReader(), reader);
            }
        });
    }

    @Override
    public void importWorld(Reader reader) throws IOException {
        this.clearAll();
        this._world.importWorld(this.importerErrorHandler(), this, this.stringReader(), new BufferedReader(reader));
    }

    private final ImporterJ.StringReader stringReader() {
        return new ImporterJ.StringReader(){

            @Override
            public Object readFromString(String s) throws ImporterJ.StringReaderException {
                try {
                    return AbstractWorkspace.this.compiler().readFromString(s, AbstractWorkspace.this._world, AbstractWorkspace.this.extensionManager);
                }
                catch (CompilerException ex) {
                    throw new ImporterJ.StringReaderException(ex.getMessage());
                }
            }
        };
    }

    @Override
    public void importDrawing(String filename) throws IOException {
        this.doImport(new FileImporter(filename){

            @Override
            public void doImport(File file) throws IOException {
                AbstractWorkspace.this.importDrawing(file);
            }
        });
    }

    protected void importDrawing(File file) throws IOException {
        this.importDrawing(file.getInputStream());
    }

    protected void importDrawing(InputStream is) throws IOException {
        this.importDrawing(is, (Option<String>)Option.apply(null));
    }

    protected abstract void importDrawing(InputStream var1, Option<String> var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(BufferedReaderImporter importer) throws IOException {
        LocalFile file = new LocalFile(importer.filename());
        try {
            ((File)file).open(FileModeJ.READ());
            importer.doImport(file.reader());
        }
        finally {
            try {
                ((File)file).close(false);
            }
            catch (IOException ex2) {
                Exceptions.ignore(ex2);
            }
        }
    }

    protected void doImport(FileImporter importer) throws IOException {
        LocalFile newFile = new LocalFile(importer.filename);
        importer.doImport(newFile);
    }

    public String guessExportName(String defaultName) {
        String modelName = this.getModelFileName();
        if (modelName == null) {
            return defaultName;
        }
        int index = modelName.lastIndexOf(".nlogo");
        if (index > -1) {
            modelName = modelName.substring(0, index);
        }
        return modelName + " " + defaultName;
    }

    @Override
    public MersenneTwisterFast auxRNG() {
        return this._world.auxRNG();
    }

    @Override
    public MersenneTwisterFast mainRNG() {
        return this._world.mainRNG();
    }

    protected abstract class FileImporter {
        public String filename;

        FileImporter(String filename) {
            this.filename = filename;
        }

        public abstract void doImport(File var1) throws IOException;
    }
}

