/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.nvm.Procedure;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

public final class Benchmarker$
implements Serializable {
    private static final double Z;
    private static final double TOLERANCE;
    private static final DecimalFormat formatter;
    public static final Benchmarker$ MODULE$;

    private Benchmarker$() {
    }

    static {
        MODULE$ = new Benchmarker$();
        Z = 2.3263;
        TOLERANCE = 0.003;
        formatter = new DecimalFormat("0.000");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Benchmarker$.class);
    }

    public void benchmark(AbstractWorkspace workspace, int minTime, int maxTime) {
        ListBuffer times = new ListBuffer();
        Procedure goProcedure = workspace.compileCommands("ca benchmark");
        Procedure resultProcedure = workspace.compileReporter("result");
        SimpleJobOwner owner = new SimpleJobOwner("Benchmarker", workspace.world().mainRNG(), AgentKind$Observer$.MODULE$);
        LongRef lastChatterTime = LongRef.create((long)0L);
        this.warmUp$1(workspace, minTime, owner, goProcedure, resultProcedure);
        while (!this.done$1(minTime, times, maxTime)) {
            times.$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.goOnce$1(workspace, owner, goProcedure, resultProcedure)));
            if (this.done$1(minTime, times, maxTime)) continue;
            this.chatter$1(lastChatterTime, times);
        }
        this.debrief$1(lastChatterTime, workspace, times);
    }

    private final double goOnce$1(AbstractWorkspace workspace$1, SimpleJobOwner owner$1, Procedure goProcedure$1, Procedure resultProcedure$1) {
        workspace$1.runCompiledCommands(owner$1, goProcedure$1);
        double result = BoxesRunTime.unboxToDouble((Object)workspace$1.runCompiledReporter(owner$1, resultProcedure$1));
        if (!(result > 0.0)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return result;
    }

    private final double average$1(ListBuffer times$1) {
        return this.total$1(times$1) / (double)times$1.size();
    }

    private final double total$1(ListBuffer times$2) {
        return BoxesRunTime.unboxToDouble((Object)times$2.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final double squareOfDifference$1(ListBuffer times$3) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)times$3.map((Function1)(JFunction1.mcDD.sp & Serializable)time -> package$.MODULE$.pow(time - this.average$1(times$3), 2.0))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final double stddev$1(ListBuffer times$4) {
        return package$.MODULE$.sqrt(this.squareOfDifference$1(times$4) / (double)times$4.size());
    }

    private final int runs$1(ListBuffer times$9) {
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(2), (int)package$.MODULE$.ceil(package$.MODULE$.pow(Z * this.stddev$1(times$9) / (TOLERANCE * this.average$1(times$9)), 2.0)));
    }

    private final void warmUp$1(AbstractWorkspace workspace$2, int minTime$1, SimpleJobOwner owner$2, Procedure goProcedure$2, Procedure resultProcedure$2) {
        Predef$.MODULE$.println((Object)("(" + workspace$2.modelNameForDisplay() + ")"));
        System.gc();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(minTime$1 * 1000)) {
            this.goOnce$1(workspace$2, owner$2, goProcedure$2, resultProcedure$2);
        }
    }

    private final boolean done$1(int minTime$2, ListBuffer times$5, int maxTime$1) {
        return this.total$1(times$5) > (double)minTime$2 && (times$5.size() >= this.runs$1(times$5) || this.total$1(times$5) >= (double)maxTime$1);
    }

    private final void chatter$1(LongRef lastChatterTime$1, ListBuffer times$6) {
        if (System.currentTimeMillis() - lastChatterTime$1.elem > 10000L) {
            Predef$.MODULE$.println((Object)(BoxesRunTime.boxToInteger((int)times$6.size()).toString() + "/" + this.runs$1(times$6) + " (mean=" + formatter.format(this.average$1(times$6)) + ", stddev=" + formatter.format(this.stddev$1(times$6)) + ")"));
            lastChatterTime$1.elem = System.currentTimeMillis();
            return;
        }
    }

    private final void debrief$1(LongRef lastChatterTime$2, AbstractWorkspace workspace$3, ListBuffer times$7) {
        lastChatterTime$2.elem = 0L;
        this.chatter$1(lastChatterTime$2, times$7);
        Predef$.MODULE$.println((Object)("@@@ " + workspace$3.modelNameForDisplay() + ": " + formatter.format(this.average$1(times$7)) + (times$7.size() < this.runs$1(times$7) ? " (hit time limit)" : "")));
    }
}

