/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.World;
import org.nlogo.api.LocalFile;
import org.nlogo.core.CompilerException;
import org.nlogo.core.FileMode;
import org.nlogo.core.FileMode$None$;
import org.nlogo.core.FileMode$Read$;
import org.nlogo.core.I18N$;
import org.nlogo.nvm.FileManager;
import org.nlogo.nvm.ImportHandler;
import org.nlogo.workspace.ModelTracker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BufferedIterator;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class DefaultFileManager
implements FileManager {
    private final ModelTracker workspace;
    private Map<String, org.nlogo.core.File> openFiles;
    private Option<org.nlogo.core.File> _currentFile;
    private String _prefix;

    public DefaultFileManager(ModelTracker workspace) {
        this.workspace = workspace;
        this.openFiles = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this._currentFile = None$.MODULE$;
        this._prefix = "";
    }

    private ModelTracker workspace() {
        return this.workspace;
    }

    public Option<org.nlogo.core.File> _currentFile() {
        return this._currentFile;
    }

    public void _currentFile_$eq(Option<org.nlogo.core.File> x$1) {
        this._currentFile = x$1;
    }

    public String _prefix() {
        return this._prefix;
    }

    public void _prefix_$eq(String x$1) {
        this._prefix = x$1;
    }

    @Override
    public Option<org.nlogo.core.File> currentFile() {
        return this._currentFile();
    }

    @Override
    public String prefix() {
        return this._prefix();
    }

    @Override
    public String getErrorInfo() {
        return (String)this._currentFile().map((Function1 & Serializable)file -> {
            long position = file.pos();
            file.close(true);
            file.open(FileMode$Read$.MODULE$);
            int lineNumber = 1;
            long prevPosition = 0L;
            String lastLine = this.readLine();
            while (file.pos() < position) {
                ++lineNumber;
                prevPosition = file.pos();
                lastLine = this.readLine();
            }
            int charPos = (int)(position - prevPosition);
            if (charPos >= lastLine.length() && !this.eof()) {
                lastLine = this.readLine();
                charPos = 0;
                ++lineNumber;
            }
            this.closeCurrentFile();
            return " (line number " + lineNumber + ", character " + (charPos + 1) + ")";
        }).getOrElse(DefaultFileManager::getErrorInfo$$anonfun$2);
    }

    @Override
    public org.nlogo.core.File getFile(String filename) {
        return new LocalFile(filename);
    }

    @Override
    public void setPrefix(String setPrefix) {
        String string;
        String string2 = setPrefix;
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = "";
        } else {
            Function1 & Serializable asDirPath = (Function1 & Serializable)s -> s + (Comparable)(StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(s)) != File.separatorChar ? BoxesRunTime.boxToCharacter((char)File.separatorChar) : "");
            String newPrefix = (String)asDirPath.apply((Object)setPrefix);
            string = new File(newPrefix).isAbsolute() ? newPrefix : (String)asDirPath.apply((Object)this.relativeToAbsolute(newPrefix));
        }
        this._prefix_$eq(string);
    }

    @Override
    public void setPrefix(URL newPrefix) {
        this._prefix_$eq(newPrefix.toString());
    }

    @Override
    public String attachPrefix(String filename) {
        block3: {
            block2: {
                if (new File(filename).isAbsolute()) break block2;
                String string = this._prefix();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
            }
            return filename;
        }
        return this.relativeToAbsolute(filename);
    }

    @Override
    public boolean hasCurrentFile() {
        return this._currentFile().flatMap((Function1 & Serializable)f -> this.openFiles.get((Object)f.getAbsolutePath())).nonEmpty();
    }

    @Override
    public Option<org.nlogo.core.File> findOpenFile(String filename) {
        File newFile = new File(filename);
        return this.openFiles.get((Object)newFile.getAbsolutePath());
    }

    @Override
    public void ensureMode(FileMode openMode) {
        this._currentFile().fold((Function0 & Serializable)() -> {
            this.ensureMode$$anonfun$1();
            return BoxedUnit.UNIT;
        }, _$1 -> this.throwOnBadFileMode((org.nlogo.core.File)_$1, openMode));
    }

    @Override
    public boolean fileExists(String filePath) {
        return new File(filePath).exists();
    }

    @Override
    public void deleteFile(String filePath) {
        if (this.findOpenFile(filePath).nonEmpty()) {
            throw new IOException("You need to close the file before deletion");
        }
        File checkFile = new File(filePath);
        if (!checkFile.exists()) {
            throw new IOException(I18N$.MODULE$.errorsJ().get("org.nlogo.workspace.DefaultFileManager.cannotDeleteNonExistantFile"));
        }
        if (!checkFile.canWrite()) {
            throw new IOException("Modification to this file is denied.");
        }
        if (!checkFile.isFile()) {
            throw new IOException(I18N$.MODULE$.errorsJ().get("org.nlogo.workspace.DefaultFileManager.canOnlyDeleteFiles"));
        }
        if (!checkFile.delete()) {
            throw new IOException("Deletion failed.");
        }
    }

    @Override
    public void openFile(String newFileName) {
        this._currentFile_$eq((Option<org.nlogo.core.File>)((Option)Option$.MODULE$.apply((Object)this.attachPrefix(newFileName)).map((Function1 & Serializable)fullFileName -> this.findOpenFile((String)fullFileName).orElse(() -> this.openFile$$anonfun$1$$anonfun$1(fullFileName))).getOrElse(() -> DefaultFileManager.openFile$$anonfun$2(newFileName))));
    }

    @Override
    public void flushCurrentFile() {
        this._currentFile().fold((Function0 & Serializable)() -> {
            DefaultFileManager.flushCurrentFile$$anonfun$1();
            return BoxedUnit.UNIT;
        }, _$2 -> _$2.flush());
    }

    @Override
    public void closeCurrentFile() {
        this._currentFile().fold((Function0 & Serializable)() -> {
            DefaultFileManager.closeCurrentFile$$anonfun$1();
            return BoxedUnit.UNIT;
        }, file -> this.closeFile((org.nlogo.core.File)file));
        this._currentFile_$eq((Option<org.nlogo.core.File>)None$.MODULE$);
    }

    @Override
    public String readLine() {
        return (String)this._currentFile().map(((Function1 & Serializable)(Function1 & Serializable)file -> this.asReadableFile((org.nlogo.core.File)file)).andThen((Function1 & Serializable)file -> this.asFileNotAtEof((org.nlogo.core.File)file)).andThen((Function1 & Serializable)_$3 -> new BufferedFileCharIterator((org.nlogo.core.File)_$3)).andThen((Function1 & Serializable)_$4 -> DefaultFileManager.readToNewLineOrEof$1(_$4, DefaultFileManager.readToNewLineOrEof$default$2$1()))).getOrElse(this::readLine$$anonfun$5);
    }

    @Override
    public String readChars(int num) {
        Function1 & Serializable takeCharsFromFile = (Function1 & Serializable)file -> new BufferedFileCharIterator((org.nlogo.core.File)file).take(num).mkString();
        return (String)this._currentFile().map(((Function1 & Serializable)(Function1 & Serializable)file -> this.asReadableFile((org.nlogo.core.File)file)).andThen((Function1 & Serializable)file -> this.asFileNotAtEof((org.nlogo.core.File)file)).andThen((Function1)takeCharsFromFile)).getOrElse(this::readChars$$anonfun$3);
    }

    @Override
    public Object read(World world) {
        ImportHandler importHandler = new ImportHandler(world, this.workspace().getExtensionManager());
        Function1 & Serializable readLiteral = (Function1 & Serializable)file -> {
            Object object;
            long oldPos = file.pos();
            try {
                object = this.workspace().compiler().utilities().readFromFile((org.nlogo.core.File)file, importHandler);
            }
            catch (CompilerException ex) {
                file.pos_$eq(oldPos);
                throw ex;
            }
            return object;
        };
        return this._currentFile().map(((Function1 & Serializable)(Function1 & Serializable)file -> this.asReadableFile((org.nlogo.core.File)file)).andThen((Function1 & Serializable)file -> this.asFileNotAtEof((org.nlogo.core.File)file)).andThen((Function1)readLiteral)).getOrElse(this::read$$anonfun$3);
    }

    @Override
    public boolean eof() {
        return BoxesRunTime.unboxToBoolean((Object)this._currentFile().map(((Function1 & Serializable)(Function1 & Serializable)file -> this.asReadableFile((org.nlogo.core.File)file)).andThen((Function1 & Serializable)file -> this.updateFileEof((org.nlogo.core.File)file)).andThen((Function1 & Serializable)_$5 -> _$5.eof())).getOrElse(this::eof$$anonfun$4));
    }

    @Override
    public void closeAllFiles() {
        this.openFiles.values().foreach(file -> this.closeFile((org.nlogo.core.File)file));
        this._currentFile_$eq((Option<org.nlogo.core.File>)None$.MODULE$);
    }

    @Override
    public void writeOutputObject(OutputObject oo) {
        this._currentFile().fold((Function0 & Serializable)() -> {
            DefaultFileManager.writeOutputObject$$anonfun$1();
            return BoxedUnit.UNIT;
        }, _$6 -> _$6.getPrintWriter().print(oo.get()));
    }

    @Override
    public void handleModelChange() {
        Option$.MODULE$.apply((Object)this.workspace().getModelDir()).foreach(setPrefix -> this.setPrefix((String)setPrefix));
        try {
            this.closeAllFiles();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private org.nlogo.core.File asFileNotAtEof(org.nlogo.core.File file) {
        this.updateFileEof(file);
        if (file.eof()) {
            throw new EOFException();
        }
        return file;
    }

    private org.nlogo.core.File updateFileEof(org.nlogo.core.File file) {
        if (!file.eof()) {
            file.eof_$eq(!new BufferedFileCharIterator(file).hasNext());
        }
        return file;
    }

    private org.nlogo.core.File asReadableFile(org.nlogo.core.File file) {
        this.throwOnBadFileMode(file, FileMode$Read$.MODULE$);
        return file;
    }

    private void throwOnBadFileMode(org.nlogo.core.File file, FileMode openMode) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)file.mode(), (Object)openMode);
        if (tuple2 != null) {
            FileMode fileMode = (FileMode)tuple2._1();
            FileMode fileMode2 = (FileMode)tuple2._2();
            if (FileMode$None$.MODULE$.equals(fileMode)) {
                if (FileMode$None$.MODULE$.equals(fileMode2)) {
                    throw new IllegalArgumentException("must specify a valid file mode for opening");
                }
                FileMode mode = fileMode2;
                try {
                    file.open(mode);
                }
                catch (FileNotFoundException ex) {
                    throw new IOException("The file " + file.getAbsolutePath() + " cannot be found");
                }
                catch (IOException ex) {
                    throw new IOException(ex.getMessage());
                }
                return;
            }
            if (FileMode$Read$.MODULE$.equals(fileMode)) {
                FileMode expectedMode;
                FileMode fileMode3 = expectedMode = fileMode2;
                FileMode$Read$ fileMode$Read$ = FileMode$Read$.MODULE$;
                if (fileMode3 == null ? fileMode$Read$ != null : !fileMode3.equals(fileMode$Read$)) {
                    throw new IOException("You can only use READING primitives with this file");
                }
            }
            FileMode currentMode = fileMode;
            FileMode expectedMode = fileMode2;
            FileMode fileMode4 = currentMode;
            FileMode fileMode5 = expectedMode;
            if (fileMode4 == null ? fileMode5 != null : !fileMode4.equals(fileMode5)) {
                throw new IOException("You can only use WRITING primitives with this file");
            }
        }
    }

    private Nothing$ throwNoOpenFile() {
        throw new IOException(I18N$.MODULE$.errors().get("org.nlogo.workspace.DefaultFileManager.noOpenFile"));
    }

    private void closeFile(org.nlogo.core.File file) {
        this.openFiles = (Map)this.openFiles.$minus((Object)file.getAbsolutePath());
        file.close(true);
    }

    private String relativeToAbsolute(String newPath) {
        String string;
        try {
            string = new File(this._prefix() + File.separatorChar + newPath).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return string;
    }

    private static final String getErrorInfo$$anonfun$2() {
        throw new IOException();
    }

    private final void ensureMode$$anonfun$1() {
        throw this.throwNoOpenFile();
    }

    private final Option openFile$$anonfun$1$$anonfun$1(String fullFileName$1) {
        LocalFile createdFile = new LocalFile(fullFileName$1);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)createdFile.getAbsolutePath());
        this.openFiles = (Map)this.openFiles.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)createdFile));
        return Option$.MODULE$.apply((Object)createdFile);
    }

    private static final Option openFile$$anonfun$2(String newFileName$1) {
        throw new IOException("This filename is illegal, " + newFileName$1);
    }

    private static final void flushCurrentFile$$anonfun$1() {
        throw new IOException("There is no file to flush");
    }

    private static final void closeCurrentFile$$anonfun$1() {
        throw new IOException("There is no file to close");
    }

    private static final String readToNewLineOrEof$1(BufferedIterator iter, String acc) {
        while (iter.hasNext()) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(iter.next(), iter.head());
            if (tuple2 != null) {
                char c = tuple2._1$mcC$sp();
                if ('\r' == c) {
                    if ('\n' == tuple2._2$mcC$sp()) {
                        iter.next();
                        return acc;
                    }
                    return acc;
                }
                if ('\n' == c) {
                    return acc;
                }
                char c2 = c;
                acc = (String)acc + c2;
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
        return acc;
    }

    private static final String readToNewLineOrEof$default$2$1() {
        return "";
    }

    private final String readLine$$anonfun$5() {
        throw this.throwNoOpenFile();
    }

    private final String readChars$$anonfun$3() {
        throw this.throwNoOpenFile();
    }

    private final Object read$$anonfun$3() {
        throw this.throwNoOpenFile();
    }

    private final boolean eof$$anonfun$4() {
        throw this.throwNoOpenFile();
    }

    private static final void writeOutputObject$$anonfun$1() {
        throw new IOException();
    }

    public class BufferedFileCharIterator
    implements BufferedIterator<Object> {
        private final org.nlogo.core.File file;
        private final BufferedReader buffReader;

        public BufferedFileCharIterator(org.nlogo.core.File file) {
            this.file = file;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            BufferedIterator.$init$((BufferedIterator)this);
            this.buffReader = file.reader();
        }

        private int nextChar(boolean reset) {
            this.buffReader.mark(1);
            int i = this.buffReader.read();
            if (reset) {
                this.buffReader.reset();
            } else {
                this.file.pos_$eq(this.file.pos() + 1L);
            }
            return i;
        }

        private boolean nextChar$default$1() {
            return true;
        }

        public char head() {
            return (char)this.nextChar(this.nextChar$default$1());
        }

        public boolean hasNext() {
            return this.nextChar(this.nextChar$default$1()) != -1;
        }

        public char next() {
            return (char)this.nextChar(false);
        }
    }
}

