/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import org.nlogo.api.APIVersion$;
import org.nlogo.api.ClassManager;
import org.nlogo.api.Dump$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.Reporter;
import org.nlogo.core.CompilerException;
import org.nlogo.core.ErrorSource;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.Primitive;
import org.nlogo.core.PrimitiveCommand;
import org.nlogo.core.PrimitiveReporter;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$Command$;
import org.nlogo.core.TokenType$Reporter$;
import org.nlogo.workspace.ExtendableWorkspace;
import org.nlogo.workspace.ExtensionManager$ExtensionData$;
import org.nlogo.workspace.ExtensionManagerException;
import org.nlogo.workspace.ExtensionManagerException$ExtensionNotFound$;
import org.nlogo.workspace.ExtensionManagerException$UserHalted$;
import org.nlogo.workspace.ExtensionPrimitiveManager;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ExtensionManager
implements org.nlogo.nvm.ExtensionManager {
    private final ExtendableWorkspace workspace;
    private Seq<ExtensionLoader> loaders;
    private Map<URL, JarContainer> jars;
    private Set<JarContainer> liveJars;
    private Map<String, TokenType> typeCache;
    private Object obj;

    public ExtensionManager(ExtendableWorkspace workspace, ExtensionLoader loader) {
        this.workspace = workspace;
        this.loaders = (Seq)((SeqOps)new .colon.colon((Object)loader, (List)Nil$.MODULE$));
        this.jars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.liveJars = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JarContainer[0]));
        this.typeCache = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.obj = null;
    }

    public ExtendableWorkspace workspace() {
        return this.workspace;
    }

    @Override
    public boolean anyExtensionsLoaded() {
        return this.jars.nonEmpty();
    }

    @Override
    public java.lang.Iterable<ClassManager> loadedExtensions() {
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)this.jars.values().map((Function1 & Serializable)_$1 -> _$1.classManager())).asJava();
    }

    @Override
    public Seq<String> loadedExtensionNames() {
        return ((IterableOnceOps)this.jars.values().map((Function1 & Serializable)_$2 -> _$2.extensionName())).toSeq();
    }

    public void addLoader(ExtensionLoader alternateLoader) {
        this.loaders = (Seq)this.loaders.$colon$plus((Object)alternateLoader);
    }

    @Override
    public void storeObject(Object obj) {
        this.obj = obj;
    }

    @Override
    public Object retrieveObject() {
        return this.obj;
    }

    @Override
    public void importExtension(String extName, ErrorSource errors) throws CompilerException {
        try {
            Tuple2 tuple2 = (Tuple2)((Option)this.loaders.foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    if (None$.MODULE$.equals(option)) {
                        ExtensionLoader ldr = (ExtensionLoader)tuple2._2();
                        return ldr.locateExtension(extName).map((Function1 & Serializable)_$3 -> Tuple2$.MODULE$.apply(_$3, (Object)ldr));
                    }
                    if (option instanceof Some) {
                        Some location = (Some)option;
                        return location;
                    }
                }
                throw new MatchError((Object)tuple2);
            })).getOrElse(() -> ExtensionManager.$anonfun$2(extName));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            URL fileURL = (URL)tuple2._1();
            ExtensionLoader loader = (ExtensionLoader)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fileURL, (Object)loader);
            URL fileURL2 = (URL)tuple22._1();
            ExtensionLoader loader2 = (ExtensionLoader)tuple22._2();
            ExtensionData data = loader2.extensionData(extName, fileURL2);
            ObjectRef theJarContainer = ObjectRef.create((Object)this.jars.get((Object)fileURL2));
            ClassLoader myClassLoader = (ClassLoader)((Option)theJarContainer.elem).map((Function1 & Serializable)_$4 -> _$4.jarClassLoader()).getOrElse(() -> this.$anonfun$4(loader2, fileURL2));
            ClassManager classManager = (ClassManager)((Option)theJarContainer.elem).filter((Function1 & Serializable)_$5 -> _$5.loaded()).map((Function1 & Serializable)_$6 -> _$6.classManager()).getOrElse(() -> this.$anonfun$7(data, loader2, myClassLoader));
            boolean modifiedSinceLoad = ((Option)theJarContainer.elem).exists((Function1 & Serializable)_$7 -> _$7.modified() != (long)data.modified());
            if (modifiedSinceLoad) {
                ((Option)theJarContainer.elem).foreach(_$9 -> _$9.unload(this));
                theJarContainer.elem = Some$.MODULE$.apply((Object)this.initializeJarContainer(myClassLoader, data));
            } else if (((Option)theJarContainer.elem).isEmpty()) {
                theJarContainer.elem = Some$.MODULE$.apply((Object)this.initializeJarContainer(myClassLoader, data));
            }
            if (ExtensionManager.needsLoad$1(theJarContainer)) {
                ((Option)theJarContainer.elem).foreach(container -> container.load(classManager, this));
            }
            ((Option)theJarContainer.elem).foreach(_$10 -> {
                this.liveJars = (Set)this.liveJars.$plus(_$10);
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExtensionManagerException || throwable2 instanceof ExtensionException) {
                Exception ex = (Exception)throwable2;
                throw errors.signalError(ex.getMessage());
            }
            if (throwable2 instanceof IOException) {
                IOException ex = (IOException)throwable2;
                throw errors.signalError("There was a problem while reading extension " + extName);
            }
            if (throwable2 instanceof IncompatibleClassChangeError) {
                IncompatibleClassChangeError ex = (IncompatibleClassChangeError)throwable2;
                throw errors.signalError("This extension doesn't work with this version of NetLogo");
            }
            throw throwable;
        }
    }

    private JarContainer initializeJarContainer(ClassLoader classLoader, ExtensionData data) {
        JarContainer newJarContainer = new JarContainer(classLoader, data);
        URL uRL = (URL)Predef$.MODULE$.ArrowAssoc((Object)data.fileURL());
        this.jars = (Map)this.jars.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uRL, (Object)newJarContainer));
        return newJarContainer;
    }

    private ClassManager initializedClassManager(ClassManager cm) {
        ClassManager classManager;
        try {
            if (!this.workspace().compilerTestingMode()) {
                cm.runOnce(this);
            }
            classManager = cm;
        }
        catch (ExtensionException ex) {
            System.err.println("Error while initializing extension.");
            System.err.println("Error is: " + ex);
            throw ex;
        }
        return classManager;
    }

    @Override
    public Object readFromString(String source) throws CompilerException {
        return this.workspace().readFromString(source);
    }

    public void clearAll() {
        this.jars.values().foreach(jar -> jar.classManager().clearAll());
    }

    @Override
    public ExtensionObject readExtensionObject(String extName, String typeName, String value) throws CompilerException {
        String upcaseExtName = extName.toUpperCase(Locale.ENGLISH);
        return (ExtensionObject)((IterableOps)((IterableOps)this.jars.values().filter((Function1 & Serializable)theJarContainer -> {
            if (!theJarContainer.loaded()) return false;
            String string = theJarContainer.normalizedName();
            String string2 = upcaseExtName;
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        })).map(ExtensionManager.catchExtensionException$1(upcaseExtName, typeName, value, (Function1 & Serializable)_$11 -> _$11.classManager().readExtensionObject(this, typeName, value)))).headOption().getOrElse(ExtensionManager::readExtensionObject$$anonfun$3);
    }

    @Override
    public Primitive replaceIdentifier(String name) {
        Tuple2 tuple2;
        Object object;
        String[] stringArray = name.split(":");
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String prefix = string;
            String pname = string2;
            tuple2 = Tuple2$.MODULE$.apply((Object)pname, (Function1 & Serializable)jc -> {
                String string = prefix.toUpperCase(Locale.ENGLISH);
                String string2 = jc.normalizedName();
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)name, (Function1 & Serializable)jc -> jc.primManager().autoImportPrimitives());
        }
        Tuple2 tuple22 = tuple2;
        String primName = (String)tuple22._1();
        Function1 isRelevantJar = (Function1)tuple22._2();
        Set<JarContainer> set = this.liveJars;
        return (Primitive)((IterableOps)((IterableOps)((IterableOps)this.jars.values().filter((Function1 & Serializable)elem -> set.contains(elem))).filter(isRelevantJar)).flatMap((Function1 & Serializable)jar -> Option$.MODULE$.apply((Object)jar.primManager().getPrimitive(primName)))).headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void org$nlogo$workspace$ExtensionManager$$cacheType(String name, Primitive primitive) {
        Primitive primitive2 = primitive;
        if (primitive2 instanceof PrimitiveCommand) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
            this.typeCache = (Map)this.typeCache.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)TokenType$Command$.MODULE$));
            return;
        }
        if (primitive2 instanceof PrimitiveReporter) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
            this.typeCache = (Map)this.typeCache.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)TokenType$Reporter$.MODULE$));
            return;
        }
    }

    public void org$nlogo$workspace$ExtensionManager$$removeCachedType(String name) {
        this.typeCache = (Map)this.typeCache.$minus((Object)name);
    }

    @Override
    public Option<TokenType> cachedType(String name) {
        return this.typeCache.get((Object)name.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public Set<String> extensionCommandNames() {
        return ((IterableOnceOps)((IterableOps)this.typeCache.filter((Function1 & Serializable)_$12 -> {
            Object object = _$12._2();
            TokenType$Command$ tokenType$Command$ = TokenType$Command$.MODULE$;
            return !(object != null ? !object.equals(tokenType$Command$) : tokenType$Command$ != null);
        })).map((Function1 & Serializable)_$13 -> (String)_$13._1())).toSet();
    }

    @Override
    public Set<String> extensionReporterNames() {
        return ((IterableOnceOps)((IterableOps)this.typeCache.filter((Function1 & Serializable)_$14 -> {
            Object object = _$14._2();
            TokenType$Reporter$ tokenType$Reporter$ = TokenType$Reporter$.MODULE$;
            return !(object != null ? !object.equals(tokenType$Reporter$) : tokenType$Reporter$ != null);
        })).map((Function1 & Serializable)_$15 -> (String)_$15._1())).toSet();
    }

    @Override
    public String dumpExtensions() {
        return this.tabulate((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)"EXTENSION", (List)new .colon.colon((Object)"LOADED", (List)new .colon.colon((Object)"MODIFIED", (List)new .colon.colon((Object)"JARPATH", (List)Nil$.MODULE$)))))), (Function1<JarContainer, Seq<Seq<String>>>)(Function1 & Serializable)jarContainer -> (Seq)((SeqOps)new .colon.colon((Object)((Seq)((SeqOps)new .colon.colon((Object)jarContainer.extensionName(), (List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)jarContainer.loaded()).toString(), (List)new .colon.colon((Object)BoxesRunTime.boxToLong((long)jarContainer.modified()).toString(), (List)new .colon.colon((Object)jarContainer.fileURL().toString(), (List)Nil$.MODULE$)))))), (List)Nil$.MODULE$)));
    }

    @Override
    public String dumpExtensionPrimitives() {
        return this.tabulate((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)"EXTENSION", (List)new .colon.colon((Object)"PRIMITIVE", (List)new .colon.colon((Object)"TYPE", (List)Nil$.MODULE$))))), (Function1<JarContainer, Seq<Seq<String>>>)(Function1 & Serializable)jarContainer -> CollectionConverters$.MODULE$.IteratorHasAsScala(jarContainer.primManager().getPrimitiveNames()).asScala().map((Function1 & Serializable)n -> {
            Primitive p = jarContainer.primManager().getPrimitive((String)n);
            return (Seq)((SeqOps)new .colon.colon((Object)jarContainer.extensionName(), (List)new .colon.colon(n, (List)new .colon.colon((Object)(p instanceof Reporter ? "Reporter" : "Command"), (List)Nil$.MODULE$))));
        }).toSeq());
    }

    @Override
    public void reset() {
        this.jars.values().foreach(jar -> {
            jar.unload(this);
            ClassLoader classLoader = jar.jarClassLoader();
            if (classLoader instanceof Closeable) {
                ClassLoader closeable = (ClassLoader)((Object)((Closeable)((Object)classLoader)));
                try {
                    ((Closeable)((Object)closeable)).close();
                }
                catch (IOException e) {
                    String error = "Error while unloading extension " + e.getMessage() + " (this can probably be ignored)";
                    System.err.println(error);
                }
                return;
            }
        });
        this.jars = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.liveJars = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JarContainer[0]));
    }

    private String tabulate(Seq<String> header, Function1<JarContainer, Seq<Seq<String>>> generateRows) {
        Seq separator = (Seq)header.map((Function1 & Serializable)n -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), n.length()));
        Iterable rows = (Iterable)this.jars.values().flatMap(generateRows);
        return ((IterableOnceOps)((IterableOps)((SeqOps)new .colon.colon(header, (List)new .colon.colon((Object)separator, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)rows)).map((Function1 & Serializable)_$16 -> _$16.mkString("\t"))).mkString("", "\n", "\n");
    }

    @Override
    public void startFullCompilation() {
        this.liveJars = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JarContainer[0]));
    }

    @Override
    public void finishFullCompilation() {
        this.jars.values().foreach(nextJarContainer -> {
            if (nextJarContainer.loaded() && !this.liveJars.contains(nextJarContainer)) {
                this.jars = (Map)this.jars.$minus((Object)nextJarContainer.fileURL());
                nextJarContainer.unload(this);
                return;
            }
        });
    }

    private void checkVersion(Option<String> extensionVer) {
        boolean shouldContinue;
        boolean bl;
        String currentVer = APIVersion$.MODULE$.version();
        if (extensionVer.isEmpty()) {
            bl = this.workspace().warningMessage(StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Could not determine version of NetLogo extension.\n             |NetLogo can try to load the extension, but it might not work.")))).mkString(" "));
        } else {
            String string = currentVer;
            Object object = extensionVer.get();
            bl = (string == null ? object != null : !string.equals(object)) ? this.workspace().warningMessage(StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|You are attempting to open a NetLogo extension file that was created\n              |for a different version of the NetLogo Extension API.\n              |(This NetLogo uses Extension API " + currentVer + ";\n              |the extension uses NetLogo Extension API " + extensionVer.get() + ".)\n              |NetLogo can try to load the extension, but it might not work.")))).mkString(" ")) : (shouldContinue = true);
        }
        if (!shouldContinue) {
            throw new ExtensionManagerException(ExtensionManagerException$UserHalted$.MODULE$);
        }
    }

    public void exportWorld(PrintWriter writer) {
        writer.println(Dump$.MODULE$.csv().encode("EXTENSIONS"));
        writer.println();
        this.jars.values().foreach(container -> {
            StringBuilder data = container.classManager().exportWorld();
            if (data.length() > 0) {
                writer.println(Dump$.MODULE$.csv().encode(container.extensionName()));
                writer.print(data);
                writer.println();
                return;
            }
        });
    }

    public void importExtensionData(String name, java.util.List<String[]> data, ImportErrorHandler handler) throws ExtensionException {
        JarContainer jar = (JarContainer)this.getJarContainerByIdentifier(name).getOrElse(() -> ExtensionManager.$anonfun$12(name));
        jar.classManager().importWorld(data, this, handler);
    }

    public boolean isExtensionName(String name) {
        return this.getJarContainerByIdentifier(name).nonEmpty();
    }

    private Option<JarContainer> getJarContainerByIdentifier(String identifier) {
        return this.jars.values().find((Function1 & Serializable)_$17 -> _$17.extensionName().equalsIgnoreCase(identifier));
    }

    private static final Tuple2 $anonfun$2(String extName$2) {
        throw new ExtensionManagerException(ExtensionManagerException$ExtensionNotFound$.MODULE$.apply(extName$2));
    }

    private final ClassLoader $anonfun$4(ExtensionLoader loader$1, URL fileURL$2) {
        return loader$1.extensionClassLoader(fileURL$2, this.getClass().getClassLoader());
    }

    private final ClassManager $anonfun$7(ExtensionData data$1, ExtensionLoader loader$2, ClassLoader myClassLoader$1) {
        this.checkVersion(data$1.version());
        return this.initializedClassManager(loader$2.extensionClassManager(myClassLoader$1, data$1));
    }

    private static final boolean needsLoad$1(ObjectRef theJarContainer$1) {
        return !((Option)theJarContainer$1.elem).exists((Function1 & Serializable)_$8 -> _$8.loaded());
    }

    private static final Function1 catchExtensionException$1(String upcaseExtName$2, String typeName$2, String value$2, Function1 f) {
        return (Function1 & Serializable)j -> {
            ExtensionObject extensionObject;
            try {
                extensionObject = (ExtensionObject)f.apply(j);
            }
            catch (ExtensionException ex) {
                System.err.println(ex);
                throw new IllegalStateException("Error reading extension object " + upcaseExtName$2 + ":" + typeName$2 + " " + value$2 + " ==> " + ex.getMessage());
            }
            return extensionObject;
        };
    }

    private static final ExtensionObject readExtensionObject$$anonfun$3() {
        return null;
    }

    private static final JarContainer $anonfun$12(String name$1) {
        throw new ExtensionException("there is no extension named " + name$1 + " in this model");
    }

    public static class ExtensionData
    implements Product,
    Serializable {
        private final String extensionName;
        private final URL fileURL;
        private final String prefix;
        private final String classManagerName;
        private final Option<String> version;
        private final long modifiedRaw;
        private final int modified;

        public static ExtensionData apply(String string, URL uRL, String string2, String string3, Option<String> option, long l) {
            return ExtensionManager$ExtensionData$.MODULE$.apply(string, uRL, string2, string3, option, l);
        }

        public static ExtensionData fromProduct(Product product) {
            return ExtensionManager$ExtensionData$.MODULE$.fromProduct(product);
        }

        public static ExtensionData unapply(ExtensionData extensionData) {
            return ExtensionManager$ExtensionData$.MODULE$.unapply(extensionData);
        }

        public ExtensionData(String extensionName, URL fileURL, String prefix, String classManagerName, Option<String> version, long modifiedRaw) {
            this.extensionName = extensionName;
            this.fileURL = fileURL;
            this.prefix = prefix;
            this.classManagerName = classManagerName;
            this.version = version;
            this.modifiedRaw = modifiedRaw;
            this.modified = 1000 * Math.round((float)modifiedRaw / (float)1000);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.extensionName()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fileURL()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.prefix()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.classManagerName()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.version()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.modifiedRaw()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExtensionData)) return false;
            ExtensionData extensionData = (ExtensionData)object;
            if (this.modifiedRaw() != extensionData.modifiedRaw()) return false;
            String string = this.extensionName();
            String string2 = extensionData.extensionName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            URL uRL = this.fileURL();
            URL uRL2 = extensionData.fileURL();
            if (uRL == null) {
                if (uRL2 != null) {
                    return false;
                }
            } else if (!((Object)uRL).equals(uRL2)) return false;
            String string3 = this.prefix();
            String string4 = extensionData.prefix();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.classManagerName();
            String string6 = extensionData.classManagerName();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Option<String> option = this.version();
            Option<String> option2 = extensionData.version();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!extensionData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExtensionData;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "ExtensionData";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "extensionName";
                }
                case 1: {
                    return "fileURL";
                }
                case 2: {
                    return "prefix";
                }
                case 3: {
                    return "classManagerName";
                }
                case 4: {
                    return "version";
                }
                case 5: {
                    return "modifiedRaw";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String extensionName() {
            return this.extensionName;
        }

        public URL fileURL() {
            return this.fileURL;
        }

        public String prefix() {
            return this.prefix;
        }

        public String classManagerName() {
            return this.classManagerName;
        }

        public Option<String> version() {
            return this.version;
        }

        private long modifiedRaw() {
            return this.modifiedRaw;
        }

        public int modified() {
            return this.modified;
        }

        public ExtensionData copy(String extensionName, URL fileURL, String prefix, String classManagerName, Option<String> version, long modifiedRaw) {
            return new ExtensionData(extensionName, fileURL, prefix, classManagerName, version, modifiedRaw);
        }

        public String copy$default$1() {
            return this.extensionName();
        }

        public URL copy$default$2() {
            return this.fileURL();
        }

        public String copy$default$3() {
            return this.prefix();
        }

        public String copy$default$4() {
            return this.classManagerName();
        }

        public Option<String> copy$default$5() {
            return this.version();
        }

        public long copy$default$6() {
            return this.modifiedRaw();
        }

        public String _1() {
            return this.extensionName();
        }

        public URL _2() {
            return this.fileURL();
        }

        public String _3() {
            return this.prefix();
        }

        public String _4() {
            return this.classManagerName();
        }

        public Option<String> _5() {
            return this.version();
        }

        public long _6() {
            return this.modifiedRaw();
        }
    }

    public static interface ExtensionLoader {
        public Option<URL> locateExtension(String var1);

        public ExtensionData extensionData(String var1, URL var2);

        public ClassLoader extensionClassLoader(URL var1, ClassLoader var2);

        public ClassManager extensionClassManager(ClassLoader var1, ExtensionData var2);
    }

    public static class JarContainer {
        private final ClassLoader jarClassLoader;
        private final String extensionName;
        private final String normalizedName;
        private final URL fileURL;
        private final long modified;
        private final ExtensionPrimitiveManager primManager;
        private ClassManager classManager;
        private boolean loaded;

        public JarContainer(ClassLoader jarClassLoader, ExtensionData data) {
            this.jarClassLoader = jarClassLoader;
            this.extensionName = data.extensionName();
            this.normalizedName = data.extensionName().toUpperCase(Locale.ENGLISH);
            this.fileURL = data.fileURL();
            this.modified = Int$.MODULE$.int2long(data.modified());
            this.primManager = new ExtensionPrimitiveManager(this.extensionName());
            this.classManager = null;
            this.loaded = false;
        }

        public ClassLoader jarClassLoader() {
            return this.jarClassLoader;
        }

        public String extensionName() {
            return this.extensionName;
        }

        public String normalizedName() {
            return this.normalizedName;
        }

        public URL fileURL() {
            return this.fileURL;
        }

        public long modified() {
            return this.modified;
        }

        public ExtensionPrimitiveManager primManager() {
            return this.primManager;
        }

        public ClassManager classManager() {
            return this.classManager;
        }

        public void classManager_$eq(ClassManager x$1) {
            this.classManager = x$1;
        }

        public boolean loaded() {
            return this.loaded;
        }

        public void loaded_$eq(boolean x$1) {
            this.loaded = x$1;
        }

        public void load(ClassManager instantiatedClassManager, ExtensionManager extensionManager) {
            this.loaded_$eq(true);
            this.classManager_$eq(instantiatedClassManager);
            this.classManager().load(this.primManager());
            this.primManager().importedPrimitives().foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Primitive p = (Primitive)tuple2._2();
                    extensionManager.org$nlogo$workspace$ExtensionManager$$cacheType(this.primName(name), p);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private String primName(String name) {
            if (this.primManager().autoImportPrimitives()) {
                return name.toUpperCase(Locale.ENGLISH);
            }
            return this.extensionName().toUpperCase(Locale.ENGLISH) + ":" + name.toUpperCase(Locale.ENGLISH);
        }

        public void unload(ExtensionManager extensionManager) {
            this.loaded_$eq(false);
            try {
                this.primManager().importedPrimitives().foreach(x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        Primitive p = (Primitive)tuple2._2();
                        extensionManager.org$nlogo$workspace$ExtensionManager$$removeCachedType(this.primName(name));
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.classManager().unload(extensionManager);
            }
            catch (Exception ex) {
                Exceptions$.MODULE$.ignore(ex);
            }
        }
    }
}

