/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import org.nlogo.core.View;
import org.nlogo.core.WorldDimensions;
import org.nlogo.workspace.WorldLoaderInterface;
import scala.Predef$;
import scala.runtime.RichInt$;

public class WorldLoader {
    public void load(View view, WorldLoaderInterface worldInterface) {
        WorldDimensions d = view.dimensions();
        worldInterface.tickCounterLabel(view.tickCounterLabel());
        worldInterface.showTickCounter(view.showTickCounter());
        worldInterface.setDimensions(d, this.adjustPatchSize(worldInterface, d));
        worldInterface.clearTurtles();
        worldInterface.fontSize(view.fontSize());
        worldInterface.changeTopology(d.wrappingAllowedInX(), d.wrappingAllowedInY());
        worldInterface.updateMode(view.updateMode());
        worldInterface.frameRate(view.frameRate());
        worldInterface.setSize(view.width(), view.height());
    }

    public int getWidth(WorldLoaderInterface world, WorldDimensions d, View v) {
        int widgetWidth = world.calculateWidth(d.width(), d.patchSize());
        int minWidth = world.getMinimumWidth();
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(widgetWidth), minWidth);
    }

    public int getHeight(WorldLoaderInterface world, WorldDimensions d, double patchSize, View v) {
        return world.calculateHeight(d.height(), patchSize);
    }

    public double adjustPatchSize(WorldLoaderInterface world, WorldDimensions d) {
        int minWidth;
        int widgetWidth = world.calculateWidth(d.width(), d.patchSize());
        if (widgetWidth < (minWidth = world.getMinimumWidth())) {
            return world.computePatchSize(minWidth - world.insetWidth(), d.width());
        }
        return d.patchSize();
    }
}

