/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.time.datatypes;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.extensions.time.DateType;
import org.nlogo.extensions.time.Exact$;
import org.nlogo.extensions.time.GetTSMethod;
import org.nlogo.extensions.time.LinearInterp$;
import org.nlogo.extensions.time.Milli$;
import org.nlogo.extensions.time.Nearest$;
import org.nlogo.extensions.time.datatypes.LogoTime;
import org.nlogo.extensions.time.datatypes.LogoTimeComparator$;
import org.nlogo.extensions.time.datatypes.TimeSeriesColumn;
import org.nlogo.extensions.time.datatypes.TimeSeriesRecord;
import org.nlogo.nvm.ExtensionContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.LinkedHashMap;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;

public class LogoTimeSeries
implements ExtensionObject {
    private final LogoTimeComparator$ logoComparator = LogoTimeComparator$.MODULE$;
    private TreeMap<LogoTime, TimeSeriesRecord> times = new TreeMap((Ordering)this.logoComparator());
    private LinkedHashMap<String, TimeSeriesColumn> scacolumns = new LinkedHashMap();
    private int numRows = 0;

    public LogoTimeSeries() {
    }

    public LogoTimeComparator$ logoComparator() {
        return this.logoComparator;
    }

    public TreeMap<LogoTime, TimeSeriesRecord> times() {
        return this.times;
    }

    public void times_$eq(TreeMap<LogoTime, TimeSeriesRecord> x$1) {
        this.times = x$1;
    }

    public LinkedHashMap<String, TimeSeriesColumn> scacolumns() {
        return this.scacolumns;
    }

    public void scacolumns_$eq(LinkedHashMap<String, TimeSeriesColumn> x$1) {
        this.scacolumns = x$1;
    }

    public int numRows() {
        return this.numRows;
    }

    public void numRows_$eq(int x$1) {
        this.numRows = x$1;
    }

    public LogoTimeSeries(LogoList colNames) {
        this();
        colNames.foreach((Function1 & Serializable)colName -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)colName.toString());
            return (LinkedHashMap)this.scacolumns().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new TimeSeriesColumn()));
        });
    }

    public LogoTimeSeries(String filename, Option<String> customFormat, ExtensionContext context) {
        this();
        this.parseTimeSeriesFile(filename, customFormat, context);
    }

    public LogoTimeSeries(String filename, ExtensionContext context) {
        this();
        this.parseTimeSeriesFile(filename, context);
    }

    public void add(LogoTime time, LogoList list) {
        int index = this.times().size();
        TimeSeriesRecord record = new TimeSeriesRecord(time, index);
        ((IterableOnceOps)this.scacolumns().keySet().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String colName = (String)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                ((TimeSeriesColumn)this.scacolumns().getOrElse((Object)colName, LogoTimeSeries::add$$anonfun$1$$anonfun$1)).add(list.get(index).toString());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        try {
            LogoTime logoTime = (LogoTime)Predef$.MODULE$.ArrowAssoc((Object)time);
            this.times_$eq((TreeMap<LogoTime, TimeSeriesRecord>)((TreeMap)this.times().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)logoTime, (Object)record))));
        }
        catch (NullPointerException e) {
            DateType dateType = time.dateType();
            DateType dateType2 = ((LogoTime[])this.times().keySet().toArray(package$.MODULE$.classTag(ClassTag$.MODULE$.apply(LogoTime.class))))[0].dateType();
            if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
                throw new ExtensionException("date type mismatch " + time.dateType());
            }
            throw e;
        }
    }

    public Integer getNumColumns() {
        return Predef$.MODULE$.int2Integer(this.scacolumns().size());
    }

    public void write(String filename, ExtensionContext context) {
        char c = filename.charAt(0);
        File dataFile = '/' == c ? new File(filename) : ('\\' == c ? new File(filename) : (context.workspace().getModelDir() == null ? new File("./" + filename) : new File(context.workspace().getModelDir() + "/" + filename)));
        FileWriter fw = new FileWriter(dataFile.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("TIMESTAMP");
        this.scacolumns().keySet().foreach((Function1)(JProcedure1 & Serializable)colName -> bw.write("," + colName));
        bw.write("\n");
        this.times().keySet().foreach((Function1)(JProcedure1 & Serializable)logoTime -> {
            TimeSeriesRecord time = (TimeSeriesRecord)this.times().getOrElse(logoTime, () -> LogoTimeSeries.$anonfun$1(logoTime));
            bw.write(time.time().dump(false, false, false));
            this.scacolumns().keySet().foreach((Function1)(JProcedure1 & Serializable)colName -> bw.write("," + ((TimeSeriesColumn)this.scacolumns().getOrElse(colName, () -> LogoTimeSeries.write$$anonfun$2$$anonfun$1$$anonfun$1(colName))).data().apply(time.dataIndex())));
            bw.write("\n");
        });
        bw.flush();
        bw.close();
    }

    public void parseTimeSeriesFile(String filename, ExtensionContext context) {
        this.parseTimeSeriesFile(filename, (Option<String>)None$.MODULE$, context);
    }

    public void parseTimeSeriesFile(String filename, Option<String> customFormat, ExtensionContext context) {
        Try try_ = Try$.MODULE$.apply(() -> LogoTimeSeries.parseTimeSeriesFile$$anonfun$1(context, filename));
        if (try_ instanceof Success) {
            BufferedSource bufferedSource = (BufferedSource)((Success)try_).value();
            IntRef ind = IntRef.create((int)0);
            ObjectRef columnNames = ObjectRef.create((Object)new String[0]);
            bufferedSource.getLines().foreach((Function1)(JProcedure1 & Serializable)line -> Breaks$.MODULE$.breakable((Function0 & Serializable)() -> {
                this.parseTimeSeriesFile$$anonfun$2$$anonfun$1((String)line, ind, columnNames, (Option)customFormat);
                return BoxedUnit.UNIT;
            }));
            return;
        }
        if (try_ instanceof Failure) {
            throw new ExtensionException("File cannot be saved without loading/saving a model");
        }
        throw new MatchError((Object)try_);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public Object getByTime(LogoTime time, String columnName, GetTSMethod getMethod) {
        LogoTime logoTime;
        ObjectRef higherKey;
        ObjectRef lowerKey;
        ObjectRef finalKey;
        ArrayList<LogoTime> resultList;
        ArrayList<String> columnList;
        block9: {
            Option option;
            block10: {
                LogoTime logoTime2;
                Try try_;
                Try try_2;
                Tuple2 tuple2;
                block11: {
                    LogoTime lowerKey2;
                    block12: {
                        boolean bl;
                        columnList = new ArrayList<String>(this.scacolumns().size());
                        resultList = new ArrayList<LogoTime>(this.scacolumns().size());
                        String string = columnName;
                        String string2 = "ALL_-_COLUMNS";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            bl = columnList.addAll(CollectionConverters$.MODULE$.SetHasAsJava(this.scacolumns().keySet()).asJava());
                        } else {
                            if (!this.scacolumns().contains((Object)columnName)) {
                                throw new ExtensionException("The LogoTimeSeries does not contain the column " + columnName);
                            }
                            bl = columnList.add(columnName);
                        }
                        finalKey = ObjectRef.create(null);
                        lowerKey = ObjectRef.create(null);
                        higherKey = ObjectRef.create(null);
                        option = this.times().get((Object)time);
                        if (!None$.MODULE$.equals(option)) break block10;
                        tuple2 = Tuple2$.MODULE$.apply((Object)Try$.MODULE$.apply(() -> this.getByTime$$anonfun$1(time)), (Object)Try$.MODULE$.apply(() -> this.getByTime$$anonfun$2(time)));
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        try_2 = (Try)tuple2._1();
                        try_ = (Try)tuple2._2();
                        if (!(try_2 instanceof Failure)) break block11;
                        if (!(try_ instanceof Failure)) break block12;
                        logoTime = time;
                        break block9;
                    }
                    if (!(try_ instanceof Success)) break block11;
                    logoTime = lowerKey2 = (LogoTime)((Success)try_).value();
                    break block9;
                }
                if (!(try_2 instanceof Success)) throw new MatchError((Object)tuple2);
                LogoTime higherKey2 = logoTime2 = (LogoTime)((Success)try_2).value();
                if (try_ instanceof Failure) {
                    logoTime = higherKey2;
                    break block9;
                } else {
                    LogoTime higherKey3 = logoTime2;
                    if (!(try_ instanceof Success)) throw new MatchError((Object)tuple2);
                    LogoTime lowerKey3 = (LogoTime)((Success)try_).value();
                    GetTSMethod getTSMethod = getMethod;
                    if (Exact$.MODULE$.equals(getTSMethod)) {
                        throw new ExtensionException("The LogoTime " + time.dump(false, false, false) + " does not exist in the time series.");
                    }
                    if (Nearest$.MODULE$.equals(getTSMethod)) {
                        logoTime = Predef$.MODULE$.Boolean2boolean(time.isCloserToAThanB(lowerKey3, higherKey3)) ? lowerKey3 : higherKey3;
                        break block9;
                    } else {
                        if (!LinearInterp$.MODULE$.equals(getTSMethod)) throw new MatchError((Object)getTSMethod);
                        logoTime = Predef$.MODULE$.Boolean2boolean(time.isCloserToAThanB(lowerKey3, higherKey3)) ? lowerKey3 : higherKey3;
                    }
                }
                break block9;
            }
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            TimeSeriesRecord record = (TimeSeriesRecord)((Some)option).value();
            logoTime = time;
        }
        finalKey.elem = logoTime;
        String string = columnName;
        String string3 = "ALL_-_COLUMNS";
        if (!(string != null ? !string.equals(string3) : string3 != null)) {
            resultList.add((LogoTime)finalKey.elem);
        }
        CollectionConverters$.MODULE$.ListHasAsScala(columnList).asScala().foreach((Function1 & Serializable)colName -> {
            GetTSMethod getTSMethod = getMethod;
            if (LinearInterp$.MODULE$.equals(getTSMethod)) {
                if ((LogoTime)lowerKey$1.elem == null && (LogoTime)higherKey$1.elem == null) {
                    return resultList.add((LogoTime)((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)((TimeSeriesColumn)this.scacolumns().getOrElse(colName, () -> LogoTimeSeries.getByTime$$anonfun$3$$anonfun$1(colName))).data().map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$3))).apply(((TimeSeriesRecord)this.times().getOrElse((Object)((LogoTime)finalKey$1.elem), LogoTimeSeries::getByTime$$anonfun$3$$anonfun$3)).dataIndex())))));
                }
                if ((LogoTime)lowerKey$1.elem == null) {
                    lowerKey$1.elem = time;
                } else if ((LogoTime)higherKey$1.elem == null) {
                    higherKey$1.elem = time;
                }
                String lowerKeyCol = (String)((TimeSeriesColumn)this.scacolumns().getOrElse(colName, LogoTimeSeries::$anonfun$3)).data().apply(((TimeSeriesRecord)this.times().getOrElse((Object)((LogoTime)lowerKey$1.elem), LogoTimeSeries::$anonfun$4)).dataIndex());
                double higherKeyCol = BoxesRunTime.unboxToDouble((Object)((TimeSeriesColumn)this.scacolumns().getOrElse(colName, LogoTimeSeries::$anonfun$5)).data().map((Function1 & Serializable)_$4 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$4))).apply(((TimeSeriesRecord)this.times().getOrElse((Object)((LogoTime)higherKey$1.elem), LogoTimeSeries::$anonfun$7)).dataIndex()));
                double lowerKeyCol2 = BoxesRunTime.unboxToDouble((Object)((TimeSeriesColumn)this.scacolumns().getOrElse(colName, LogoTimeSeries::$anonfun$8)).data().map((Function1 & Serializable)_$5 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$5))).apply(((TimeSeriesRecord)this.times().getOrElse((Object)((LogoTime)lowerKey$1.elem), LogoTimeSeries::$anonfun$10)).dataIndex()));
                double keyDiv = Predef$.MODULE$.Double2double(((LogoTime)lowerKey$1.elem).getDifferenceBetween(Milli$.MODULE$, time)) / Predef$.MODULE$.Double2double(((LogoTime)lowerKey$1.elem).getDifferenceBetween(Milli$.MODULE$, (LogoTime)higherKey$1.elem));
                return resultList.add((LogoTime)((Object)(lowerKeyCol + (higherKeyCol - lowerKeyCol2) * keyDiv).toString()));
            }
            return resultList.add((LogoTime)((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)((TimeSeriesColumn)this.scacolumns().getOrElse(colName, LogoTimeSeries::getByTime$$anonfun$3$$anonfun$4)).data().map((Function1 & Serializable)_$6 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$6))).apply(((TimeSeriesRecord)this.times().getOrElse((Object)((LogoTime)finalKey$1.elem), LogoTimeSeries::getByTime$$anonfun$3$$anonfun$6)).dataIndex())))));
        });
        if (resultList.size() != 1) return LogoList$.MODULE$.fromJava(resultList);
        return resultList.get(0);
    }

    public Object getRangeByTime(LogoTime timeLowArg, LogoTime timeHighArg, String columnName) {
        ArrayList<LogoList> resultList;
        block24: {
            ObjectRef higherKey;
            ObjectRef lowerKey;
            ArrayList<String> columnList;
            block26: {
                block25: {
                    block21: {
                        block23: {
                            block22: {
                                Object object;
                                if (columnName == null) {
                                    throw new ExtensionException(columnName + " is null");
                                }
                                ObjectRef timeLow = ObjectRef.create((Object)timeLowArg);
                                ObjectRef timeHigh = ObjectRef.create((Object)timeHighArg);
                                if (!((LogoTime)timeLow.elem).isBefore((LogoTime)timeHigh.elem)) {
                                    LogoTime timeTemp = (LogoTime)timeLow.elem;
                                    timeLow.elem = (LogoTime)timeHigh.elem;
                                    timeHigh.elem = timeTemp;
                                }
                                columnList = new ArrayList<String>(this.scacolumns().size());
                                resultList = new ArrayList<LogoList>(this.scacolumns().size());
                                String string = columnName;
                                if ("ALL_-_COLUMNS".equals(string)) {
                                    object = BoxesRunTime.boxToBoolean((boolean)columnList.addAll(CollectionConverters$.MODULE$.SetHasAsJava(this.scacolumns().keySet()).asJava()));
                                } else if ("LOGOTIME".equals(string)) {
                                    object = BoxedUnit.UNIT;
                                } else {
                                    String str = string;
                                    if (!this.scacolumns().contains((Object)columnName)) {
                                        throw new ExtensionException("The LogoTimeSeries does not contain the column " + columnName);
                                    }
                                    object = BoxesRunTime.boxToBoolean((boolean)columnList.add(columnName));
                                }
                                lowerKey = ObjectRef.create((Object)((LogoTime)timeLow.elem));
                                higherKey = ObjectRef.create((Object)((LogoTime)timeHigh.elem));
                                Option option = this.times().get((Object)((LogoTime)lowerKey.elem));
                                None$ none$ = None$.MODULE$;
                                if (!(option != null ? !option.equals(none$) : none$ != null)) {
                                    TreeSet timelist = this.times().keySet().filter((Function1 & Serializable)stime -> !stime.isBefore((LogoTime)timeLow$1.elem) || stime.isEqual((LogoTime)timeLow$1.elem));
                                    if (!timelist.isEmpty()) {
                                        lowerKey.elem = (LogoTime)timelist.min((Ordering)this.logoComparator());
                                    } else {
                                        throw new ExtensionException("List is empty (Low)");
                                    }
                                }
                                Option option2 = this.times().get((Object)((LogoTime)higherKey.elem));
                                None$ none$2 = None$.MODULE$;
                                if (!(option2 != null ? !option2.equals(none$2) : none$2 != null)) {
                                    TreeSet timelist = this.times().keySet().filter((Function1 & Serializable)stime -> stime.isBefore((LogoTime)timeHigh$1.elem) || stime.isEqual((LogoTime)timeHigh$1.elem));
                                    if (!timelist.isEmpty()) {
                                        higherKey.elem = (LogoTime)timelist.max((Ordering)this.logoComparator());
                                    } else {
                                        throw new ExtensionException("List is empty (High)");
                                    }
                                }
                                if ((LogoTime)lowerKey.elem != null && (LogoTime)higherKey.elem != null) break block21;
                                String string2 = columnName;
                                String string3 = "ALL_-_COLUMNS";
                                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block22;
                                String string4 = columnName;
                                String string5 = "LOGOTIME";
                                if (string4 != null ? !string4.equals(string5) : string5 != null) break block23;
                            }
                            resultList.add(LogoList$.MODULE$.fromVector((Vector)Vector$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))));
                        }
                        CollectionConverters$.MODULE$.ListHasAsScala(columnList).asScala().foreach((Function1 & Serializable)colName -> resultList.add(LogoList$.MODULE$.fromVector((Vector)Vector$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])))));
                        break block24;
                    }
                    String string = columnName;
                    String string6 = "ALL_-_COLUMNS";
                    if (!(string == null ? string6 != null : !string.equals(string6))) break block25;
                    String string7 = columnName;
                    String string8 = "LOGOTIME";
                    if (string7 != null ? !string7.equals(string8) : string8 != null) break block26;
                }
                resultList.add(LogoList$.MODULE$.fromJava((Iterable)CollectionConverters$.MODULE$.SetHasAsJava((Set)this.times().range((Object)((LogoTime)lowerKey.elem), (Object)((LogoTime)higherKey.elem)).keySet()).asJava()));
            }
            CollectionConverters$.MODULE$.ListHasAsScala(columnList).asScala().foreach((Function1 & Serializable)colName -> resultList.add(LogoList$.MODULE$.fromJava((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((TimeSeriesColumn)this.scacolumns().getOrElse(colName, LogoTimeSeries::getRangeByTime$$anonfun$2$$anonfun$1)).data().slice(((TimeSeriesRecord)this.times().getOrElse((Object)((LogoTime)lowerKey$2.elem), LogoTimeSeries::getRangeByTime$$anonfun$2$$anonfun$2)).dataIndex(), ((TimeSeriesRecord)this.times().getOrElse((Object)((LogoTime)higherKey$2.elem), LogoTimeSeries::getRangeByTime$$anonfun$2$$anonfun$3)).dataIndex() + 1)).asJava())));
        }
        int n = resultList.size();
        if (1 == n) {
            boolean allDoubles = ((LogoList)resultList.get(0)).toVector().forall((Function1 & Serializable)x -> {
                boolean bl;
                try {
                    Object cfr_ignored_0 = BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)x)));
                    bl = true;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
                return bl;
            });
            if (allDoubles) {
                return LogoList$.MODULE$.fromVector((Vector)((LogoList)resultList.get(0)).toVector().map((Function1 & Serializable)x -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)x)))));
            }
            return (LogoList)resultList.get(0);
        }
        int n2 = n;
        return LogoList$.MODULE$.fromJava(resultList);
    }

    public String dump(boolean arg0, boolean arg1, boolean arg2) {
        ObjectRef result = ObjectRef.create((Object)"TIMESTAMP");
        this.scacolumns().keySet().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String string;
            String colName = string = x$1;
            result$1.elem = (String)result$1.elem + ("," + colName);
        });
        result.elem = (String)result.elem + "\n";
        this.times().keySet().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            LogoTime logoTime;
            LogoTime logoTime2 = logoTime = x$1;
            TimeSeriesRecord time = (TimeSeriesRecord)this.times().getOrElse((Object)logoTime2, () -> LogoTimeSeries.$anonfun$14(logoTime2));
            result$2.elem = (String)result$2.elem + time.time().dump(false, false, false);
            this.scacolumns().keySet().foreach((Function1)(JProcedure1 & Serializable)colName -> {
                result$3.elem = (String)result$3.elem + "," + ((TimeSeriesColumn)this.scacolumns().getOrElse(colName, () -> LogoTimeSeries.dump$$anonfun$2$$anonfun$1$$anonfun$1(colName))).data().apply(time.dataIndex());
            });
            result$2.elem = (String)result$2.elem + "\n";
        });
        return (String)result.elem;
    }

    public void ensureDateTypeConsistent(LogoTime time) {
        if (this.times().size() > 0) {
            DateType dateType = ((LogoTime)this.times().firstKey()).dateType();
            DateType dateType2 = time.dateType();
            if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
                throw new ExtensionException("The LogoTimeSeries contains LogoTimes of type " + ((LogoTime)this.times().firstKey()).dateType().toString() + " while the LogoTime " + time.toString() + " used in the search is of type " + time.dateType().toString());
            }
            return;
        }
    }

    public String getExtensionName() {
        return "time";
    }

    public String getNLTypeName() {
        return "LogoTimeSeries";
    }

    public boolean recursivelyEqual(Object arg0) {
        return false;
    }

    private static final TimeSeriesColumn add$$anonfun$1$$anonfun$1() {
        throw new ExtensionException("columns section doesn't exist");
    }

    private static final TimeSeriesRecord $anonfun$1(LogoTime logoTime$1) {
        throw new ExtensionException("TimeSeriesRecord uninitialized for " + logoTime$1);
    }

    private static final TimeSeriesColumn write$$anonfun$2$$anonfun$1$$anonfun$1(String colName$1) {
        throw new ExtensionException("colName doesn't exist: " + colName$1);
    }

    private static final BufferedSource parseTimeSeriesFile$$anonfun$1(ExtensionContext context$1, String filename$1) {
        return Source$.MODULE$.fromFile(context$1.attachCurrentDirectory(filename$1), Codec$.MODULE$.fallbackSystemCodec());
    }

    private final TimeSeriesColumn parseTimeSeriesFile$$anonfun$2$$anonfun$1$$anonfun$3(ObjectRef columnNames$3, IntRef colInd$1) {
        throw new ExtensionException("Failed term: " + ((String[])columnNames$3.elem)[colInd$1.elem] + " and keyset " + this.scacolumns().keySet());
    }

    private final void parseTimeSeriesFile$$anonfun$2$$anonfun$1(String line$1, IntRef ind$1, ObjectRef columnNames$1, Option customFormat$1) {
        String string = line$1;
        String linedata = string;
        if (linedata.charAt(0) == ';') {
            throw Breaks$.MODULE$.break();
        }
        if (ind$1.elem == 0) {
            ++ind$1.elem;
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line$1), ','));
            columnNames$1.elem = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.trim(), ClassTag$.MODULE$.apply(String.class));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])Arrays.copyOfRange((String[])columnNames$1.elem, 1, ((String[])columnNames$1.elem).length));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)columnName -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc(columnName);
                return (LinkedHashMap)this.scacolumns().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new TimeSeriesColumn()));
            });
            return;
        }
        String linedata2 = string;
        Object object = Predef$.MODULE$.refArrayOps((Object[])linedata2.split(","));
        String[] lineData = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.trim(), ClassTag$.MODULE$.apply(String.class));
        LogoTime newTime = new LogoTime(lineData[0], (Option<String>)customFormat$1);
        LogoTime logoTime = (LogoTime)Predef$.MODULE$.ArrowAssoc((Object)newTime);
        this.times_$eq((TreeMap<LogoTime, TimeSeriesRecord>)((TreeMap)this.times().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)logoTime, (Object)new TimeSeriesRecord(newTime, this.numRows())))));
        this.numRows_$eq(this.numRows() + 1);
        IntRef colInd = IntRef.create((int)1);
        while (colInd.elem <= this.scacolumns().size()) {
            ((TimeSeriesColumn)this.scacolumns().getOrElse((Object)((String[])columnNames$1.elem)[colInd.elem], () -> this.parseTimeSeriesFile$$anonfun$2$$anonfun$1$$anonfun$3(columnNames$1, colInd))).add(lineData[colInd.elem]);
            ++colInd.elem;
        }
    }

    private final LogoTime getByTime$$anonfun$1(LogoTime time$2) {
        return (LogoTime)this.times().keySet().filter((Function1 & Serializable)stime -> !stime.isBefore(time$2) || stime.isEqual(time$2)).max((Ordering)this.logoComparator());
    }

    private final LogoTime getByTime$$anonfun$2(LogoTime time$4) {
        return (LogoTime)this.times().keySet().filter((Function1 & Serializable)stime -> stime.isBefore(time$4) || stime.isEqual(time$4)).min((Ordering)this.logoComparator());
    }

    private static final TimeSeriesColumn getByTime$$anonfun$3$$anonfun$1(String colName$2) {
        throw new ExtensionException("colName doesn't exist in columns: " + colName$2);
    }

    private static final TimeSeriesRecord getByTime$$anonfun$3$$anonfun$3() {
        throw new ExtensionException("finalKey doesn't exist in data");
    }

    private static final TimeSeriesColumn $anonfun$3() {
        throw new ExtensionException("lowerKeyColumn is not provided");
    }

    private static final TimeSeriesRecord $anonfun$4() {
        throw new ExtensionException("lowerKey doesn't exist in data");
    }

    private static final TimeSeriesColumn $anonfun$5() {
        throw new ExtensionException("colName is not provided");
    }

    private static final TimeSeriesRecord $anonfun$7() {
        throw new ExtensionException("higherKey doesn't exist in data");
    }

    private static final TimeSeriesColumn $anonfun$8() {
        throw new ExtensionException("colName is not provided");
    }

    private static final TimeSeriesRecord $anonfun$10() {
        throw new ExtensionException("lowerKey doesn't exist in data");
    }

    private static final TimeSeriesColumn getByTime$$anonfun$3$$anonfun$4() {
        throw new ExtensionException("colName doesn't exist in columns");
    }

    private static final TimeSeriesRecord getByTime$$anonfun$3$$anonfun$6() {
        throw new ExtensionException("finalKey doesn't exist in times");
    }

    private static final TimeSeriesColumn getRangeByTime$$anonfun$2$$anonfun$1() {
        throw new ExtensionException("colName doesn't exist in columns");
    }

    private static final TimeSeriesRecord getRangeByTime$$anonfun$2$$anonfun$2() {
        throw new ExtensionException("colName doesn't exist in columns");
    }

    private static final TimeSeriesRecord getRangeByTime$$anonfun$2$$anonfun$3() {
        throw new ExtensionException("higherKey doesn't exist in times");
    }

    private static final TimeSeriesRecord $anonfun$14(LogoTime logoTime$2) {
        throw new ExtensionException("times doesn't contain LogoTime: " + logoTime$2);
    }

    private static final TimeSeriesColumn dump$$anonfun$2$$anonfun$1$$anonfun$1(String colName$3) {
        throw new ExtensionException("columns doesn't contain colName: " + colName$3);
    }
}

