/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.time.primitives;

import java.util.ArrayList;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.Dump$;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Reporter;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.extensions.time.Exact$;
import org.nlogo.extensions.time.LinearInterp$;
import org.nlogo.extensions.time.Nearest$;
import org.nlogo.extensions.time.TimeUtils$;
import org.nlogo.extensions.time.datatypes.LogoTime;
import org.nlogo.extensions.time.datatypes.LogoTimeSeries;
import org.nlogo.nvm.ExtensionContext;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class TimeSeriesPrimitives {

    public static class TimeSeriesAddRow
    implements Command {
        public Syntax getSyntax() {
            return Syntax$.MODULE$.commandSyntax((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)Nil$.MODULE$)), Syntax$.MODULE$.commandSyntax$default$2(), Syntax$.MODULE$.commandSyntax$default$3(), Syntax$.MODULE$.commandSyntax$default$4(), Syntax$.MODULE$.commandSyntax$default$5(), Syntax$.MODULE$.commandSyntax$default$6(), Syntax$.MODULE$.commandSyntax$default$7());
        }

        public void perform(Argument[] args, Context context) {
            LogoTimeSeries ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
            LogoList list = TimeUtils$.MODULE$.getListFromArgument(args, Predef$.MODULE$.int2Integer(1));
            Object timeObj = list.get(0);
            LogoTime time = null;
            Object object = timeObj;
            if (object instanceof String) {
                String tObj = (String)object;
                time = new LogoTime(tObj);
            } else if (object instanceof LogoTime) {
                LogoTime tObj = (LogoTime)object;
                time = new LogoTime(tObj);
            } else {
                Object tObj = object;
                throw new ExtensionException("time: was expecting a LogoTime object as the first item in the list passed as argument 2, found this instead: " + Dump$.MODULE$.logoObject(tObj));
            }
            if (list.size() != Predef$.MODULE$.Integer2int(ts.getNumColumns()) + 1) {
                throw new ExtensionException("time: cannot add " + (list.size() - 1) + " values to a time series with " + ts.getNumColumns() + " columns.");
            }
            ts.add(time, list.logoSublist(1, list.size()));
        }
    }

    public static class TimeSeriesCreate
    implements Reporter {
        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)Nil$.MODULE$);
            int n = Syntax$.MODULE$.WildcardType();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$1();
            int n3 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$5();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option3 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n2, n3, list, n, option, option2, bl, string, option3);
        }

        public Object report(Argument[] args, Context context) {
            LogoList columnList = null;
            try {
                columnList = TimeUtils$.MODULE$.getListFromArgument(args, Predef$.MODULE$.int2Integer(0));
            }
            catch (ExtensionException e) {
                ArrayList<String> cols = new ArrayList<String>();
                String colName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0));
                cols.add(colName);
                columnList = LogoList$.MODULE$.fromJava(cols);
            }
            return new LogoTimeSeries(columnList);
        }
    }

    public static class TimeSeriesGet
    implements Reporter {
        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$)));
            int n = Syntax$.MODULE$.WildcardType();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$1();
            int n3 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$5();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option3 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n2, n3, list, n, option, option2, bl, string, option3);
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime time;
            LogoTimeSeries ts;
            block3: {
                block2: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(time);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    String string2 = "ALL";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = columnName;
                    String string4 = "all";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getByTime(time, columnName, Nearest$.MODULE$);
        }
    }

    public static class TimeSeriesGetExact
    implements Reporter {
        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$)));
            int n = Syntax$.MODULE$.WildcardType();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$1();
            int n3 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$5();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option3 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n2, n3, list, n, option, option2, bl, string, option3);
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime time;
            LogoTimeSeries ts;
            block3: {
                block2: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(time);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    String string2 = "ALL";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = columnName;
                    String string4 = "all";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getByTime(time, columnName, Exact$.MODULE$);
        }
    }

    public static class TimeSeriesGetInterp
    implements Reporter {
        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$)));
            int n = Syntax$.MODULE$.WildcardType();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$1();
            int n3 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$5();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option3 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n2, n3, list, n, option, option2, bl, string, option3);
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime time;
            LogoTimeSeries ts;
            block3: {
                block2: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(time);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    String string2 = "ALL";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = columnName;
                    String string4 = "all";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getByTime(time, columnName, LinearInterp$.MODULE$);
        }
    }

    public static class TimeSeriesGetRange
    implements Reporter {
        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$))));
            int n = Syntax$.MODULE$.WildcardType();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$1();
            int n3 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$5();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option3 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n2, n3, list, n, option, option2, bl, string, option3);
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime timeB;
            LogoTime timeA;
            LogoTimeSeries ts;
            block5: {
                block4: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    timeA = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(timeA);
                    timeB = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    ts.ensureDateTypeConsistent(timeB);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(3));
                    String string2 = "logotime";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        columnName = "LOGOTIME";
                    }
                    String string3 = columnName;
                    String string4 = "ALL";
                    if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block4;
                    String string5 = columnName;
                    String string6 = "all";
                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block5;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getRangeByTime(timeA, timeB, columnName);
        }
    }

    public static class TimeSeriesLoad
    implements Reporter {
        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$);
            int n = Syntax$.MODULE$.WildcardType();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$1();
            int n3 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$5();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option3 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n2, n3, list, n, option, option2, bl, string, option3);
        }

        public Object report(Argument[] args, Context context) {
            String filename = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0));
            return new LogoTimeSeries(filename, (ExtensionContext)context);
        }
    }

    public static class TimeSeriesLoadWithFormat
    implements Reporter {
        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$));
            int n = Syntax$.MODULE$.WildcardType();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$1();
            int n3 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$5();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option3 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n2, n3, list, n, option, option2, bl, string, option3);
        }

        public Object report(Argument[] args, Context context) {
            None$ none$;
            String filename = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0));
            String string = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(1));
            if (string == null) {
                none$ = None$.MODULE$;
            } else {
                String x = string;
                none$ = Some$.MODULE$.apply((Object)x);
            }
            None$ format = none$;
            return new LogoTimeSeries(filename, (Option<String>)format, (ExtensionContext)context);
        }
    }

    public static class TimeSeriesWrite
    implements Command {
        public Syntax getSyntax() {
            return Syntax$.MODULE$.commandSyntax((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.WildcardType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$)), Syntax$.MODULE$.commandSyntax$default$2(), Syntax$.MODULE$.commandSyntax$default$3(), Syntax$.MODULE$.commandSyntax$default$4(), Syntax$.MODULE$.commandSyntax$default$5(), Syntax$.MODULE$.commandSyntax$default$6(), Syntax$.MODULE$.commandSyntax$default$7());
        }

        public void perform(Argument[] args, Context context) {
            LogoTimeSeries ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
            String filename = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(1));
            ts.write(filename, (ExtensionContext)context);
        }
    }
}

