/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;

public class SimpleTriangleIterator
implements Iterator<SimpleTriangle> {
    IIncrementalTin tin;
    final Iterator<IQuadEdge> edgeIterator;
    final BitSet visited;
    SimpleTriangle nextTriangle;
    IQuadEdge nextEdge;

    public SimpleTriangleIterator(IIncrementalTin tin) {
        this.tin = tin;
        this.edgeIterator = tin.getEdgeIterator();
        this.visited = new BitSet(tin.getMaximumEdgeAllocationIndex() + 2);
    }

    @Override
    public boolean hasNext() {
        if (!this.tin.isBootstrapped()) {
            return false;
        }
        while (this.nextTriangle == null) {
            if (this.nextEdge == null) {
                if (!this.edgeIterator.hasNext()) {
                    return false;
                }
                this.nextEdge = this.edgeIterator.next();
            }
            IQuadEdge e = this.nextEdge;
            int eIndex = this.nextEdge.getIndex();
            this.nextEdge = (eIndex & 1) == 0 ? this.nextEdge.getDual() : null;
            if (this.visited.get(eIndex)) continue;
            IQuadEdge ef = e.getForward();
            IQuadEdge er = e.getReverse();
            this.visited.set(eIndex);
            this.visited.set(ef.getIndex());
            this.visited.set(er.getIndex());
            Vertex A = e.getA();
            Vertex B = ef.getA();
            Vertex C = er.getA();
            if (A == null || B == null || C == null) continue;
            this.nextTriangle = new SimpleTriangle(this.tin, e, ef, er);
            break;
        }
        return true;
    }

    @Override
    public SimpleTriangle next() {
        if (this.nextTriangle == null) {
            this.hasNext();
            if (this.nextTriangle == null) {
                throw new NoSuchElementException("No more triangles in TIN");
            }
        }
        SimpleTriangle result = this.nextTriangle;
        this.nextTriangle = null;
        return result;
    }
}

