/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.contour.Contour;
import org.tinfour.contour.TipLink;

class PerimeterLink {
    final int index;
    final IQuadEdge edge;
    PerimeterLink next;
    PerimeterLink prior;
    TipLink tip0;
    TipLink tip1;
    ArrayList<TipLink> tempList = new ArrayList();

    PerimeterLink(int index, IQuadEdge edge) {
        this.index = index;
        this.edge = edge;
    }

    void addContourTip(Contour contour, boolean contourStart, int sweepIndex) {
        TipLink tip = new TipLink(this, contour, contourStart, sweepIndex);
        if (contourStart) {
            contour.startTip = tip;
        } else {
            contour.terminalTip = tip;
        }
        if (sweepIndex != 0) {
            this.tempList.add(tip);
            return;
        }
        if (this.tip0 == null) {
            this.tip0 = tip;
            this.tip1 = tip;
        } else if (contourStart) {
            tip.next = this.tip0;
            this.tip0.prior = tip;
            this.tip0 = tip;
        } else {
            tip.prior = this.tip1;
            this.tip1.next = tip;
            this.tip1 = tip;
        }
    }

    void prependThroughVertexTips() {
        if (this.tempList.isEmpty()) {
            return;
        }
        Collections.sort(this.tempList, new Comparator<TipLink>(){

            @Override
            public int compare(TipLink o1, TipLink o2) {
                return Integer.compare(o1.sweepIndex, o2.sweepIndex);
            }
        });
        for (TipLink tip : this.tempList) {
            if (this.tip0 == null) {
                this.tip0 = tip;
                this.tip1 = tip;
                continue;
            }
            tip.next = this.tip0;
            this.tip0.prior = tip;
            this.tip0 = tip;
        }
        this.tempList.clear();
    }

    public String toString() {
        if (this.prior == null || this.next == null) {
            return "Perimeter link " + this.index + ": " + this.edge.getIndex() + " (no links)";
        }
        return "Perimeter link " + this.index + ": " + this.prior.edge.getIndex() + " <- " + this.edge.getIndex() + " -> " + this.next.edge.getIndex();
    }
}

