/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.interpolation;

import java.io.PrintStream;
import java.util.List;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.INeighborhoodPointsCollector;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.interpolation.VertexValuatorDefault;
import org.tinfour.utils.KahanSummation;

public class InverseDistanceWeightingInterpolator
implements IInterpolatorOverTin {
    private final IdwVariation idwVariation;
    private final double vertexTolerance2;
    private final double precisionThreshold;
    private final IIncrementalTinNavigator navigator;
    private final INeighborhoodPointsCollector neighborhoodPoints;
    private final double lambda;
    private final double power;
    private final VertexValuatorDefault defaultValuator = new VertexValuatorDefault();
    private int maxDepth = 1;
    private int minPoints = 6;
    private long nInterpolation;
    private long sumVertexCount;
    private final KahanSummation sumDist = new KahanSummation();

    public InverseDistanceWeightingInterpolator(IIncrementalTin tin) {
        this.idwVariation = IdwVariation.Shepard;
        Thresholds thresholds = tin.getThresholds();
        this.vertexTolerance2 = thresholds.getVertexTolerance2();
        this.precisionThreshold = thresholds.getPrecisionThreshold();
        this.navigator = tin.getNavigator();
        this.neighborhoodPoints = tin.getNeighborhoodPointsCollector();
        this.lambda = 1.75;
        this.power = 2.0;
    }

    public InverseDistanceWeightingInterpolator(IIncrementalTin tin, double parameter, boolean gaussian) {
        Thresholds thresholds = tin.getThresholds();
        this.vertexTolerance2 = thresholds.getVertexTolerance2();
        this.precisionThreshold = thresholds.getPrecisionThreshold();
        this.navigator = tin.getNavigator();
        this.neighborhoodPoints = tin.getNeighborhoodPointsCollector();
        if (gaussian) {
            this.lambda = parameter;
            this.power = 0.0;
            this.idwVariation = IdwVariation.GaussianKernel;
        } else {
            this.idwVariation = IdwVariation.Power;
            this.power = parameter;
            this.lambda = 0.0;
        }
    }

    @Override
    public void resetForChangeToTin() {
        this.navigator.resetForChangeToTin();
        this.neighborhoodPoints.resetForChangeToTin();
    }

    @Override
    public double interpolate(double x, double y, IVertexValuator valuator) {
        IQuadEdge e = this.navigator.getNeighborEdge(x, y);
        if (e == null) {
            return Double.NaN;
        }
        Vertex v2 = e.getForward().getB();
        if (v2 == null) {
            return Double.NaN;
        }
        List<Vertex> neighbors = this.neighborhoodPoints.collectNeighboringVertices(x, y, this.maxDepth, this.minPoints);
        IVertexValuator val = valuator == null ? this.defaultValuator : valuator;
        double wSum = 0.0;
        double wzSum = 0.0;
        double sSum = 0.0;
        for (Vertex v : neighbors) {
            double w;
            double z = val.value(v);
            double dx = v.getX() - x;
            double dy = v.getY() - y;
            double s2 = dx * dx + dy * dy;
            double s = Math.sqrt(s2);
            sSum += s;
            switch (this.idwVariation) {
                case Shepard: {
                    if (s2 < this.vertexTolerance2) {
                        return z;
                    }
                    w = 1.0 / s2;
                    break;
                }
                case Power: {
                    if (s2 < this.vertexTolerance2) {
                        return z;
                    }
                    w = 1.0 / Math.pow(s2, this.power / 2.0);
                    break;
                }
                default: {
                    w = Math.exp(-0.5 * s / this.lambda);
                }
            }
            wSum += w;
            wzSum += z * w;
        }
        if (wSum < this.precisionThreshold) {
            return Double.NaN;
        }
        ++this.nInterpolation;
        this.sumVertexCount += (long)neighbors.size();
        this.sumDist.add(sSum);
        return wzSum / wSum;
    }

    @Override
    public boolean isSurfaceNormalSupported() {
        return false;
    }

    @Override
    public double[] getSurfaceNormal() {
        return new double[0];
    }

    @Override
    public String getMethod() {
        if (this.idwVariation == IdwVariation.GaussianKernel) {
            return String.format("IDW (Gaussian: %4.2f)", this.lambda);
        }
        return String.format("IDW (power: %4.2f)", this.power);
    }

    public static double estimateNominalBandwidth(double pointSpacing) {
        if (pointSpacing <= 0.0) {
            return Double.NaN;
        }
        return -Math.log(0.08333333333333333) * pointSpacing / 2.0;
    }

    public static double computeAverageSampleSpacing(IIncrementalTin tin) {
        KahanSummation kahanSum = new KahanSummation();
        int nSum = 0;
        for (IQuadEdge e : tin.edges()) {
            kahanSum.add(e.getLength());
            ++nSum;
        }
        if (nSum == 0) {
            return Double.NaN;
        }
        if (nSum == 3) {
            return kahanSum.getMean();
        }
        for (IQuadEdge e : tin.getPerimeter()) {
            kahanSum.add(-e.getLength());
            --nSum;
        }
        return kahanSum.getSum() / (double)nSum;
    }

    public void printDiagnostics(PrintStream ps) {
        long n = 1L;
        if (this.nInterpolation > 0L) {
            n = this.nInterpolation;
        }
        long nV = 1L;
        if (this.sumVertexCount > 0L) {
            nV = this.sumVertexCount;
        }
        ps.format("Interpolations       %10d%n", this.nInterpolation);
        ps.format("Avg. sample size:    %12.1f%n", (double)this.sumVertexCount / (double)n);
        ps.format("Avg. sample spacing: %15.4f%n", this.sumDist.getSum() / (double)nV);
    }

    public String toString() {
        if (this.idwVariation == IdwVariation.GaussianKernel) {
            return String.format("IDW (Gaussian: %4.2f)", this.lambda);
        }
        return String.format("IDW (Power: %3.1f)", this.power);
    }

    private static enum IdwVariation {
        Shepard,
        Power,
        GaussianKernel;

    }
}

