/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.voronoi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import org.tinfour.voronoi.IBoundedVoronoiVertexSymbol;

public class BoundedVoronoiVertexSymbol
implements IBoundedVoronoiVertexSymbol {
    String label;
    Font font;
    Color color;
    double vertexSymbolSize;

    public BoundedVoronoiVertexSymbol() {
        this.vertexSymbolSize = 7.0;
    }

    public BoundedVoronoiVertexSymbol(double vertexSymbolSize) {
        if (vertexSymbolSize <= 0.0) {
            throw new IllegalArgumentException("Negative and zero sizes not supported");
        }
        this.vertexSymbolSize = vertexSymbolSize;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void draw(Graphics g, double x, double y) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.color == null) {
            this.color = g2d.getColor();
        }
        if (this.font == null) {
            this.font = g2d.getFont();
        }
        Ellipse2D.Double e2d = new Ellipse2D.Double(x - this.vertexSymbolSize / 2.0, y - this.vertexSymbolSize / 3.0, this.vertexSymbolSize, this.vertexSymbolSize);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.fill(e2d);
        g2d.draw(e2d);
        if (this.label != null && !this.label.isEmpty() && this.font != null) {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            TextLayout layout = new TextLayout(this.label, this.font, frc);
            double s = (this.vertexSymbolSize + 1.0) / 2.0;
            layout.draw(g2d, (float)(x + s), (float)(y - s));
        }
    }
}

