/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.awt.Color;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.StreamTokenizerWithMultilineLiterals;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterDOT
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;
    private String graphName = "";

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader((Reader)this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start((ProgressTicket)this.progressTicket);
        StreamTokenizerWithMultilineLiterals streamTokenizer = new StreamTokenizerWithMultilineLiterals((Reader)reader);
        this.setSyntax(streamTokenizer);
        this.graph(streamTokenizer);
    }

    protected void setSyntax(StreamTokenizerWithMultilineLiterals tk) {
        tk.resetSyntax();
        tk.eolIsSignificant(false);
        tk.commentChar(35);
        tk.slashStarComments(true);
        tk.slashSlashComments(true);
        tk.whitespaceChars(0, 32);
        tk.wordChars(33, 255);
        tk.ordinaryChar(91);
        tk.ordinaryChar(93);
        tk.ordinaryChar(123);
        tk.ordinaryChar(125);
        tk.ordinaryChar(45);
        tk.ordinaryChar(62);
        tk.ordinaryChar(47);
        tk.ordinaryChar(42);
        tk.ordinaryChar(44);
        tk.quoteChar(34);
        tk.whitespaceChars(59, 59);
        tk.ordinaryChar(61);
    }

    protected void graph(StreamTokenizerWithMultilineLiterals streamTokenizer) throws Exception {
        boolean found = false;
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("digraph") && !streamTokenizer.sval.equalsIgnoreCase("graph")) continue;
            found = true;
            this.container.setEdgeDefault(streamTokenizer.sval.equalsIgnoreCase("digraph") ? EdgeDirectionDefault.DIRECTED : EdgeDirectionDefault.UNDIRECTED);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -3) {
                this.graphName = streamTokenizer.sval;
                streamTokenizer.nextToken();
            }
            while (streamTokenizer.ttype != 123) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -1) continue;
                return;
            }
            this.stmtList(streamTokenizer);
        }
        if (!found) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_nothingfound"), Issue.Level.SEVERE));
        }
    }

    protected void stmtList(StreamTokenizerWithMultilineLiterals streamTokenizer) throws Exception {
        do {
            streamTokenizer.nextToken();
            this.stmt(streamTokenizer);
        } while (streamTokenizer.ttype != -1);
    }

    protected void stmt(StreamTokenizerWithMultilineLiterals streamTokenizer) throws Exception {
        if (!(streamTokenizer.sval == null || streamTokenizer.sval.equalsIgnoreCase("graph") || streamTokenizer.sval.equalsIgnoreCase("node") || streamTokenizer.sval.equalsIgnoreCase("edge"))) {
            String nodeId = this.nodeID(streamTokenizer);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 45) {
                NodeDraft nodeDraft = this.getOrCreateNode(nodeId);
                this.edgeStructure(streamTokenizer, nodeDraft);
            } else if (streamTokenizer.ttype == 91) {
                NodeDraft nodeDraft = this.getOrCreateNode(nodeId);
                this.nodeAttributes(streamTokenizer, nodeDraft);
            } else {
                this.getOrCreateNode(nodeId);
                streamTokenizer.pushBack();
            }
        }
    }

    protected String nodeID(StreamTokenizerWithMultilineLiterals streamTokenizer) {
        if (streamTokenizer.ttype == 34 || streamTokenizer.ttype == -3 || streamTokenizer.ttype >= 97 && streamTokenizer.ttype <= 122 || streamTokenizer.ttype >= 65 && streamTokenizer.ttype <= 90) {
            return streamTokenizer.sval;
        }
        return null;
    }

    protected NodeDraft getOrCreateNode(String id) {
        if (!this.container.nodeExists(id)) {
            NodeDraft nodeDraft = this.container.factory().newNodeDraft(id);
            this.container.addNode(nodeDraft);
            return nodeDraft;
        }
        return this.container.getNode(id);
    }

    protected Color parseColor(StreamTokenizerWithMultilineLiterals streamTokenizer) throws Exception {
        if (streamTokenizer.ttype == 35) {
            streamTokenizer.nextToken();
            return new Color(Integer.parseInt(streamTokenizer.sval, 16), true);
        }
        if (streamTokenizer.ttype == 34 && streamTokenizer.sval.startsWith("#")) {
            return new Color(Integer.parseInt(streamTokenizer.sval.substring(1), 16), true);
        }
        if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
            throw new ParseException();
        }
        if (ImportUtils.parseColor((String)streamTokenizer.sval) != null) {
            return ImportUtils.parseColor((String)streamTokenizer.sval);
        }
        String toParse = streamTokenizer.sval.replace(", ", ",");
        String[] colors = toParse.split(" ");
        if (colors.length != 3) {
            colors = toParse.split(",");
        }
        if (colors.length != 3) {
            throw new ParseException();
        }
        return Color.getHSBColor(Float.parseFloat(colors[0]), Float.parseFloat(colors[1]), Float.parseFloat(colors[2]));
    }

    protected void nodeAttributes(StreamTokenizerWithMultilineLiterals streamTokenizer, NodeDraft nodeDraft) throws Exception {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 93 || streamTokenizer.ttype == -1) {
            return;
        }
        if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
            if (streamTokenizer.sval.equalsIgnoreCase("label")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        nodeDraft.setLabel(streamTokenizer.sval);
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("color")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    try {
                        nodeDraft.setColor(this.parseColor(streamTokenizer));
                    }
                    catch (ParseException e) {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_colorunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_colorunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("pos")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        try {
                            String[] positions = streamTokenizer.sval.split(",");
                            if (positions.length == 2) {
                                nodeDraft.setX(Float.parseFloat(positions[0]));
                                nodeDraft.setY(Float.parseFloat(positions[1]));
                            } else if (positions.length == 3) {
                                nodeDraft.setX(Float.parseFloat(positions[0]));
                                nodeDraft.setY(Float.parseFloat(positions[1]));
                                nodeDraft.setZ(Float.parseFloat(positions[2]));
                            }
                        }
                        catch (Exception positions) {}
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_posunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_posunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("style")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        streamTokenizer.pushBack();
                    }
                } else {
                    streamTokenizer.pushBack();
                }
            } else {
                String attributeName = streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        String value = streamTokenizer.sval;
                        if (value != null && !value.isEmpty()) {
                            nodeDraft.setValue(attributeName, (Object)value);
                        }
                    } else {
                        streamTokenizer.pushBack();
                    }
                } else {
                    streamTokenizer.pushBack();
                }
            }
        }
        this.nodeAttributes(streamTokenizer, nodeDraft);
    }

    protected void edgeStructure(StreamTokenizerWithMultilineLiterals streamTokenizer, NodeDraft nodeDraft) throws Exception {
        streamTokenizer.nextToken();
        EdgeDraft edge = null;
        if (streamTokenizer.ttype == 62 || streamTokenizer.ttype == 45) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 123) {
                while (true) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 125) {
                        this.nodeID(streamTokenizer);
                        edge = this.container.factory().newEdgeDraft();
                        edge.setSource(nodeDraft);
                        edge.setTarget(this.getOrCreateNode(streamTokenizer.sval));
                        this.container.addEdge(edge);
                        continue;
                    }
                    break;
                }
            } else {
                this.nodeID(streamTokenizer);
                edge = this.container.factory().newEdgeDraft();
                edge.setSource(nodeDraft);
                edge.setTarget(this.getOrCreateNode(streamTokenizer.sval));
                this.container.addEdge(edge);
            }
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_edgeparsing", (Object)streamTokenizer.lineno()), Issue.Level.SEVERE));
            if (streamTokenizer.ttype == -3) {
                streamTokenizer.pushBack();
            }
            return;
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 91) {
            this.edgeAttributes(streamTokenizer, edge);
        } else {
            streamTokenizer.pushBack();
        }
    }

    protected void edgeAttributes(StreamTokenizerWithMultilineLiterals streamTokenizer, EdgeDraft edge) throws Exception {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 93 || streamTokenizer.ttype == -1) {
            return;
        }
        if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
            if (streamTokenizer.sval.equalsIgnoreCase("label")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        edge.setLabel(streamTokenizer.sval);
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("color")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    try {
                        edge.setColor(this.parseColor(streamTokenizer));
                    }
                    catch (ParseException e) {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_colorunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_color_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("style")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        streamTokenizer.pushBack();
                    }
                } else {
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("weight")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        try {
                            Float weight = Float.valueOf(Float.parseFloat(streamTokenizer.sval));
                            edge.setWeight((double)weight.floatValue());
                        }
                        catch (Exception e) {
                            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_weightunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        }
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_weightunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_weightunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            }
        }
        this.edgeAttributes(streamTokenizer, edge);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    private static class ParseException
    extends RuntimeException {
        public ParseException() {
            super("Parse error while parsing DOT file");
        }
    }
}

