/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeMergeStrategy;
import org.gephi.io.importer.api.ElementIdType;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.processor.plugin.AbstractProcessor;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DefaultProcessor
extends AbstractProcessor {
    public String getDisplayName() {
        return NbBundle.getMessage(DefaultProcessor.class, (String)"DefaultProcessor.displayName");
    }

    public void process() {
        try {
            if (this.containers.length > 1) {
                throw new RuntimeException("This processor can only handle single containers");
            }
            ContainerUnloader container = this.containers[0];
            ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            if (this.workspace == null) {
                this.workspace = pc.newWorkspace(pc.getCurrentProject());
                pc.openWorkspace(this.workspace);
            }
            this.processConfiguration(container, this.workspace);
            if (container.getSource() != null) {
                pc.setSource(this.workspace, container.getSource());
            }
            Progress.start((ProgressTicket)this.progressTicket, (int)this.calculateWorkUnits());
            this.process(container, this.workspace);
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        finally {
            this.clean();
        }
    }

    protected void processConfiguration(ContainerUnloader container, Workspace workspace) {
        GraphConfigurationWrapper newConfig;
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        Configuration configuration = new Configuration();
        configuration.setTimeRepresentation(container.getTimeRepresentation());
        if (container.getEdgeTypeLabelClass() != null) {
            configuration.setEdgeLabelType(container.getEdgeTypeLabelClass());
        }
        configuration.setNodeIdType(container.getElementIdType().getTypeClass());
        configuration.setEdgeIdType(container.getElementIdType().getTypeClass());
        ColumnDraft weightColumn = container.getEdgeColumn("weight");
        if (weightColumn != null && weightColumn.isDynamic()) {
            if (container.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
                configuration.setEdgeWeightType(IntervalDoubleMap.class);
            } else {
                configuration.setEdgeWeightType(TimestampDoubleMap.class);
            }
        }
        GraphConfigurationWrapper originalConfig = new GraphConfigurationWrapper(graphController.getGraphModel(workspace).getConfiguration());
        if (container.getEdgeCount() == 0 && !originalConfig.edgeWeightType.equals(configuration.getEdgeWeightType())) {
            configuration.setEdgeWeightType(originalConfig.edgeWeightType);
        }
        if (!originalConfig.equals(newConfig = new GraphConfigurationWrapper(configuration))) {
            try {
                graphController.getGraphModel(workspace).setConfiguration(configuration);
            }
            catch (Exception e) {
                String message = NbBundle.getMessage(DefaultProcessor.class, (String)"DefaultProcessor.error.configurationChangeForbidden", (Object)new GraphConfigurationWrapper(graphController.getGraphModel(workspace).getConfiguration()).toString(), (Object)new GraphConfigurationWrapper(configuration).toString());
                this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            }
        }
    }

    protected void process(ContainerUnloader container, Workspace workspace) {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.graphModel = graphController.getGraphModel(workspace);
        Graph graph = this.graphModel.getGraph();
        GraphFactory factory = this.graphModel.factory();
        this.graphModel.setTimeFormat(container.getTimeFormat());
        this.graphModel.setTimeZone(container.getTimeZone());
        this.flushColumns(container);
        int addedNodes = 0;
        int addedEdges = 0;
        ElementIdType elementIdType = container.getElementIdType();
        for (Object draftNode : container.getNodes()) {
            String idString = draftNode.getId();
            Object id = this.toElementId(elementIdType, idString);
            Node node = graph.getNode(id);
            boolean newNode = false;
            if (node == null) {
                node = factory.newNode(id);
                ++addedNodes;
                newNode = true;
            }
            this.flushToNode(container, (NodeDraft)draftNode, node);
            if (newNode) {
                graph.addNode(node);
            }
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        EdgeMergeStrategy edgesMergeStrategy = this.containers[0].getEdgesMergeStrategy();
        for (EdgeDraft draftEdge : container.getEdges()) {
            boolean newEdge;
            String idString = draftEdge.getId();
            Object id = this.toElementId(elementIdType, idString);
            String sourceId = draftEdge.getSource().getId();
            String targetId = draftEdge.getTarget().getId();
            Node source = graph.getNode(this.toElementId(elementIdType, sourceId));
            Node target = graph.getNode(this.toElementId(elementIdType, targetId));
            Object type = draftEdge.getType();
            int edgeType = this.graphModel.addEdgeType(type);
            boolean createDirected = true;
            switch (container.getEdgeDefault()) {
                case DIRECTED: {
                    createDirected = true;
                    break;
                }
                case UNDIRECTED: {
                    createDirected = false;
                    break;
                }
                case MIXED: {
                    createDirected = draftEdge.getDirection() != EdgeDirection.UNDIRECTED;
                    draftEdge.setDirection(createDirected ? EdgeDirection.DIRECTED : EdgeDirection.UNDIRECTED);
                }
            }
            Edge edge = graph.getEdge(source, target, edgeType);
            if (edge != null && edgesMergeStrategy == EdgeMergeStrategy.NO_MERGE) {
                Edge incompatibleEdge = this.findIncompatibleEdge(graph, source, target, createDirected, edgeType);
                if (incompatibleEdge == null) {
                    edge = null;
                } else {
                    String message = NbBundle.getMessage(DefaultProcessor.class, (String)"DefaultProcessor.error.incompatibleEdges", (Object)String.format("[%s -> %s; %s, type %s]", sourceId, targetId, createDirected ? "Directed" : "Undirected", type), (Object)String.format("[%s -> %s; %s; type: %s; id: %s]", incompatibleEdge.getSource().getId(), incompatibleEdge.getTarget().getId(), incompatibleEdge.isDirected() ? "Directed" : "Undirected", incompatibleEdge.getTypeLabel(), incompatibleEdge.getId()));
                    this.report.logIssue(new Issue(message, Issue.Level.WARNING));
                    Progress.progress((ProgressTicket)this.progressTicket);
                    continue;
                }
            }
            boolean bl = newEdge = edge == null;
            if (newEdge) {
                edge = !graph.hasEdge(id) ? factory.newEdge(id, source, target, edgeType, draftEdge.getWeight(), createDirected) : factory.newEdge(source, target, edgeType, draftEdge.getWeight(), createDirected);
                ++addedEdges;
            }
            this.flushToEdge(container, draftEdge, edge, newEdge);
            if (newEdge) {
                graph.addEdge(edge);
            }
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        int touchedNodes = container.getNodeCount();
        int touchedEdges = container.getEdgeCount();
        if (touchedNodes != addedNodes || touchedEdges != addedEdges) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Nodes loaded: {0} ({1} added)", new Object[]{touchedNodes, addedNodes});
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Edges loaded: {0} ({1} added)", new Object[]{touchedEdges, addedEdges});
        } else {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Nodes loaded: {0}", new Object[]{touchedNodes});
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.INFO, "# Edges loaded: {0}", new Object[]{touchedEdges});
        }
    }

    private Edge findIncompatibleEdge(Graph graph, Node source, Node target, boolean directed, int edgeType) {
        Edge edge = graph.getEdge(source, target, edgeType);
        if (edge == null) {
            if (directed && (edge = graph.getEdge(target, source, edgeType)) != null && edge.isDirected()) {
                edge = null;
            }
        } else if (edge.isDirected() == directed) {
            edge = null;
        }
        return edge;
    }

    private Object toElementId(ElementIdType elementIdType, String idString) {
        Object id;
        switch (elementIdType) {
            case INTEGER: {
                id = Integer.parseInt(idString);
                break;
            }
            case LONG: {
                id = Long.parseLong(idString);
                break;
            }
            default: {
                id = idString;
            }
        }
        return id;
    }

    private class GraphConfigurationWrapper {
        private final Class nodeIdType;
        private final Class edgeIdType;
        private final Class edgeLabelType;
        private final Class edgeWeightType;
        private final Boolean edgeWeightColumn;
        private final TimeRepresentation timeRepresentation;

        public GraphConfigurationWrapper(Configuration configuration) {
            this.nodeIdType = configuration.getNodeIdType();
            this.edgeIdType = configuration.getEdgeIdType();
            this.edgeLabelType = configuration.getEdgeLabelType();
            this.edgeWeightType = configuration.getEdgeWeightType();
            this.edgeWeightColumn = configuration.getEdgeWeightColumn();
            this.timeRepresentation = configuration.getTimeRepresentation();
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + Objects.hashCode(this.nodeIdType);
            hash = 19 * hash + Objects.hashCode(this.edgeIdType);
            hash = 19 * hash + Objects.hashCode(this.edgeLabelType);
            hash = 19 * hash + Objects.hashCode(this.edgeWeightType);
            hash = 19 * hash + Objects.hashCode(this.edgeWeightColumn);
            hash = 19 * hash + Objects.hashCode(this.timeRepresentation);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GraphConfigurationWrapper other = (GraphConfigurationWrapper)obj;
            if (!Objects.equals(this.nodeIdType, other.nodeIdType)) {
                return false;
            }
            if (!Objects.equals(this.edgeIdType, other.edgeIdType)) {
                return false;
            }
            if (!Objects.equals(this.edgeLabelType, other.edgeLabelType)) {
                return false;
            }
            if (!Objects.equals(this.edgeWeightType, other.edgeWeightType)) {
                return false;
            }
            if (!Objects.equals(this.edgeWeightColumn, other.edgeWeightColumn)) {
                return false;
            }
            return this.timeRepresentation == other.timeRepresentation;
        }

        public String toString() {
            return "GraphConfigurationWrapper{nodeIdType=" + this.nodeIdType + ", edgeIdType=" + this.edgeIdType + ", edgeLabelType=" + this.edgeLabelType + ", edgeWeightType=" + this.edgeWeightType + ", edgeWeightColumn=" + this.edgeWeightColumn + ", timeRepresentation=" + this.timeRepresentation + "}";
        }
    }
}

