/*
 * Decompiled with CFR 0.152.
 */
package gogohid.daemon;

import java.io.IOException;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class HIDGogo6Daemon
implements HidServicesListener {
    private HidServices hidServices;
    private HidDevice gogoBoard;
    private byte[] readBuffer;
    private Thread readThread;

    private void loadUpHIDServices() throws HidException {
        this.hidServices = HidManager.getHidServices();
        this.hidServices.addHidServicesListener((HidServicesListener)this);
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            System.err.println(hidDevice);
            if (hidDevice.getVendorId() != 1121 || hidDevice.getProductId() != 32) continue;
            this.gogoBoard = this.hidServices.getHidDevice(1121, 32, null);
            System.err.println("GoGo board found, using this one: " + this.gogoBoard);
        }
    }

    public void boot() {
        try {
            this.loadUpHIDServices();
        }
        catch (Exception e) {
            System.err.println("HID EXCEPTION");
            e.printStackTrace();
            throw new RuntimeException("Error in loading HID services");
        }
        if (this.gogoBoard == null || !this.gogoBoard.open()) {
            throw new RuntimeException("Failed to open device");
        }
        this.readBuffer = new byte[64];
        this.readThread = new Thread(new ReadThread(this));
        this.readThread.start();
    }

    public void shutDown() {
        this.readThread.interrupt();
    }

    private void write(byte[] message) {
        if (this.gogoBoard != null) {
            this.gogoBoard.write(message, message.length, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(byte[] message) {
        byte[] byArray = this.readBuffer;
        synchronized (this.readBuffer) {
            System.arraycopy(this.readBuffer, 0, message, 0, message.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private int getNumDevices() {
        int numDevices = 0;
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            if (hidDevice.getVendorId() != 1121 || hidDevice.getProductId() != 32) continue;
            ++numDevices;
        }
        return numDevices;
    }

    public void hidDeviceAttached(HidServicesEvent event) {
        System.err.println("Device attached: " + event);
        if (event.getHidDevice().getVendorId() == 1121 && event.getHidDevice().getProductId() == 32) {
            this.gogoBoard = this.hidServices.getHidDevice(1121, 32, null);
        }
    }

    public void hidDeviceDetached(HidServicesEvent event) {
        System.err.println("device detached");
        System.err.println(event.getHidDevice().toString());
        System.err.println(event.toString());
        if (event.getHidDevice().getVendorId() == 1121 && event.getHidDevice().getProductId() == 32) {
            this.gogoBoard = null;
        }
    }

    public void hidFailure(HidServicesEvent arg0) {
        System.err.println("HID failure");
    }

    public void hidDataReceived(HidServicesEvent event) {
    }

    public static void main(String[] args) throws IOException {
        System.err.println("HID daemon started!");
        HIDGogo6Daemon d = new HIDGogo6Daemon();
        d.boot();
        boolean quit = false;
        while (!quit) {
            byte[] message;
            int numBytes;
            int c = System.in.read();
            if (c == 83) {
                numBytes = System.in.read();
                message = new byte[numBytes];
                System.in.read(message);
                d.write(message);
                continue;
            }
            if (c == 82) {
                numBytes = System.in.read();
                message = new byte[numBytes];
                d.read(message);
                System.out.write(message);
                System.out.flush();
                continue;
            }
            if (c == 78) {
                System.out.write(d.getNumDevices());
                System.out.flush();
                continue;
            }
            if (c != 88) continue;
            System.err.println("HID daemon quit code received.");
            quit = true;
        }
        d.shutDown();
        if (d != null && d.gogoBoard != null) {
            d.gogoBoard.close();
        }
        System.err.println("HID daemon run complete.");
    }

    private static class ReadThread
    extends Thread {
        private static final int READ_DELAY = 30;
        private HIDGogo6Daemon d;

        ReadThread(HIDGogo6Daemon d) {
            this.d = d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (true) {
                    byte[] byArray = this.d.readBuffer;
                    // MONITORENTER : this.d.readBuffer
                    if (this.d.gogoBoard != null) {
                        this.d.gogoBoard.read(this.d.readBuffer, 200);
                    }
                    // MONITOREXIT : byArray
                    Thread.sleep(30L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

