/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.NoopHostnameVerifier;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class DisabledComplainingHostnameVerifier
implements HostnameVerifier {
    private final NoDepsLogger logger;
    private final NoopHostnameVerifier defaultHostnameVerifier;

    public DisabledComplainingHostnameVerifier(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
        this.defaultHostnameVerifier = new NoopHostnameVerifier();
    }

    @Override
    public boolean verify(String hostname, SSLSession sslSession) {
        boolean hostNameMatches = this.defaultHostnameVerifier.verify(hostname, sslSession);
        if (!hostNameMatches) {
            String msg = "Hostname verification failed on hostname " + hostname + ", " + "but the connection was accepted because ssl-config.loose.disableHostnameVerification is enabled. " + "Please fix the X.509 certificate on the host to remove this warning.";
            this.logger.warn(msg);
        }
        return true;
    }
}

