/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.KeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeystoreFormats$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;

public class FileBasedKeyStoreBuilder
implements KeyStoreBuilder {
    private final String keyStoreType;
    private final String filePath;
    private final Option<char[]> password;

    public FileBasedKeyStoreBuilder(String keyStoreType, String filePath, Option<char[]> password) {
        this.keyStoreType = keyStoreType;
        this.filePath = filePath;
        this.password = password;
    }

    @Override
    public KeyStore build() {
        KeyStore keyStore;
        File file = new File(this.filePath);
        Predef$.MODULE$.require(file.exists(), this::build$$anonfun$1);
        Predef$.MODULE$.require(file.canRead(), this::build$$anonfun$2);
        String string = this.keyStoreType;
        if ("PEM".equals(string)) {
            Iterable<Certificate> certs = this.readCertificates(file);
            keyStore = KeystoreFormats$.MODULE$.loadCertificates((IterableOnce<Certificate>)certs);
        } else {
            String otherFormat = string;
            keyStore = this.buildFromKeystoreFile(otherFormat, file);
        }
        return keyStore;
    }

    public KeyStore buildFromKeystoreFile(String storeType, File file) {
        KeyStore keyStore;
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            String storeType2 = this.keyStoreType;
            KeyStore store = KeyStore.getInstance(storeType2);
            store.load(inputStream, (char[])this.password.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            keyStore = store;
        }
        return keyStore;
    }

    public Iterable<Certificate> readCertificates(File file) {
        Iterable iterable;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            iterable = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cf.generateCertificates(bis)).asScala();
        }
        return iterable;
    }

    private final String build$$anonfun$1() {
        return "Key store file " + this.filePath + " does not exist!";
    }

    private final String build$$anonfun$2() {
        return "Cannot read from key store file " + this.filePath + "!";
    }
}

