/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.KeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeystoreFormats$;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;

public class FileOnClasspathBasedKeyStoreBuilder
implements KeyStoreBuilder {
    private final String keyStoreType;
    private final String filePath;
    private final Option<char[]> password;

    public FileOnClasspathBasedKeyStoreBuilder(String keyStoreType, String filePath, Option<char[]> password) {
        this.keyStoreType = keyStoreType;
        this.filePath = filePath;
        this.password = password;
    }

    @Override
    public KeyStore build() {
        KeyStore keyStore;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.filePath);
        Predef$.MODULE$.require(is != null, this::build$$anonfun$1);
        String string = this.keyStoreType;
        if ("PEM".equals(string)) {
            Iterable<Certificate> certs = this.readCertificates(is);
            keyStore = KeystoreFormats$.MODULE$.loadCertificates((IterableOnce<Certificate>)certs);
        } else {
            String otherFormat = string;
            keyStore = this.buildFromKeystoreFile(otherFormat, is);
        }
        return keyStore;
    }

    public KeyStore buildFromKeystoreFile(String storeType, InputStream is) {
        KeyStore keyStore;
        try (BufferedInputStream inputStream = new BufferedInputStream(is);){
            String storeType2 = this.keyStoreType;
            KeyStore store = KeyStore.getInstance(storeType2);
            store.load(inputStream, (char[])this.password.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            keyStore = store;
        }
        return keyStore;
    }

    public Iterable<Certificate> readCertificates(InputStream is) {
        Iterable iterable;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            iterable = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cf.generateCertificates(bis)).asScala();
        }
        return iterable;
    }

    private final String build$$anonfun$1() {
        return "Key store file " + this.filePath + " was not found on the class path!";
    }
}

