/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.tracing.TraceLogger;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TracingSSLServerSocketFactory
extends SSLServerSocketFactory
implements TraceLogger {
    private final Function0<SSLServerSocketFactory> factory;
    private final SSLDebugConfig debug;
    private final LoggerFactory lf;

    public TracingSSLServerSocketFactory(Function0 factory, SSLDebugConfig debug, LoggerFactory lf) {
        this.factory = factory;
        this.debug = debug;
        this.lf = lf;
    }

    @Override
    public ServerSocket createServerSocket() {
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(), this.lf);
    }

    @Override
    public ServerSocket createServerSocket(int port) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"port");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)port));
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(port), this.lf);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"port");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)port));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"backlog");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)backlog));
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(port, backlog), this.lf);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"port");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)port));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"backlog");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)backlog));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ifAddress");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)ifAddress);
        return (ServerSocket)this.tracer("createServerSocket", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((ServerSocketFactory)this.factory.apply()).createServerSocket(port, backlog, ifAddress), this.lf);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return (String[])this.tracer("getDefaultCipherSuites", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLServerSocketFactory)this.factory.apply()).getDefaultCipherSuites(), this.lf);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return (String[])this.tracer("getSupportedCipherSuites", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLServerSocketFactory)this.factory.apply()).getSupportedCipherSuites(), this.lf);
    }

    @Override
    public boolean isLogEnabled(String methodName, Map<String, Object> parameters) {
        return this.debug.all() || this.debug.ssl();
    }
}

