/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashMap;

public class HeaderIdGenerator
implements HtmlIdGenerator {
    @Override
    public void generateIds(Document document) {
        final HashMap headerBaseIds = new HashMap();
        final boolean resolveDupes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_RESOLVE_DUPES.getFrom((DataHolder)document);
        final String toDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.getFrom((DataHolder)document);
        final boolean noDupedDashes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES.getFrom((DataHolder)document);
        new AnchorRefTargetBlockVisitor(){

            @Override
            protected void visit(AnchorRefTarget node) {
                String text = node.getAnchorRefText();
                if (!text.isEmpty()) {
                    String baseRefId = HeaderIdGenerator.generateId(text, toDashChars, noDupedDashes);
                    if (resolveDupes) {
                        if (headerBaseIds.containsKey(baseRefId)) {
                            int index = (Integer)headerBaseIds.get(baseRefId);
                            headerBaseIds.put(baseRefId, ++index);
                            baseRefId = baseRefId + "-" + index;
                        } else {
                            headerBaseIds.put(baseRefId, 0);
                        }
                    }
                    node.setAnchorRefId(baseRefId);
                }
            }
        }.visit((Node)document);
    }

    @Override
    public String getId(Node node) {
        return node instanceof AnchorRefTarget ? ((AnchorRefTarget)node).getAnchorRefId() : null;
    }

    public static String generateId(CharSequence headerText, String toDashChars, boolean noDupedDashes) {
        int iMax = headerText.length();
        StringBuilder baseRefId = new StringBuilder(iMax);
        if (toDashChars == null) {
            toDashChars = " -_";
        }
        for (int i = 0; i < iMax; ++i) {
            char c = headerText.charAt(i);
            if (HeaderIdGenerator.isAlphabetic(c)) {
                baseRefId.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isDigit(c)) {
                baseRefId.append(c);
                continue;
            }
            if (toDashChars.indexOf(c) == -1 || noDupedDashes && (c != '-' || baseRefId.length() != 0) && (baseRefId.length() == 0 || baseRefId.charAt(baseRefId.length() - 1) == '-')) continue;
            baseRefId.append('-');
        }
        return baseRefId.toString();
    }

    public static boolean isAlphabetic(char c) {
        return (1086 >> Character.getType((int)c) & 1) != 0;
    }

    public static class Factory
    implements HeaderIdGeneratorFactory {
        @Override
        public HtmlIdGenerator create(NodeRendererContext context) {
            return new HeaderIdGenerator();
        }
    }
}

