/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.Reporter;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public class ScaleGradientHSB
implements Reporter {
    private LogoList colorLogoList = null;
    private double var = 0.0;
    private double min = 0.0;
    private double max = 0.0;
    static final int SIZE = 256;
    private static LogoList colorLogoListCache = null;
    private static double[][] gradientArray = null;

    public Syntax getSyntax() {
        int[] right = new int[]{Syntax.ListType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()};
        int ret = Syntax.ListType();
        return SyntaxJ.reporterSyntax((int[])right, (int)ret);
    }

    public Object report(Argument[] args, Context context) throws ExtensionException {
        double tempmax;
        double tempval;
        try {
            this.colorLogoList = args[0].getList();
            this.var = args[1].getDoubleValue();
            this.min = args[2].getDoubleValue();
            this.max = args[3].getDoubleValue();
        }
        catch (LogoException e) {
            throw new ExtensionException(e.getMessage());
        }
        for (int i = 0; i < this.colorLogoList.length(); ++i) {
            if (this.colorLogoList.get(i) instanceof Double) {
                throw new ExtensionException("Detected double as input, must input HSB lists for scale-gradient-hsb");
            }
            LogoList HSBList = (LogoList)this.colorLogoList.get(i);
            this.validHSBList(HSBList);
        }
        double perc = 0.0;
        if (this.min > this.max) {
            if (this.var < this.max) {
                perc = 1.0;
            } else if (this.var > this.min) {
                perc = 0.0;
            } else {
                tempval = this.min - this.var;
                tempmax = this.min - this.max;
                perc = tempval / tempmax;
            }
        } else if (this.var > this.max) {
            perc = 1.0;
        } else if (this.var < this.min) {
            perc = 0.0;
        } else {
            tempval = this.var - this.min;
            tempmax = this.max - this.min;
            perc = tempval / tempmax;
        }
        int index = this.colorLogoList.size() < 3 ? (int)Math.round(perc * 255.0) : (int)Math.round(perc * (double)(255 + 256 * (this.colorLogoList.size() - 2)));
        if (colorLogoListCache == null || !colorLogoListCache.equals(this.colorLogoList)) {
            colorLogoListCache = this.colorLogoList;
            Iterator it = this.colorLogoList.javaIterator();
            LogoListBuilder colorList = new LogoListBuilder();
            it = this.colorLogoList.javaIterator();
            for (int i = 0; i < this.colorLogoList.length(); ++i) {
                colorList.add((Object)((LogoList)this.colorLogoList.get(i)));
            }
            LogoList inputHSB = colorList.toLogoList();
            gradientArray = new double[256 * (inputHSB.length() - 1)][3];
            for (int i = 0; i < inputHSB.length() - 1; ++i) {
                ColorGradientHSB colorGradient = new ColorGradientHSB();
                LogoList ll1 = (LogoList)inputHSB.get(i);
                LogoList ll2 = (LogoList)inputHSB.get(i + 1);
                double[] color1 = new double[]{(Double)ll1.get(0), (Double)ll1.get(1), (Double)ll1.get(2)};
                double[] color2 = new double[]{(Double)ll2.get(0), (Double)ll2.get(1), (Double)ll2.get(2)};
                colorGradient.genArray(color1, color2, 256);
                for (int j = 0; j < 256; ++j) {
                    ScaleGradientHSB.gradientArray[j + 256 * i] = colorGradient.getHSBArray()[j];
                    LogoListBuilder toRGB = new LogoListBuilder();
                    for (int k = 0; k < 3; ++k) {
                        toRGB.add((Object)gradientArray[j + 256 * i][k]);
                    }
                    LogoList rgb = HSBUpdated.HSBtoRGB(toRGB.toLogoList());
                    for (int k = 0; k < 3; ++k) {
                        ScaleGradientHSB.gradientArray[j + 256 * i][k] = (Double)rgb.get(k);
                    }
                }
            }
        }
        LogoListBuilder gradientList = new LogoListBuilder();
        try {
            gradientList.add((Object)gradientArray[index][0]);
            gradientList.add((Object)gradientArray[index][1]);
            gradientList.add((Object)gradientArray[index][2]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExtensionException("Please e-mail send this error to bugs@ccl.northwestern.edu" + e.getMessage());
        }
        return gradientList.toLogoList();
    }

    void validHSBList(LogoList hsb) throws ExtensionException {
        if (hsb.size() != 3) {
            throw new ExtensionException("HSB must have three elements");
        }
        if ((Double)hsb.get(0) < 0.0 || (Double)hsb.get(0) > 360.0) {
            throw new ExtensionException("Hue must be in the range from 0 to 360");
        }
        if ((Double)hsb.get(1) < 0.0 || (Double)hsb.get(1) > 100.0) {
            throw new ExtensionException("Saturation must be in the range from 0 to 100");
        }
        if ((Double)hsb.get(2) < 0.0 || (Double)hsb.get(2) > 100.0) {
            throw new ExtensionException("Brightness must be in the range from 0 to 100");
        }
    }
}

