/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.table;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nlogo.api.Dump;
import org.nlogo.api.Equality;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.LogoList;

public class Table
extends LinkedHashMap<Object, Object>
implements ExtensionObject {
    private static long next = 0L;
    public final long id;

    public static void resetNext() {
        next = 0L;
    }

    public Table() {
        this.id = next++;
    }

    public Table(LogoList alist) throws ExtensionException {
        this();
        this.addAll(alist);
    }

    public void addAll(LogoList alist) throws ExtensionException {
        Iterator it = alist.javaIterator();
        while (it.hasNext()) {
            Object pair = it.next();
            if (pair instanceof LogoList && ((LogoList)pair).size() < 2 || !(pair instanceof LogoList)) {
                throw new ExtensionException("expected a two-element list: " + Dump.logoObject(pair));
            }
            this.put(((LogoList)pair).first(), ((LogoList)pair).butFirst().first());
        }
    }

    public Table(long id) {
        this.id = id;
        next = StrictMath.max(next, id + 1L);
    }

    public Table(Map<?, ?> map) {
        this.id = next++;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), this.getTableValue(entry.getValue()));
        }
    }

    private Object getTableValue(Object value) {
        if (value instanceof LinkedTreeMap) {
            return new Table((Map<?, ?>)((Map)value));
        }
        if (value instanceof ArrayList) {
            LogoListBuilder alist = new LogoListBuilder();
            ((ArrayList)value).forEach((? super E temp) -> alist.add(this.getTableValue(temp)));
            return alist.toLogoList();
        }
        return value;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public LogoList toList() {
        LogoListBuilder alist = new LogoListBuilder();
        for (Map.Entry entry : this.entrySet()) {
            LogoListBuilder pair = new LogoListBuilder();
            pair.add(entry.getKey());
            pair.add(entry.getValue());
            alist.add((Object)pair.toLogoList());
        }
        return alist.toLogoList();
    }

    public LogoList valuesList() {
        LogoListBuilder alist = new LogoListBuilder();
        for (Map.Entry entry : this.entrySet()) {
            alist.add(entry.getValue());
        }
        return alist.toLogoList();
    }

    public String dump(boolean readable, boolean exportable, boolean reference) {
        if (exportable && reference) {
            return "" + this.id;
        }
        return (String)(exportable ? this.id + ": " : "") + Dump.logoObject((Object)this.toList(), (boolean)true, (boolean)exportable);
    }

    public String getExtensionName() {
        return "table";
    }

    public String getNLTypeName() {
        return "";
    }

    public boolean recursivelyEqual(Object o) {
        if (!(o instanceof Table)) {
            return false;
        }
        Table otherTable = (Table)o;
        if (this.size() != otherTable.size()) {
            return false;
        }
        for (Object key : this.keySet()) {
            if (otherTable.containsKey(key) && Equality.equals(this.get(key), otherTable.get(key))) continue;
            return false;
        }
        return true;
    }
}

