/*
 * Decompiled with CFR 0.152.
 */
package bsearch.algorithms;

import bsearch.algorithms.AbstractSearchMethod;
import bsearch.algorithms.SearchParameterException;
import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.SearchManager;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.space.SearchSpace;
import java.util.HashMap;
import org.nlogo.api.MersenneTwisterFast;

public class RandomSearch
extends AbstractSearchMethod {
    @Override
    public String getName() {
        return "RandomSearch";
    }

    @Override
    public String getDescription() {
        return "A baseline search algorithm that repeatedly tries random locations in the search space, and returns the best found.";
    }

    @Override
    public void setSearchParams(HashMap<String, String> searchMethodParams) throws SearchParameterException {
    }

    @Override
    public HashMap<String, String> getSearchParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        return params;
    }

    @Override
    public HashMap<String, String> getSearchParamsHelp() {
        HashMap<String, String> params = new HashMap<String, String>();
        return params;
    }

    @Override
    public void search(SearchSpace space, ChromosomeFactory cFactory, SearchProtocol protocol, SearchManager manager, MersenneTwisterFast rng) throws BehaviorSearchException, NetLogoLinkException, InterruptedException {
        int BATCH_SIZE = 16;
        int maxRunsForBatch = 16 * manager.getFitnessFunction().getMaximumRunsThatCouldBeNeeded(protocol.fitnessSamplingReplications);
        if (maxRunsForBatch == 0) {
            maxRunsForBatch = Integer.MAX_VALUE;
        }
        while (!manager.searchFinished()) {
            if (manager.getRemainingEvaluations() > maxRunsForBatch) {
                Chromosome[] points = new Chromosome[16];
                for (int i = 0; i < points.length; ++i) {
                    points[i] = cFactory.createChromosome(space, rng);
                }
                manager.computeFitnessBatch(points, protocol.fitnessSamplingReplications, rng);
                continue;
            }
            Chromosome point = cFactory.createChromosome(space, rng);
            manager.computeFitnessSingle(point, protocol.fitnessSamplingReplications, rng);
        }
    }
}

