/*
 * Decompiled with CFR 0.152.
 */
package bsearch.app;

import bsearch.algorithms.SearchMethod;
import bsearch.algorithms.SearchMethodLoader;
import bsearch.app.BehaviorSearch;
import bsearch.app.BehaviorSearchException;
import bsearch.app.GUIProgressDialog;
import bsearch.app.HelpAboutDialog;
import bsearch.app.HelpInfoDialog;
import bsearch.app.RunOptionsDialog;
import bsearch.app.SearchProtocol;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.nlogolink.Utils;
import bsearch.representations.ChromosomeFactory;
import bsearch.representations.ChromosomeTypeLoader;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import bsearch.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.nlogo.awt.UserCancelException;
import org.nlogo.swing.BrowserLauncher;
import org.xml.sax.SAXException;

public class BehaviorSearchGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JMenuBar jMenuBar;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemNew;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemSave;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemExit;
    private JSeparator jSeparator1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabelSep;
    private JPanel jPanelSampling;
    private JPanel jPanelMeasureAfter;
    private JScrollPane jScrollPane1;
    private JTable jTableSearchMethodParams;
    private JPanel jPanel1;
    private JButton jButtonHelpSearchSpace;
    private JLabel jLabelDerivWRT;
    private JLabel jLabelDerivDELTA;
    private JTextField jTextFieldFitnessDerivativeDelta;
    private JComboBox<String> jComboBoxFitnessDerivativeParameter;
    private JCheckBox jCheckBoxTakeDerivative;
    private JCheckBox jCheckBoxFitnessDerivativeUseAbs;
    private JPanel jPanelDeriv;
    private JPanel jPanelDeriv2;
    private JButton jButtonHelpSearchSpaceRepresentation;
    private JSeparator jSeparator2;
    private JMenuItem jMenuItemOpenExample;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemTutorial;
    private JMenu jMenuHelp;
    private JTextField jTextFieldBestChecking;
    private JLabel jLabel19;
    private JCheckBox jCheckBoxCaching;
    private JButton jButtonSuggestParamRanges;
    private JButton jButtonHelpEvaluation;
    private JButton jButtonHelpSearchMethod;
    private JTextField jTextFieldEvaluationLimit;
    private JLabel jLabel18;
    private JLabel jLabel9;
    private JTextField jTextFieldFitnessSamplingRepetitions;
    private JComboBox<String> jComboBoxFitnessSamplingMethod;
    private JComboBox<String> jComboBoxSearchMethodType;
    private JTextField jTextFieldModelStepLimit;
    private JTextArea jTextAreaParamSpecs;
    private JButton jButtonBrowseModel;
    private JTextField jTextFieldMeasureIf;
    private JLabel jLabel17;
    private JComboBox<String> jComboBoxFitnessCombineReplications;
    private JLabel jLabel16;
    private JLabel jLabel15;
    private JLabel jLabel14;
    private JComboBox<String> jComboBoxFitnessCollecting;
    private JLabel jLabel13;
    private JComboBox<String> jComboBoxChromosomeType;
    private JLabel jLabel11;
    private JScrollPane jScrollPane2;
    private JTextField jTextFieldModelFile;
    private JTextField jTextFieldModelStopCondition;
    private JComboBox<String> jComboBoxFitnessMinMax;
    private JTextField jTextFieldFitnessMetric;
    private JTextField jTextFieldModelStepCommands;
    private JTextField jTextFieldModelSetupCommands;
    private JButton jButtonRunNow;
    private String defaultProtocolXMLForNewSearch;
    private File currentFile;
    private String lastSavedText;
    private HashMap<String, SearchMethod> searchMethodChoices;
    BehaviorSearch.RunOptions runOptions;
    private File defaultUserDocumentsFolder;

    private static String getWindowTitleSuffix() {
        return " - BehaviorSearch " + GeneralUtils.getVersionString();
    }

    public static void main(String[] args) {
        BehaviorSearchGUI.mainWithAppHandler(args, null);
    }

    public static void mainWithAppHandler(final String[] args, final Object appHandler) {
        BehaviorSearchGUI.initAppHandler(appHandler);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File f;
                BehaviorSearchGUI bgui = new BehaviorSearchGUI();
                bgui.setLocationRelativeTo(null);
                bgui.setVisible(true);
                BehaviorSearchGUI.readyAppHandler(appHandler, bgui);
                if (args.length > 0 && (f = new File(args[0])).exists()) {
                    bgui.openFile(f);
                }
            }
        });
    }

    public static void initAppHandler(Object appHandler) {
        try {
            if (appHandler != null) {
                appHandler.getClass().getDeclaredMethod("init", new Class[0]).invoke(appHandler, new Object[0]);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("failed to init appHandler, continuing...");
        }
    }

    public static void readyAppHandler(Object appHandler, Object bgui) {
        try {
            if (appHandler != null) {
                appHandler.getClass().getDeclaredMethod("ready", Object.class).invoke(appHandler, bgui);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("failed to ready appHandler, continuing...");
        }
    }

    public BehaviorSearchGUI() {
        try {
            if (System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").startsWith("Windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (System.getProperty("swing.defaultlaf") == null) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.searchMethodChoices = new HashMap();
        this.runOptions = null;
        this.defaultUserDocumentsFolder = new JFileChooser().getCurrentDirectory();
        this.initGUI();
        this.finishInitWork();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent arg0) {
                }

                @Override
                public void windowClosed(WindowEvent arg0) {
                }

                @Override
                public void windowClosing(WindowEvent arg0) {
                    BehaviorSearchGUI.this.actionExit();
                }

                @Override
                public void windowDeactivated(WindowEvent arg0) {
                }

                @Override
                public void windowDeiconified(WindowEvent arg0) {
                }

                @Override
                public void windowIconified(WindowEvent arg0) {
                }

                @Override
                public void windowOpened(WindowEvent arg0) {
                }
            });
            GridBagLayout thisLayout = new GridBagLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("BehaviorSearch - Experiment Editor");
            thisLayout.rowWeights = new double[]{0.0, 0.1, 0.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.0, 0.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.0, 0.1, 0.0};
            thisLayout.rowHeights = new int[]{7, 25, 10, 25, 25, 25, 25, 20, 25, 10, 25, 25, 25, 25, 20, 20, 20, 23, 20, 7};
            thisLayout.columnWeights = new double[]{0.0, 0.1, 0.0, 0.1, 0.0, 0.0};
            thisLayout.columnWidths = new int[]{7, 300, 29, 200, 207, 7};
            this.jMenuBar = new JMenuBar();
            this.setJMenuBar(this.jMenuBar);
            this.jMenuFile = new JMenu();
            this.jMenuBar.add(this.jMenuFile);
            this.jMenuFile.setText("File");
            this.jMenuItemNew = new JMenuItem();
            this.jMenuFile.add(this.jMenuItemNew);
            this.jMenuItemNew.setText("New");
            this.jMenuItemNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionNew();
                }
            });
            this.jMenuItemOpen = new JMenuItem();
            this.jMenuFile.add(this.jMenuItemOpen);
            this.jMenuItemOpen.setText("Open...");
            this.jMenuItemOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionOpen();
                }
            });
            this.jMenuItemSave = new JMenuItem();
            this.jMenuFile.add(this.jMenuItemSave);
            this.jMenuItemSave.setText("Save");
            this.jMenuItemSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionSave();
                }
            });
            this.jMenuItemSaveAs = new JMenuItem();
            this.jMenuFile.add(this.jMenuItemSaveAs);
            this.jMenuItemSaveAs.setText("Save as...");
            this.jMenuItemSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionSaveAs();
                }
            });
            this.jSeparator1 = new JSeparator();
            this.jMenuFile.add(this.jSeparator1);
            this.jMenuItemOpenExample = new JMenuItem();
            this.jMenuFile.add(this.jMenuItemOpenExample);
            this.jMenuItemOpenExample.setText("Open Example...");
            this.jMenuItemOpenExample.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionOpenExample();
                }
            });
            this.jSeparator2 = new JSeparator();
            this.jMenuFile.add(this.jSeparator2);
            this.jMenuItemExit = new JMenuItem();
            this.jMenuFile.add(this.jMenuItemExit);
            this.jMenuItemExit.setText("Exit");
            this.jMenuItemExit.setMnemonic(88);
            this.jMenuItemExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionExit();
                }
            });
            this.jMenuHelp = new JMenu();
            this.jMenuBar.add(this.jMenuHelp);
            this.jMenuHelp.setText("Help");
            this.jMenuItemTutorial = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemTutorial);
            this.jMenuItemTutorial.setText("Tutorial");
            this.jMenuItemTutorial.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionHelpTutorial();
                }
            });
            this.jMenuItemAbout = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemAbout);
            this.jMenuItemAbout.setText("About...");
            this.jMenuItemAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionHelpAbout();
                }
            });
            this.jLabel2 = new JLabel();
            this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Setup:  ");
            this.jLabel2.setFont(new Font("Tahoma", 1, 11));
            this.jTextFieldModelSetupCommands = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldModelSetupCommands, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jTextFieldModelSetupCommands.setText("setup");
            this.jTextFieldModelSetupCommands.setBorder(BorderFactory.createBevelBorder(1));
            this.jTextFieldModelSetupCommands.setFont(new Font("Monospaced", 0, 11));
            this.jTextFieldModelStepCommands = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldModelStepCommands, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jTextFieldModelStepCommands.setText("go");
            this.jTextFieldModelStepCommands.setBorder(BorderFactory.createBevelBorder(1));
            this.jTextFieldModelStepCommands.setFont(new Font("Monospaced", 0, 11));
            this.jLabel3 = new JLabel();
            this.getContentPane().add((Component)this.jLabel3, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText("Step:  ");
            this.jLabel3.setFont(new Font("Tahoma", 1, 11));
            this.jLabel10 = new JLabel();
            this.getContentPane().add((Component)this.jLabel10, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel10.setText("Stop If:  ");
            this.jLabel10.setFont(new Font("SansSerif", 1, 11));
            this.jTextFieldModelStopCondition = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldModelStopCondition, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jTextFieldModelStopCondition.setFont(new Font("Monospaced", 0, 11));
            this.jTextFieldModelStopCondition.setText("count turtles > 100");
            this.jTextFieldModelStopCondition.setBorder(BorderFactory.createBevelBorder(1));
            this.jLabel4 = new JLabel();
            this.getContentPane().add((Component)this.jLabel4, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel4.setText("Measure:  ");
            this.jLabel4.setFont(new Font("SansSerif", 1, 11));
            this.jTextFieldFitnessMetric = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldFitnessMetric, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jTextFieldFitnessMetric.setText("mean [energy] of turtles");
            this.jTextFieldFitnessMetric.setBorder(BorderFactory.createBevelBorder(1));
            this.jTextFieldFitnessMetric.setFont(new Font("Monospaced", 0, 11));
            this.jLabelSep = new JLabel();
            this.getContentPane().add((Component)this.jLabelSep, new GridBagConstraints(1, 9, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabelSep.setBackground(new Color(0, 0, 0));
            this.jLabelSep.setBorder(new SoftBevelBorder(1, null, null, null, null));
            this.jLabelSep.setPreferredSize(new Dimension(0, 5));
            this.jLabel6 = new JLabel();
            this.getContentPane().add((Component)this.jLabel6, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel6.setText("Search Method Configuration");
            this.jLabel6.setFont(new Font("SansSerif", 1, 14));
            this.jLabel6.setBounds(197, 32, 138, 19);
            this.jLabel7 = new JLabel();
            this.getContentPane().add((Component)this.jLabel7, new GridBagConstraints(3, 10, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel7.setText("Objective / Fitness Function");
            this.jLabel7.setFont(new Font("SansSerif", 1, 14));
            this.jPanelSampling = new JPanel();
            this.getContentPane().add((Component)this.jPanelSampling, new GridBagConstraints(3, 13, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelSampling.setOpaque(false);
            DefaultComboBoxModel<String> jComboBoxSamplingMethodModel = new DefaultComboBoxModel<String>(new String[]{"Fixed Sampling"});
            this.jComboBoxFitnessSamplingMethod = new JComboBox();
            this.jPanelSampling.add(this.jComboBoxFitnessSamplingMethod);
            this.jComboBoxFitnessSamplingMethod.setModel(jComboBoxSamplingMethodModel);
            this.jComboBoxFitnessSamplingMethod.setEditable(false);
            this.jComboBoxFitnessSamplingMethod.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    BehaviorSearchGUI.this.actionSamplingMethodChanged();
                }
            });
            this.jTextFieldFitnessSamplingRepetitions = new JTextField();
            this.jPanelSampling.add(this.jTextFieldFitnessSamplingRepetitions);
            this.jTextFieldFitnessSamplingRepetitions.setText("10");
            this.jTextFieldFitnessSamplingRepetitions.setPreferredSize(new Dimension(50, 20));
            this.jTextFieldFitnessSamplingRepetitions.setFont(new Font("Monospaced", 0, 11));
            this.jTextFieldFitnessSamplingRepetitions.setToolTipText("How many times should the model be run, for a given setting of the parameters?");
            this.jLabel8 = new JLabel();
            this.jPanelSampling.add(this.jLabel8);
            this.jLabel8.setText("replicates");
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(1, 12, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jScrollPane1.setPreferredSize(new Dimension(202, 58));
            DefaultTableModel jTableSearchMethodParamsModel = new DefaultTableModel(new String[][]{{"population", "100"}, {"mutation-rate", "1.0"}, {"crossover-rate", "0.70"}}, new String[]{"Parameter", "Value"});
            this.jTableSearchMethodParams = new JTable();
            this.jScrollPane1.setViewportView(this.jTableSearchMethodParams);
            this.jTableSearchMethodParams.setModel(jTableSearchMethodParamsModel);
            this.jTableSearchMethodParams.getColumn(this.jTableSearchMethodParams.getColumnName(0)).setPreferredWidth(120);
            this.jButtonRunNow = new JButton();
            this.getContentPane().add((Component)this.jButtonRunNow, new GridBagConstraints(3, 18, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jButtonRunNow.setText("Run BehaviorSearch");
            this.jButtonRunNow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionRunNow();
                }
            });
            DefaultComboBoxModel<String> jComboBoxMinMaxModel = new DefaultComboBoxModel<String>(new String[]{"Minimize Fitness", "Maximize Fitness"});
            this.jComboBoxFitnessMinMax = new JComboBox();
            this.getContentPane().add(this.jComboBoxFitnessMinMax, new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jComboBoxFitnessMinMax.setModel(jComboBoxMinMaxModel);
            this.jPanelMeasureAfter = new JPanel();
            this.getContentPane().add((Component)this.jPanelMeasureAfter, new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelMeasureAfter.setOpaque(false);
            this.jTextFieldModelStepLimit = new JTextField();
            this.jPanelMeasureAfter.add(this.jTextFieldModelStepLimit);
            this.jTextFieldModelStepLimit.setText("100");
            this.jTextFieldModelStepLimit.setPreferredSize(new Dimension(50, 20));
            this.jTextFieldModelStepLimit.setFont(new Font("Monospaced", 0, 11));
            this.jLabel5 = new JLabel();
            this.jPanelMeasureAfter.add(this.jLabel5);
            this.jLabel5.setText("model steps");
            this.jLabel12 = new JLabel();
            this.getContentPane().add((Component)this.jLabel12, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel12.setBackground(new Color(0, 0, 0));
            this.jLabel12.setPreferredSize(new Dimension(0, 5));
            this.jLabel12.setBorder(new SoftBevelBorder(1, null, null, null, null));
            this.jTextFieldModelFile = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldModelFile, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jTextFieldModelFile.setText("Model.nlogo");
            this.jTextFieldModelFile.setToolTipText("Path to .nlogo file - may be specified relative to the folder containing the '.bsearch' file");
            this.jButtonBrowseModel = new JButton();
            this.getContentPane().add((Component)this.jButtonBrowseModel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.jButtonBrowseModel.setText("Browse for model...");
            this.jButtonBrowseModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionBrowseModel();
                }
            });
            this.jScrollPane2 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane2, new GridBagConstraints(1, 4, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jTextAreaParamSpecs = new JTextArea();
            this.jTextAreaParamSpecs.setText("[\"variable1\" [0 1 10]] \n[\"variable2\" [0.0 \"C\" 5.0]] \n[\"variable3\" \"moore\" \"vonN\"] \n[\"variable4\" true false]");
            this.jTextAreaParamSpecs.setBorder(BorderFactory.createBevelBorder(1));
            this.jTextAreaParamSpecs.setFont(new Font("Monospaced", 0, 11));
            this.jTextAreaParamSpecs.setAutoscrolls(true);
            this.jScrollPane2.setViewportView(this.jTextAreaParamSpecs);
            this.jLabel11 = new JLabel();
            this.getContentPane().add((Component)this.jLabel11, new GridBagConstraints(1, 17, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel11.setText("Search Encoding Representation");
            this.jLabel11.setFont(new Font("SansSerif", 1, 11));
            DefaultComboBoxModel<String> jComboBoxChromosomeTypeModel = new DefaultComboBoxModel<String>(new String[]{"MixedTypeChromosome"});
            this.jComboBoxChromosomeType = new JComboBox();
            this.getContentPane().add(this.jComboBoxChromosomeType, new GridBagConstraints(1, 18, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jComboBoxChromosomeType.setModel(jComboBoxChromosomeTypeModel);
            this.jLabel13 = new JLabel();
            this.getContentPane().add((Component)this.jLabel13, new GridBagConstraints(3, 12, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel13.setText("Collected measure:  ");
            this.jLabel13.setFont(new Font("SansSerif", 1, 11));
            DefaultComboBoxModel<String> jComboBox1Model = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.jComboBoxFitnessCollecting = new JComboBox();
            this.getContentPane().add(this.jComboBoxFitnessCollecting, new GridBagConstraints(4, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jComboBoxFitnessCollecting.setModel(jComboBox1Model);
            this.jLabel14 = new JLabel();
            this.getContentPane().add((Component)this.jLabel14, new GridBagConstraints(3, 14, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel14.setText("Combine replicates:  ");
            this.jLabel14.setFont(new Font("SansSerif", 1, 11));
            this.jLabel15 = new JLabel();
            this.getContentPane().add((Component)this.jLabel15, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel15.setText("Step Limit:  ");
            this.jLabel15.setFont(new Font("SansSerif", 1, 11));
            this.jLabel16 = new JLabel();
            this.getContentPane().add((Component)this.jLabel16, new GridBagConstraints(3, 11, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel16.setText("Goal:  ");
            this.jLabel16.setFont(new Font("SansSerif", 1, 11));
            jComboBox1Model = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.jComboBoxFitnessCombineReplications = new JComboBox();
            this.getContentPane().add(this.jComboBoxFitnessCombineReplications, new GridBagConstraints(4, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jComboBoxFitnessCombineReplications.setModel(jComboBox1Model);
            this.jLabel17 = new JLabel();
            this.getContentPane().add((Component)this.jLabel17, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel17.setText("Measure If:  ");
            this.jLabel17.setFont(new Font("SansSerif", 1, 11));
            this.jTextFieldMeasureIf = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldMeasureIf, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jTextFieldMeasureIf.setFont(new Font("Monospaced", 0, 11));
            this.jTextFieldMeasureIf.setText("true");
            this.jTextFieldMeasureIf.setBorder(BorderFactory.createBevelBorder(1));
            this.jTextFieldMeasureIf.setToolTipText("e.g. \"(ticks mod 100) = 0\", or \"member? ticks [50 100 200]\"");
            this.jLabel9 = new JLabel();
            this.getContentPane().add((Component)this.jLabel9, new GridBagConstraints(3, 16, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel9.setText("Evaluation limit:  ");
            this.jLabel9.setFont(new Font("SansSerif", 1, 11));
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(0);
            this.jPanel1.setLayout(jPanel1Layout);
            this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(4, 16, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.jTextFieldEvaluationLimit = new JTextField();
            this.jPanel1.add(this.jTextFieldEvaluationLimit);
            this.jTextFieldEvaluationLimit.setFont(new Font("Monospaced", 0, 11));
            this.jTextFieldEvaluationLimit.setText("300");
            this.jTextFieldEvaluationLimit.setPreferredSize(new Dimension(50, 20));
            this.jTextFieldEvaluationLimit.setToolTipText("Stop the search after this many model runs have occurred.");
            this.jLabel18 = new JLabel();
            this.jPanel1.add(this.jLabel18);
            this.jLabel18.setText("model runs");
            this.jLabel1 = new JLabel();
            this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Parameter Specification");
            this.jLabel1.setBounds(197, 32, 138, 19);
            this.jLabel1.setFont(new Font("SansSerif", 1, 14));
            this.jLabel1.setForeground(new Color(0, 0, 0));
            this.jLabel1.setHorizontalAlignment(0);
            this.jButtonHelpSearchSpace = new JButton();
            this.getContentPane().add((Component)this.jButtonHelpSearchSpace, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jButtonHelpSearchSpace.setText("?");
            this.jButtonHelpSearchSpace.setToolTipText("Help about Search Space Specification");
            this.jButtonHelpSearchSpace.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionHelpSearchSpace();
                }
            });
            this.jButtonHelpSearchMethod = new JButton();
            this.getContentPane().add((Component)this.jButtonHelpSearchMethod, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jButtonHelpSearchMethod.setText("?");
            this.jButtonHelpSearchMethod.setToolTipText("Help about this Search Method");
            this.jButtonHelpSearchMethod.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionHelpSearchMethod();
                }
            });
            DefaultComboBoxModel<String> jComboBoxSearchMethodModel = new DefaultComboBoxModel<String>(new String[]{"xxxx", "yyyy"});
            this.jComboBoxSearchMethodType = new JComboBox();
            this.getContentPane().add(this.jComboBoxSearchMethodType, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jComboBoxSearchMethodType.setModel(jComboBoxSearchMethodModel);
            this.jComboBoxSearchMethodType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    BehaviorSearchGUI.this.actionUpdateSearchMethodParams();
                }
            });
            this.jButtonHelpEvaluation = new JButton();
            this.getContentPane().add((Component)this.jButtonHelpEvaluation, new GridBagConstraints(4, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jButtonHelpEvaluation.setText("?");
            this.jButtonHelpEvaluation.setToolTipText("Help about Evaluation");
            this.jButtonHelpEvaluation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionHelpEvaluation();
                }
            });
            this.jButtonSuggestParamRanges = new JButton();
            this.getContentPane().add((Component)this.jButtonSuggestParamRanges, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jButtonSuggestParamRanges.setText("Load param ranges from model interface");
            this.jButtonSuggestParamRanges.setToolTipText("Sets the search space specification based on sliders, choosers, etc., from model interface tab.");
            this.jButtonSuggestParamRanges.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionSuggestParamRanges();
                }
            });
            this.jCheckBoxCaching = new JCheckBox();
            this.getContentPane().add((Component)this.jCheckBoxCaching, new GridBagConstraints(1, 16, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jCheckBoxCaching.setText("Use fitness caching");
            this.jCheckBoxCaching.setToolTipText("If fitness caching is turned on then the result of running the model with certain parameters gets saved so the model won't be re-run if a run with those same parameters are requested again.");
            this.jCheckBoxCaching.setSelected(true);
            this.jLabel19 = new JLabel();
            this.getContentPane().add((Component)this.jLabel19, new GridBagConstraints(3, 17, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel19.setText("BestChecking replicates:  ");
            this.jLabel19.setFont(new Font("SansSerif", 1, 11));
            this.jTextFieldBestChecking = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldBestChecking, new GridBagConstraints(4, 17, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jTextFieldBestChecking.setFont(new Font("Monospaced", 0, 11));
            this.jTextFieldBestChecking.setText("10");
            this.jTextFieldBestChecking.setPreferredSize(new Dimension(50, 20));
            this.jTextFieldBestChecking.setOpaque(true);
            this.jTextFieldBestChecking.setMinimumSize(new Dimension(50, 27));
            this.jTextFieldBestChecking.setToolTipText("BestChecking: running another N independent model runs to get an unbiased estimate of the objective function for each \"best\" individual that's found.");
            this.jButtonHelpSearchSpaceRepresentation = new JButton();
            this.getContentPane().add((Component)this.jButtonHelpSearchSpaceRepresentation, new GridBagConstraints(1, 18, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jButtonHelpSearchSpaceRepresentation.setText("?");
            this.jButtonHelpSearchSpaceRepresentation.setToolTipText("Help about this Search Space Representation");
            this.jButtonHelpSearchSpaceRepresentation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BehaviorSearchGUI.this.actionHelpSearchSpaceRepresentation();
                }
            });
            this.jPanelDeriv = new JPanel();
            this.jPanelDeriv.setBackground(new Color(214, 217, 223));
            this.jPanelDeriv.setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.jPanelDeriv, new GridBagConstraints(3, 15, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jCheckBoxTakeDerivative = new JCheckBox();
            JPanel temp = new JPanel();
            temp.setLayout(new FlowLayout(1, 40, 10));
            temp.add(this.jCheckBoxTakeDerivative);
            this.jPanelDeriv.add((Component)temp, "North");
            this.jCheckBoxTakeDerivative.setText("Take derivative?");
            this.jCheckBoxTakeDerivative.setToolTipText("Instead of using the measure you've specified, use the *change* in that measure (with respect to a certain parameter) for your objective function.");
            this.jCheckBoxTakeDerivative.setPreferredSize(new Dimension(134, 22));
            this.jCheckBoxTakeDerivative.setFont(new Font("SansSerif", 1, 11));
            this.jCheckBoxTakeDerivative.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    BehaviorSearchGUI.this.updateFitnessDerivativePanel();
                }
            });
            this.jCheckBoxFitnessDerivativeUseAbs = new JCheckBox();
            this.jCheckBoxFitnessDerivativeUseAbs.setText("Use ABS value?");
            this.jCheckBoxFitnessDerivativeUseAbs.setToolTipText("You might want to take the absolute value if you don't care about the direction of the measured change... e.g., for trying to find phase transitions");
            this.jCheckBoxTakeDerivative.setFont(new Font("SansSerif", 1, 11));
            temp.add(this.jCheckBoxFitnessDerivativeUseAbs);
            this.jPanelDeriv2 = new JPanel();
            this.jPanelDeriv2.setOpaque(false);
            this.jPanelDeriv.add((Component)this.jPanelDeriv2, "Center");
            this.jLabelDerivWRT = new JLabel();
            this.jPanelDeriv2.add(this.jLabelDerivWRT);
            this.jLabelDerivWRT.setText("w.r.t.");
            DefaultComboBoxModel<String> jComboBoxFitnessDerivativeParameterModel = new DefaultComboBoxModel<String>(new String[]{"----"});
            this.jComboBoxFitnessDerivativeParameter = new JComboBox();
            this.jComboBoxFitnessDerivativeParameter.setToolTipText("Which parameter should be varied by a small amount to see how much change results?");
            Dimension d = this.jComboBoxFitnessDerivativeParameter.getPreferredSize();
            this.jComboBoxFitnessDerivativeParameter.setPreferredSize(new Dimension(200, d.height));
            this.jPanelDeriv2.add(this.jComboBoxFitnessDerivativeParameter);
            this.jComboBoxFitnessDerivativeParameter.setModel(jComboBoxFitnessDerivativeParameterModel);
            this.jComboBoxFitnessDerivativeParameter.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    BehaviorSearchGUI.this.updateFitnessDerivativeParameterChoices();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                }
            });
            this.jLabelDerivDELTA = new JLabel();
            this.jPanelDeriv2.add(this.jLabelDerivDELTA);
            this.jLabelDerivDELTA.setText("\u0394=");
            this.jTextFieldFitnessDerivativeDelta = new JTextField();
            this.jPanelDeriv2.add(this.jTextFieldFitnessDerivativeDelta);
            this.jTextFieldFitnessDerivativeDelta.setText("0.100");
            this.jTextFieldFitnessDerivativeDelta.setToolTipText("How much should be subtracted from the parameter's value, to get the measured change?");
            int prefHeight = this.jTextFieldFitnessDerivativeDelta.getPreferredSize().height;
            this.jTextFieldFitnessDerivativeDelta.setPreferredSize(new Dimension(50, prefHeight));
            this.pack();
            this.setSize(760, 630);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void handleError(String msg, Container parentContainer) {
        JOptionPane wrappingTextOptionPane = new JOptionPane(msg, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public int getMaxCharactersPerLineCount() {
                return 58;
            }
        };
        JDialog dialog = wrappingTextOptionPane.createDialog(parentContainer, "Error!");
        dialog.setVisible(true);
    }

    private void handleError(String msg) {
        BehaviorSearchGUI.handleError(msg, this);
    }

    private void finishInitWork() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(GeneralUtils.getResource("icon_behaviorsearch.png").getAbsolutePath()));
        this.jMenuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.jMenuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        try {
            this.defaultProtocolXMLForNewSearch = GeneralUtils.stringContentsOfFile(GeneralUtils.getResource("defaultNewSearch.xml"));
        }
        catch (FileNotFoundException ex) {
            this.handleError(ex.getMessage());
            System.exit(1);
        }
        this.initComboBoxes();
        this.actionNew();
    }

    private void initComboBoxes() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.jComboBoxSearchMethodType.getModel();
        model.removeAllElements();
        List<String> names = null;
        try {
            names = SearchMethodLoader.getAllSearchMethodNames();
        }
        catch (BehaviorSearchException ex) {
            this.handleError(ex.getMessage());
            System.exit(1);
        }
        for (String name : names) {
            try {
                this.searchMethodChoices.put(name, SearchMethodLoader.createFromName(name));
                model.addElement(name);
            }
            catch (BehaviorSearchException ex) {
                this.handleError(ex.getMessage());
            }
        }
        model = (DefaultComboBoxModel)this.jComboBoxChromosomeType.getModel();
        model.removeAllElements();
        names = null;
        try {
            names = ChromosomeTypeLoader.getAllChromosomeTypes();
        }
        catch (BehaviorSearchException ex) {
            this.handleError(ex.getMessage());
            System.exit(1);
        }
        for (String name : names) {
            model.addElement(name);
        }
        model = (DefaultComboBoxModel)this.jComboBoxFitnessCollecting.getModel();
        model.removeAllElements();
        for (SearchProtocol.FITNESS_COLLECTING fITNESS_COLLECTING : SearchProtocol.FITNESS_COLLECTING.values()) {
            model.addElement(fITNESS_COLLECTING.toString());
        }
        model = (DefaultComboBoxModel)this.jComboBoxFitnessCombineReplications.getModel();
        model.removeAllElements();
        for (Enum enum_ : SearchProtocol.FITNESS_COMBINE_REPLICATIONS.values()) {
            model.addElement(enum_.toString());
        }
    }

    private void updateFitnessDerivativePanel() {
        boolean enabled = this.jCheckBoxTakeDerivative.isSelected();
        this.jLabelDerivWRT.setEnabled(enabled);
        this.jLabelDerivDELTA.setEnabled(enabled);
        this.jComboBoxFitnessDerivativeParameter.setEnabled(enabled);
        this.jTextFieldFitnessDerivativeDelta.setEnabled(enabled);
        this.jCheckBoxFitnessDerivativeUseAbs.setEnabled(enabled);
        if (enabled) {
            this.updateFitnessDerivativeParameterChoices();
        }
    }

    private void updateFitnessDerivativeParameterChoices() {
        try {
            Object oldChoice = this.jComboBoxFitnessDerivativeParameter.getSelectedItem();
            String name = this.currentFile.toString();
            SearchSpace ss = new SearchSpace(Arrays.asList(this.jTextAreaParamSpecs.getText().split("\n")), name.endsWith(".nlogo3d") || name.endsWith(".nlogox3d"));
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.jComboBoxFitnessDerivativeParameter.getModel();
            model.removeAllElements();
            for (ParameterSpec spec : ss.getParamSpecs()) {
                model.addElement(spec.getParameterName());
            }
            model.addElement("@MUTATE@");
            this.jComboBoxFitnessDerivativeParameter.setSelectedItem(oldChoice);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void actionNew() {
        if (!this.checkDiscardOkay()) {
            return;
        }
        this.currentFile = null;
        try {
            SearchProtocol protocol = SearchProtocol.load(this.defaultProtocolXMLForNewSearch);
            this.loadProtocol(protocol);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error loading default XML protocol to initialize UI!");
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error loading default XML protocol to initialize UI!");
        }
        this.setTitle("Untitled" + BehaviorSearchGUI.getWindowTitleSuffix());
    }

    private void actionOpen() {
        if (!this.checkDiscardOkay()) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        if (this.currentFile != null) {
            chooser.setSelectedFile(this.currentFile);
        }
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Completed search configurations (*.xml)", "xml"));
        chooser.setFileFilter(new FileNameExtensionFilter("Search protocols (*.bsearch)", "bsearch"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.openFile(chooser.getSelectedFile());
        }
    }

    private void actionOpenExample() {
        if (!this.checkDiscardOkay()) {
            return;
        }
        JFileChooser chooser = new JFileChooser(GeneralUtils.attemptResolvePathFromBSearchRoot("examples"));
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Completed search configurations (*.xml)", "xml"));
        chooser.setFileFilter(new FileNameExtensionFilter("Search protocols (*.bsearch)", "bsearch"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.openFile(chooser.getSelectedFile());
        }
    }

    public void handleOpenPath(String path) {
        File f = new File(path);
        if (f.exists()) {
            this.openFile(f);
        }
    }

    public void handleShowAbout() {
        this.actionHelpAbout();
    }

    public void handleQuit() throws UserCancelException {
        if (!this.checkDiscardOkay()) {
            throw new UserCancelException();
        }
        System.exit(0);
    }

    private void openFile(File fProtocol) {
        try {
            SearchProtocol protocol = SearchProtocol.loadFile(fProtocol.getPath());
            this.currentFile = fProtocol;
            this.loadProtocol(protocol);
            this.setTitle(this.currentFile.getName() + BehaviorSearchGUI.getWindowTitleSuffix());
        }
        catch (IOException e) {
            this.handleError("IO Error occurred attempting to load file: " + fProtocol.getPath());
            e.printStackTrace();
        }
        catch (SAXException e) {
            this.handleError("XML Parsing error occurred attempting to load file: " + fProtocol.getPath());
            e.printStackTrace();
        }
    }

    private void loadProtocol(SearchProtocol protocol) {
        this.jTextFieldModelFile.setText(protocol.modelFile);
        StringBuilder sb = new StringBuilder();
        for (String s : protocol.paramSpecStrings) {
            sb.append(s);
            sb.append("\n");
        }
        this.jTextAreaParamSpecs.setText(sb.toString());
        this.jTextFieldModelStepCommands.setText(protocol.modelStepCommands);
        this.jTextFieldModelSetupCommands.setText(protocol.modelSetupCommands);
        this.jTextFieldModelStopCondition.setText(protocol.modelStopCondition);
        this.jTextFieldModelStepLimit.setText(Integer.toString(protocol.modelStepLimit));
        this.jTextFieldFitnessMetric.setText(protocol.modelMetricReporter);
        this.jTextFieldMeasureIf.setText(protocol.modelMeasureIf);
        this.jComboBoxFitnessMinMax.setSelectedItem(protocol.fitnessMinimized ? "Minimize Fitness" : "Maximize Fitness");
        this.jComboBoxFitnessCollecting.setSelectedItem(protocol.fitnessCollecting.toString());
        this.jTextFieldFitnessSamplingRepetitions.setText(Integer.toString(protocol.fitnessSamplingReplications));
        this.jComboBoxFitnessSamplingMethod.setSelectedItem(protocol.fitnessSamplingReplications != 0 ? "Fixed Sampling" : "Adaptive Sampling");
        this.jComboBoxFitnessCombineReplications.setSelectedItem(protocol.fitnessCombineReplications.toString());
        this.jCheckBoxTakeDerivative.setSelected(protocol.fitnessDerivativeParameter.length() > 0);
        this.jCheckBoxFitnessDerivativeUseAbs.setSelected(protocol.fitnessDerivativeUseAbs);
        this.updateFitnessDerivativePanel();
        this.jComboBoxFitnessDerivativeParameter.setSelectedItem(protocol.fitnessDerivativeParameter);
        this.jTextFieldFitnessDerivativeDelta.setText(Double.toString(protocol.fitnessDerivativeDelta));
        this.jComboBoxSearchMethodType.setSelectedItem(protocol.searchMethodType);
        this.jComboBoxChromosomeType.setSelectedItem(protocol.chromosomeType);
        this.updateSearchMethodParamTable(this.searchMethodChoices.get(protocol.searchMethodType), protocol.searchMethodParams);
        this.jCheckBoxCaching.setSelected(protocol.caching);
        this.jTextFieldBestChecking.setText(Integer.toString(protocol.bestCheckingNumReplications));
        this.jTextFieldEvaluationLimit.setText(Integer.toString(protocol.evaluationLimit));
        this.lastSavedText = protocol.toXMLString();
        this.runOptions = null;
    }

    private void actionSave() {
        if (this.currentFile == null) {
            this.actionSaveAs();
        } else {
            this.doSave();
        }
    }

    private void actionSaveAs() {
        JFileChooser chooser = new JFileChooser("./experiments/");
        if (this.currentFile != null) {
            chooser.setSelectedFile(this.currentFile);
        } else {
            chooser.setSelectedFile(new File("Untitled.bsearch"));
        }
        chooser.setFileFilter(new FileNameExtensionFilter("Search protocols (*.bsearch)", "bsearch"));
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.currentFile = chooser.getSelectedFile();
            this.doSave();
            this.setTitle(this.currentFile.getName() + BehaviorSearchGUI.getWindowTitleSuffix());
        }
    }

    private SearchProtocol createProtocolFromFormData() throws UIConstraintException {
        LinkedHashMap<String, String> searchMethodParams = new LinkedHashMap<String, String>();
        TableModel model = this.jTableSearchMethodParams.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            searchMethodParams.put(model.getValueAt(i, 0).toString().trim(), model.getValueAt(i, 1).toString());
        }
        int modelStepLimit = 0;
        try {
            modelStepLimit = Integer.valueOf(this.jTextFieldModelStepLimit.getText());
            if (modelStepLimit < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            throw new UIConstraintException("STEP LIMIT should be a non-negative integer.", "Error: can't create search protocol");
        }
        int fitnessSamplingRepetitions = 0;
        if (this.jComboBoxFitnessSamplingMethod.getSelectedItem().toString().equals("Fixed Sampling")) {
            try {
                fitnessSamplingRepetitions = Integer.valueOf(this.jTextFieldFitnessSamplingRepetitions.getText());
                if (fitnessSamplingRepetitions < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException ex) {
                throw new UIConstraintException("SAMPLING REPETITIONS should be a positive integer, or 0 if using adaptive sampling.", "Error: can't create protocol");
            }
        }
        boolean caching = this.jCheckBoxCaching.isSelected();
        int evaluationLimit = 0;
        try {
            evaluationLimit = Integer.valueOf(this.jTextFieldEvaluationLimit.getText());
            if (evaluationLimit <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            throw new UIConstraintException("EVALUATION LIMIT should be a positive integer.", "Error: can't create search protocol");
        }
        int bestCheckingNumReplications = 0;
        try {
            bestCheckingNumReplications = Integer.valueOf(this.jTextFieldBestChecking.getText());
            if (bestCheckingNumReplications < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            throw new UIConstraintException("The number of 'BEST CHECKING' replicates should be a non-negative integer.", "Error: can't create search protocol");
        }
        double fitnessDerivDelta = 0.0;
        if (this.jCheckBoxTakeDerivative.isSelected()) {
            try {
                fitnessDerivDelta = Double.valueOf(this.jTextFieldFitnessDerivativeDelta.getText());
            }
            catch (NumberFormatException ex) {
                throw new UIConstraintException("The DELTA value (for taking the derivative of the objective fucntion with respect to a parameter) needs to be a number", "Error: can't create search protocol");
            }
        }
        SearchProtocol protocol = new SearchProtocol(this.jTextFieldModelFile.getText(), Arrays.asList(this.jTextAreaParamSpecs.getText().split("\n")), this.jTextFieldModelStepCommands.getText(), this.jTextFieldModelSetupCommands.getText(), this.jTextFieldModelStopCondition.getText(), modelStepLimit, this.jTextFieldFitnessMetric.getText(), this.jTextFieldMeasureIf.getText(), this.jComboBoxFitnessMinMax.getSelectedItem().toString().equals("Minimize Fitness"), fitnessSamplingRepetitions, SearchProtocol.FITNESS_COLLECTING.valueOf(this.jComboBoxFitnessCollecting.getSelectedItem().toString()), SearchProtocol.FITNESS_COMBINE_REPLICATIONS.valueOf(this.jComboBoxFitnessCombineReplications.getSelectedItem().toString()), this.jCheckBoxTakeDerivative.isSelected() ? this.jComboBoxFitnessDerivativeParameter.getSelectedItem().toString() : "", fitnessDerivDelta, this.jCheckBoxFitnessDerivativeUseAbs.isSelected(), this.jComboBoxSearchMethodType.getSelectedItem().toString(), searchMethodParams, this.jComboBoxChromosomeType.getSelectedItem().toString(), caching, evaluationLimit, bestCheckingNumReplications);
        return protocol;
    }

    private void doSave() {
        try {
            FileWriter fout = new FileWriter(this.currentFile);
            SearchProtocol protocol = this.createProtocolFromFormData();
            protocol.save(fout);
            fout.close();
            this.lastSavedText = protocol.toXMLString();
            JOptionPane.showMessageDialog(this, "Saved successfully.", "Saved.", -1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.handleError("IO Error occurred attempting to save file: " + this.currentFile.getPath());
        }
        catch (UIConstraintException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), ex.getTitle(), 2);
        }
    }

    private void actionExit() {
        if (!this.checkDiscardOkay()) {
            return;
        }
        System.exit(0);
    }

    private boolean protocolChangedSinceLastSave() {
        String xmlStr = "";
        try {
            xmlStr = this.createProtocolFromFormData().toXMLString();
        }
        catch (UIConstraintException ex) {
            return true;
        }
        return this.lastSavedText != null && !this.lastSavedText.equals(xmlStr);
    }

    private boolean checkDiscardOkay() {
        return !this.protocolChangedSinceLastSave() || JOptionPane.showConfirmDialog(this, "Discard changes you've made to this search experiment?", "Discard changes?", 0, 3) != 1;
    }

    private void updateSearchMethodParamTable(SearchMethod searchMethod, HashMap<String, String> searchMethodParams) {
        HashMap<String, String> defaultParams = searchMethod.getSearchParams();
        for (String key : defaultParams.keySet()) {
            if (searchMethodParams.containsKey(key)) continue;
            searchMethodParams.put(key, defaultParams.get(key));
        }
        DefaultTableModel model = (DefaultTableModel)this.jTableSearchMethodParams.getModel();
        model.setRowCount(0);
        for (String s : searchMethodParams.keySet()) {
            model.addRow(new Object[]{s, searchMethodParams.get(s)});
        }
    }

    protected void actionUpdateSearchMethodParams() {
        if (!this.searchMethodChoices.isEmpty()) {
            SearchMethod searchMethod = this.searchMethodChoices.get(this.jComboBoxSearchMethodType.getSelectedItem());
            this.updateSearchMethodParamTable(searchMethod, searchMethod.getSearchParams());
        }
    }

    protected void actionSamplingMethodChanged() {
        if (this.jComboBoxFitnessSamplingMethod.getSelectedItem().equals("Adaptive Sampling")) {
            SearchMethod searchMethod = this.searchMethodChoices.get(this.jComboBoxSearchMethodType.getSelectedItem());
            if (!searchMethod.supportsAdaptiveSampling()) {
                JOptionPane.showMessageDialog(this, "The currently selected search method doesn't support 'Adaptive Sampling'.", "WARNING", 2);
                this.jComboBoxFitnessSamplingMethod.setSelectedItem("Fixed Sampling");
            } else {
                this.jTextFieldFitnessSamplingRepetitions.setText("0");
                this.jTextFieldFitnessSamplingRepetitions.setEnabled(false);
            }
        } else {
            this.jTextFieldFitnessSamplingRepetitions.setEnabled(true);
            if (this.jTextFieldFitnessSamplingRepetitions.getText().trim().equals("0")) {
                this.jTextFieldFitnessSamplingRepetitions.setText("10");
            }
        }
    }

    protected void actionBrowseModel() {
        JFileChooser chooser = new JFileChooser(System.getProperty("bsearch.startupfolder", "."));
        chooser.setSelectedFile(new File(this.jTextFieldModelFile.getText()));
        chooser.setFileFilter(new FileNameExtensionFilter("NetLogo Models", "nlogo"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.jTextFieldModelFile.setText(chooser.getSelectedFile().getPath());
        }
    }

    protected void actionSuggestParamRanges() {
        try {
            this.jTextAreaParamSpecs.setText(Utils.getDefaultConstraintsText(this.jTextFieldModelFile.getText()));
        }
        catch (NetLogoLinkException e) {
            this.handleError(e.getMessage());
        }
    }

    protected void actionRunNow() {
        SearchProtocol protocol;
        try {
            protocol = this.createProtocolFromFormData();
        }
        catch (UIConstraintException e) {
            this.handleError("Error creating SearchProtocol: " + e.getMessage());
            return;
        }
        if (this.runOptions == null) {
            this.runOptions = new BehaviorSearch.RunOptions();
            if (this.currentFile != null) {
                String fnameStem = this.currentFile.getPath();
                fnameStem = fnameStem.substring(0, fnameStem.lastIndexOf(46));
                this.runOptions.outputStem = fnameStem = GeneralUtils.attemptResolvePathFromStartupFolder(fnameStem);
            } else {
                this.runOptions.outputStem = new File(this.defaultUserDocumentsFolder, "mySearchOutput").getPath();
            }
        }
        if (this.currentFile != null) {
            this.runOptions.protocolFilename = this.currentFile.getAbsolutePath();
        }
        if (RunOptionsDialog.showDialog(this, this.runOptions)) {
            GUIProgressDialog dialog = new GUIProgressDialog(this);
            dialog.setLocationRelativeTo(null);
            dialog.startSearchTask(protocol, this.runOptions);
            dialog.setVisible(true);
        }
    }

    private void actionHelpSearchMethod() {
        SearchMethod sm = this.searchMethodChoices.get(this.jComboBoxSearchMethodType.getSelectedItem());
        HelpInfoDialog.showHelp(this, "Help about " + sm.getName(), sm.getHTMLHelpText());
    }

    private void actionHelpSearchSpaceRepresentation() {
        String chromosomeType = this.jComboBoxChromosomeType.getSelectedItem().toString();
        try {
            ChromosomeFactory factory = ChromosomeTypeLoader.createFromName(chromosomeType);
            HelpInfoDialog.showHelp(this, "Help about " + chromosomeType, factory.getHTMLHelpText() + "<BR><BR>");
        }
        catch (BehaviorSearchException ex) {
            this.handleError(ex.toString());
        }
    }

    private void actionHelpSearchSpace() {
        HelpInfoDialog.showHelp(this, "Help about search space specification", "<HTML><BODY>Specifying the range of parameters to be searched works much the same as the BehaviorSpace tool in NetLogo:<PRE> [ \"PARAM_NAME\" VALUE1 VALUE2 VALUE3 ... ] </PRE>or <PRE> [ \"PARAM_NAME\" [RANGE_START INCREMENT RANGE_END] ] </PRE><P>One slight difference is that INCREMENT may be \"C\", which means to search the range continously (or at least with fine resolution, if the chromosomal representation doesn't allow for continuous parameters)</P></BODY></HTML>");
    }

    private void actionHelpEvaluation() {
        HelpInfoDialog.showHelp(this, "Help about fitness evaluation", "<HTML><BODY>An objective function must condense the data collected from multiple model runs into a single number, which is what the search process will either attempt to minimize or maximize.</BODY></HTML>");
    }

    private void actionHelpTutorial() {
        BrowserLauncher.openPath((Component)this, (Path)Path.of(GeneralUtils.attemptResolvePathFromBSearchRoot("documentation/tutorial.html"), new String[0]), (String)"");
    }

    private void actionHelpAbout() {
        HelpAboutDialog.showAboutDialog(this);
    }

    public class UIConstraintException
    extends Exception {
        private String title;
        private static final long serialVersionUID = 1L;

        public UIConstraintException(String msg, String title) {
            super(msg);
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

