/*
 * Decompiled with CFR 0.152.
 */
package bsearch.nlogolink;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class ModelRunResult {
    private LinkedHashMap<String, LinkedList<Double>> measures = new LinkedHashMap();
    private long randomSeed;

    public ModelRunResult(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public void addResult(String measure, Double val) {
        if (!this.measures.containsKey(measure)) {
            this.measures.put(measure, new LinkedList());
        }
        this.measures.get(measure).add(val);
    }

    public boolean isEmpty() {
        return this.measures.isEmpty();
    }

    public ArrayList<String> getMeasureNames() {
        return new ArrayList<String>(this.measures.keySet());
    }

    public LinkedList<Double> getTimeSeriesForMeasure(String measure) {
        return this.measures.get(measure);
    }

    public LinkedList<Double> getPrimaryTimeSeries() {
        return this.measures.get(this.getMeasureNames().get(0));
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }
}

