/*
 * Decompiled with CFR 0.152.
 */
package bsearch.nlogolink;

import bsearch.nlogolink.ModelRunResult;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.nlogolink.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.nlogo.api.AgentException;
import org.nlogo.api.Dump;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.CompilerException;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.nvm.Procedure;

public class ModelRunner {
    private HeadlessWorkspace workspace;
    private Procedure setupCommands;
    private Procedure stepCommands;
    private Procedure stopConditionReporter;
    private Procedure measureIfReporter = null;
    private final boolean recordEveryTick;
    private final int maxModelSteps;
    private LinkedHashMap<String, Procedure> resultReporters = new LinkedHashMap();
    private boolean runIsDone;
    private SimpleJobOwner mainJobOwner = null;
    private SimpleJobOwner extraJobOwner = null;

    private ModelRunner(String modelFileName, boolean recordEveryTick, int maxModelSteps) throws LogoException, IOException, CompilerException {
        this.workspace = Utils.createWorkspace(modelFileName.endsWith(".nlogo3d") || modelFileName.endsWith(".nlogox3d"));
        this.workspace.open(modelFileName, false);
        this.recordEveryTick = recordEveryTick;
        this.maxModelSteps = maxModelSteps;
    }

    public void setSetupCommands(String commands) throws CompilerException {
        this.setupCommands = this.workspace.compileCommands(commands);
    }

    public void setStepCommands(String commands) throws CompilerException {
        this.stepCommands = this.workspace.compileCommands(commands);
    }

    public void setStopConditionReporter(String reporter) throws CompilerException {
        if (reporter.trim().length() > 0) {
            this.stopConditionReporter = this.workspace.compileReporter(reporter);
        }
    }

    public void addResultReporter(String reporter) throws CompilerException {
        this.resultReporters.put(reporter, this.workspace.compileReporter(reporter));
    }

    public void setMeasureIfReporter(String reporter) throws CompilerException {
        if (reporter.trim().length() > 0) {
            this.measureIfReporter = this.workspace.compileReporter(reporter);
        }
    }

    public boolean checkStopCondition() throws NetLogoLinkException {
        if (this.extraJobOwner == null) {
            throw new IllegalStateException("ModelRunner.setup() must be called before running commands/reporters.");
        }
        if (this.stopConditionReporter != null) {
            Object obj = this.workspace.runCompiledReporter((JobOwner)this.extraJobOwner, this.stopConditionReporter);
            LogoException ex = this.workspace.lastLogoException();
            if (ex != null) {
                this.workspace.lastLogoException_$eq(null);
                throw new NetLogoLinkException(ex.toString());
            }
            if (!(obj instanceof Boolean)) {
                throw new NetLogoLinkException("The stop condition reporter must report a TRUE/FALSE value.  Error occurred because it reported: " + obj);
            }
            return (Boolean)obj;
        }
        return false;
    }

    public void setup(int seed, LinkedHashMap<String, Object> parameterSettings) throws LogoException, AgentException, NetLogoLinkException {
        this.workspace.clearAll();
        for (String s : parameterSettings.keySet()) {
            this.workspace.world().setObserverVariableByName(s, parameterSettings.get(s));
        }
        try {
            this.workspace.world().mainRNG().setSeed((long)seed);
            this.mainJobOwner = new SimpleJobOwner("BehaviorSearch ModelRunner Main", this.workspace.mainRNG(), (AgentKind)AgentKindJ.Observer());
            MersenneTwisterFast extraReporterRNG = new MersenneTwisterFast((long)this.workspace.mainRNG().clone().nextInt());
            this.extraJobOwner = new SimpleJobOwner("BehaviorSearch ModelRunner Extra", extraReporterRNG, (AgentKind)AgentKindJ.Observer());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.setupCommands != null) {
            this.workspace.runCompiledCommands((JobOwner)this.mainJobOwner, this.setupCommands);
            LogoException ex = this.workspace.lastLogoException();
            if (ex != null) {
                this.workspace.lastLogoException_$eq(null);
                throw new NetLogoLinkException(ex.toString());
            }
        }
        this.runIsDone = this.checkStopCondition();
    }

    public boolean go() throws NetLogoLinkException {
        if (this.mainJobOwner == null) {
            throw new IllegalStateException("ModelRunner.setup() must be called before running commands/reporters.");
        }
        if (this.stepCommands != null) {
            this.workspace.runCompiledCommands((JobOwner)this.mainJobOwner, this.stepCommands);
            LogoException ex = this.workspace.lastLogoException();
            if (ex != null) {
                this.workspace.lastLogoException_$eq(null);
                throw new NetLogoLinkException(ex.toString());
            }
        }
        this.runIsDone = this.checkStopCondition();
        return this.runIsDone;
    }

    public LinkedHashMap<String, Object> measureResults() throws NetLogoLinkException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String key : this.resultReporters.keySet()) {
            results.put(key, this.measureResultReporter(this.resultReporters.get(key)));
        }
        return results;
    }

    private Double measureResultReporter(Procedure reporter) throws NetLogoLinkException {
        if (this.extraJobOwner == null) {
            throw new IllegalStateException("ModelRunner.setup() must be called before running commands/reporters.");
        }
        Object obj = this.workspace.runCompiledReporter((JobOwner)this.extraJobOwner, reporter);
        LogoException ex = this.workspace.lastLogoException();
        if (ex != null) {
            this.workspace.lastLogoException_$eq(null);
            throw new NetLogoLinkException(ex.toString());
        }
        if (!(obj instanceof Double)) {
            throw new NetLogoLinkException("Result reporters must return numeric results!  Invalid reported value was: " + obj);
        }
        return (Double)obj;
    }

    private boolean evaluateMeasureIfReporter() throws NetLogoLinkException {
        if (this.measureIfReporter == null) {
            return true;
        }
        Boolean obj = this.workspace.runCompiledReporter((JobOwner)this.extraJobOwner, this.measureIfReporter).equals(Boolean.TRUE);
        LogoException ex = this.workspace.lastLogoException();
        if (ex != null) {
            this.workspace.lastLogoException_$eq(null);
            throw new NetLogoLinkException(ex.toString());
        }
        if (!(obj instanceof Boolean)) {
            throw new NetLogoLinkException("The 'measure if' condition must report a TRUE/FALSE value.  Error occurred because it reported: " + obj);
        }
        return obj;
    }

    private void conditionallyRecordResults(ModelRunResult results) throws NetLogoLinkException {
        if (this.extraJobOwner == null) {
            throw new IllegalStateException("ModelRunner.setup() must be called before running commands/reporters.");
        }
        if (this.evaluateMeasureIfReporter()) {
            for (String key : this.resultReporters.keySet()) {
                results.addResult(key, this.measureResultReporter(this.resultReporters.get(key)));
            }
        }
    }

    public ModelRunResult doFullRun(RunSetup runSetup) throws ModelRunnerException {
        try {
            int steps;
            ModelRunResult results = new ModelRunResult(runSetup.seed);
            this.setup(runSetup.seed, runSetup.parameterSettings);
            for (steps = 0; steps < this.maxModelSteps && !this.runIsDone; ++steps) {
                if (this.recordEveryTick) {
                    this.conditionallyRecordResults(results);
                }
                this.go();
            }
            this.conditionallyRecordResults(results);
            if (results.isEmpty()) {
                throw new NetLogoLinkException("No values were measured/collected during this model run! (Model was run for " + steps + " steps.)");
            }
            return results;
        }
        catch (Exception ex) {
            throw new ModelRunnerException(runSetup, ex);
        }
    }

    public boolean isRunDone() {
        return this.runIsDone;
    }

    public void dispose() throws InterruptedException {
        this.workspace.dispose();
    }

    public static ModelRunner createModelRunnerForTesting(String s, boolean recordEveryTick, int maxModelSteps) throws LogoException, IOException, CompilerException {
        return new ModelRunner(s, recordEveryTick, maxModelSteps);
    }

    public Object report(String reporter) throws CompilerException, NetLogoLinkException {
        Procedure procReporter = this.workspace.compileReporter(reporter);
        Object obj = this.workspace.runCompiledReporter((JobOwner)this.extraJobOwner, procReporter);
        LogoException ex = this.workspace.lastLogoException();
        if (ex != null) {
            this.workspace.lastLogoException_$eq(null);
            throw new NetLogoLinkException(ex.toString());
        }
        return obj;
    }

    public void command(String cmd) throws CompilerException, LogoException {
        this.workspace.command(cmd);
    }

    public static class RunSetup {
        final int seed;
        private final LinkedHashMap<String, Object> parameterSettings;

        public RunSetup(int seed, LinkedHashMap<String, Object> parameterSettings) {
            this.seed = seed;
            this.parameterSettings = parameterSettings;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{RANDOM-SEED: " + this.seed + ",\n  SETTINGS: {");
            for (String key : this.parameterSettings.keySet()) {
                sb.append(key + "=" + Dump.logoObject((Object)this.parameterSettings.get(key), (boolean)true, (boolean)false) + ", ");
            }
            sb.append("}}");
            return sb.toString();
        }
    }

    public static class ModelRunnerException
    extends NetLogoLinkException {
        private static final long serialVersionUID = 1L;
        private final RunSetup runSetup;

        public ModelRunnerException(RunSetup runSetup, Exception ex) {
            super("", ex);
            this.runSetup = runSetup;
        }

        public RunSetup getRunSetup() {
            return this.runSetup;
        }

        @Override
        public String getMessage() {
            return this.getCause().toString() + "\n\nModel run configuration was: " + this.runSetup;
        }
    }

    public static class Factory {
        private List<ModelRunner> allModelRunners = Collections.synchronizedList(new LinkedList());
        private Queue<ModelRunner> unusedModelRunners = new ConcurrentLinkedQueue<ModelRunner>();
        private final String modelFileName;
        private final String setupCommands;
        private final String stepCommands;
        private final String stopCondition;
        private final String metricReporter;
        private final String measureIfReporter;
        private final boolean recordEveryTick;
        private final int maxModelSteps;

        public Factory(String modelFileName, boolean recordEveryTick, int maxModelSteps, String setupCommands, String stepCommands, String stopCondition, String metricReporter, String measureIfReporter) {
            this.modelFileName = modelFileName;
            this.setupCommands = setupCommands;
            this.stepCommands = stepCommands;
            this.stopCondition = stopCondition;
            this.metricReporter = metricReporter;
            this.measureIfReporter = measureIfReporter;
            this.recordEveryTick = recordEveryTick;
            this.maxModelSteps = maxModelSteps;
        }

        public ModelRunner acquireModelRunner() throws NetLogoLinkException {
            ModelRunner runner = this.unusedModelRunners.poll();
            if (runner != null) {
                return runner;
            }
            return this.newModelRunner();
        }

        public void releaseModelRunner(ModelRunner runner) {
            this.unusedModelRunners.add(runner);
        }

        private ModelRunner newModelRunner() throws NetLogoLinkException {
            ModelRunner runner;
            try {
                runner = new ModelRunner(this.modelFileName, this.recordEveryTick, this.maxModelSteps);
            }
            catch (LogoException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("Error opening NetLogo model.  NetLogo sent back this error message: \"" + e.getMessage() + "\"");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("I/O error when loading NetLogo model ( " + this.modelFileName + " ).  Error message: \"" + e.getMessage() + "\"");
            }
            catch (CompilerException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("Error compiling NetLogo model ( " + this.modelFileName + " ).  NetLogo's error message: \"" + e.getMessage() + "\"");
            }
            try {
                runner.setSetupCommands(this.setupCommands);
            }
            catch (CompilerException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("Error compiling the model's setup commands : " + this.setupCommands.toUpperCase() + " \n  NetLogo's error message: \"" + e.getMessage() + "\"");
            }
            try {
                runner.setStepCommands(this.stepCommands);
            }
            catch (CompilerException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("Error compiling the model's step commands : " + this.stepCommands.toUpperCase() + " \n  NetLogo's error message: \"" + e.getMessage() + "\"");
            }
            try {
                runner.setStopConditionReporter(this.stopCondition);
            }
            catch (CompilerException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("Error compiling the model's stop condition: " + this.stopCondition.toUpperCase() + " \n  NetLogo's error message: \"" + e.getMessage() + "\"");
            }
            try {
                runner.setMeasureIfReporter(this.measureIfReporter);
            }
            catch (CompilerException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("Error compiling the model's measure-if condition: " + this.measureIfReporter.toUpperCase() + " \n  NetLogo's error message: \"" + e.getMessage() + "\"");
            }
            try {
                runner.addResultReporter(this.metricReporter);
            }
            catch (CompilerException e) {
                e.printStackTrace();
                throw new NetLogoLinkException("Error compiling the model's fitness metric: " + this.metricReporter.toUpperCase() + " \n  NetLogo's error message: \"" + e.getMessage() + "\"");
            }
            this.allModelRunners.add(runner);
            return runner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disposeAllRunners() throws InterruptedException {
            List<ModelRunner> list = this.allModelRunners;
            synchronized (list) {
                for (ModelRunner runner : this.allModelRunners) {
                    runner.dispose();
                }
                this.allModelRunners.clear();
            }
        }
    }
}

