/*
 * Decompiled with CFR 0.152.
 */
package bsearch.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Scanner;

public class GeneralUtils {
    private static final String VERSION_STRING = "1.10";
    private static final double VERSION_NUMBER = 1.1;
    private static String startupFolderStr = System.getProperty("bsearch.startupfolder");
    private static String bsearchAppFolderStr = System.getProperty("bsearch.appfolder");
    private static File protocolFolder = null;

    public static String getVersionString() {
        return VERSION_STRING;
    }

    public static double getVersionNumber() {
        return 1.1;
    }

    public static String stringContentsOfFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        String contents = scanner.useDelimiter("\\Z").next();
        scanner.close();
        return contents.replace("\r\n", "\n");
    }

    public static String stringJoin(Collection<?> s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String formatTimeNicely(long millis) {
        int seconds = (int)Math.round((double)millis / 1000.0);
        int minutes = seconds / 60;
        int hours = minutes / 60;
        seconds %= 60;
        minutes %= 60;
        if (hours > 0) {
            return hours + ":" + String.format("%02d", minutes) + ":" + String.format("%02d", seconds);
        }
        return minutes + ":" + String.format("%02d", seconds);
    }

    private static String numberToFormattedString(Double d) {
        String s = d.toString();
        if (s.endsWith(".0")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.length() > 7) {
            return String.format("%.6g", d);
        }
        return s;
    }

    public static String getParamSettingsTextHTML(LinkedHashMap<String, Object> paramSettings) {
        int longestParamLength = 0;
        for (String param : paramSettings.keySet()) {
            longestParamLength = Math.max(longestParamLength, param.length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        for (String param : paramSettings.keySet()) {
            sb.append(String.format("%-" + longestParamLength + "s", param));
            sb.append("=");
            Object obj = paramSettings.get(param);
            if (obj instanceof Double) {
                obj = GeneralUtils.numberToFormattedString((Double)obj);
            }
            sb.append(String.format("%7s", obj));
            sb.append("<BR>");
        }
        sb.append("</pre>");
        return sb.toString();
    }

    public static boolean isOSWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    }

    public static String attemptResolvePathFromStartupFolder(String pathStr) {
        if (startupFolderStr == null) {
            return pathStr;
        }
        File path = new File(pathStr);
        if (path.isAbsolute()) {
            return pathStr;
        }
        File startupFolder = new File(startupFolderStr);
        return new File(startupFolder, pathStr).getAbsolutePath();
    }

    public static void updateProtocolFolder(String protocolFilename) {
        if (protocolFilename != null) {
            protocolFilename = GeneralUtils.attemptResolvePathFromStartupFolder(protocolFilename);
            File protocolFile = new File(protocolFilename);
            protocolFolder = protocolFile.getParentFile();
        }
    }

    public static String attemptResolvePathFromProtocolFolder(String pathStr) {
        if (protocolFolder == null) {
            return pathStr;
        }
        File path = new File(pathStr);
        if (path.isAbsolute()) {
            return pathStr;
        }
        return new File(protocolFolder, pathStr).getAbsolutePath();
    }

    public static String attemptResolvePathFromBSearchRoot(String pathStr) {
        File rootDir = bsearchAppFolderStr != null && !bsearchAppFolderStr.equals("") ? new File(bsearchAppFolderStr) : new File("behaviorsearch");
        if (rootDir.exists() && rootDir.isDirectory()) {
            return new File(rootDir, pathStr).getAbsolutePath();
        }
        return pathStr;
    }

    public static File getResource(String fileName) {
        return new File(GeneralUtils.attemptResolvePathFromBSearchRoot("resources/" + fileName));
    }
}

