/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ls.gui;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.nlogo.app.TabManager;
import org.nlogo.ls.gui.LevelSpaceMenu;
import org.nlogo.ls.gui.ModelCodeTab;
import org.nlogo.ls.gui.ModelManager;
import org.nlogo.swing.Menu;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.MenuItem$;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.function.JProcedure1;

public class GUILevelSpaceMenu
extends Menu
implements LevelSpaceMenu {
    private final TabManager tabManager;
    private final ModelManager backingModelManager;
    private final MenuItem selectModel;
    private final Menu openModels;
    private final MenuItem newModel;

    public GUILevelSpaceMenu(TabManager tabManager, ModelManager backingModelManager) {
        this.tabManager = tabManager;
        this.backingModelManager = backingModelManager;
        super("LevelSpace");
        this.selectModel = new MenuItem((Action)new LevelSpaceMenu.SelectModelAction("Open Model in Code Tab", backingModelManager), MenuItem$.MODULE$.$lessinit$greater$default$2());
        this.openModels = new Menu("Edit Open Models...");
        this.newModel = new MenuItem((Action)new LevelSpaceMenu.NewModelAction("Create new LevelSpace Model", backingModelManager), MenuItem$.MODULE$.$lessinit$greater$default$2());
        this.add((JMenuItem)this.selectModel());
        this.add((JMenuItem)this.openModels());
        this.add((JMenuItem)this.newModel());
    }

    public ModelManager backingModelManager() {
        return this.backingModelManager;
    }

    public MenuItem selectModel() {
        return this.selectModel;
    }

    public Menu openModels() {
        return this.openModels;
    }

    public MenuItem newModel() {
        return this.newModel;
    }

    public void addMenuItemsForOpenModels(Seq<String> modelPaths) {
        this.openModels().removeAll();
        modelPaths.foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.addModelAction((JMenu)this.openModels(), (String)_$1));
        if (this.openModels().getMenuComponentCount() == 0) {
            this.openModels().setEnabled(false);
            return;
        }
        this.openModels().setEnabled(true);
    }

    public void replaceTab(ModelCodeTab oldTab) {
        this.newHeadlessBackedTab(oldTab.filePath()).foreach((Function1)(JProcedure1 & Serializable)newTab -> this.replaceSwingTab(oldTab, (ModelCodeTab)((Object)newTab)));
    }

    private void addModelAction(JMenu menu, String filePath) {
        menu.add((JMenuItem)new MenuItem((Action)new LevelSpaceMenu.OpenModelAction(filePath, this.backingModelManager()), MenuItem$.MODULE$.$lessinit$greater$default$2()));
    }

    private Option<ModelCodeTab> newHeadlessBackedTab(String filePath) {
        return this.backingModelManager().registerTab(filePath, (Function1<AbstractWorkspaceScala, ModelCodeTab>)(Function1 & Serializable)workspace -> new ModelCodeTab((AbstractWorkspaceScala)workspace, this.tabManager, this.backingModelManager()));
    }

    private void replaceSwingTab(ModelCodeTab oldTab, ModelCodeTab newTab) {
        this.tabManager.replaceTab((Component)((Object)oldTab), (Component)((Object)newTab));
    }
}

