/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4;

import java.io.Serializable;
import scala.;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sttp.attributes.AttributeMap;
import sttp.capabilities.package;
import sttp.client4.Backend;
import sttp.client4.BasicBody;
import sttp.client4.BodyPart;
import sttp.client4.GenericRequest;
import sttp.client4.MultipartStreamBody$;
import sttp.client4.Request$;
import sttp.client4.RequestOptions;
import sttp.client4.Response;
import sttp.client4.ResponseAs;
import sttp.client4.ResponseAsDelegate;
import sttp.client4.StreamBody$;
import sttp.client4.StreamRequest;
import sttp.client4.StreamRequest$;
import sttp.client4.StreamResponseAs;
import sttp.client4.StreamResponseAs$;
import sttp.client4.SyncBackend;
import sttp.client4.WebSocketRequest;
import sttp.client4.WebSocketRequest$;
import sttp.client4.WebSocketResponseAs;
import sttp.client4.WebSocketStreamRequest;
import sttp.client4.WebSocketStreamRequest$;
import sttp.client4.WebSocketStreamResponseAs;
import sttp.model.Header;
import sttp.model.Method;
import sttp.model.Part;
import sttp.model.ResponseMetadata;
import sttp.model.Uri;

public class Request<T>
implements GenericRequest<T, Object>,
Product,
Serializable {
    private final String method;
    private final Uri uri;
    private final BasicBody body;
    private final Seq headers;
    private final ResponseAs response;
    private final RequestOptions options;
    private final AttributeMap attributes;

    public static <T> Request<T> apply(String string, Uri uri, BasicBody basicBody, Seq<Header> seq, ResponseAs<T> responseAs, RequestOptions requestOptions, AttributeMap attributeMap) {
        return Request$.MODULE$.apply(string, uri, basicBody, seq, responseAs, requestOptions, attributeMap);
    }

    public static Request<?> fromProduct(Product product) {
        return Request$.MODULE$.fromProduct(product);
    }

    public static <T> Request<T> unapply(Request<T> request) {
        return Request$.MODULE$.unapply(request);
    }

    public Request(String method, Uri uri, BasicBody body, Seq<Header> headers, ResponseAs<T> response, RequestOptions options, AttributeMap attributes) {
        this.method = method;
        this.uri = uri;
        this.body = body;
        this.headers = headers;
        this.response = response;
        this.options = options;
        this.attributes = attributes;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Request)) return false;
        Request request = (Request)object;
        String string = this.method();
        String string2 = request.method();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Uri uri = this.uri();
        Uri uri2 = request.uri();
        if (uri == null) {
            if (uri2 != null) {
                return false;
            }
        } else if (!uri.equals(uri2)) return false;
        BasicBody basicBody = this.body();
        BasicBody basicBody2 = request.body();
        if (basicBody == null) {
            if (basicBody2 != null) {
                return false;
            }
        } else if (!basicBody.equals(basicBody2)) return false;
        Seq<Header> seq = this.headers();
        Seq<Header> seq2 = request.headers();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        ResponseAsDelegate responseAsDelegate = this.response();
        ResponseAsDelegate responseAsDelegate2 = request.response();
        if (responseAsDelegate == null) {
            if (responseAsDelegate2 != null) {
                return false;
            }
        } else if (!responseAsDelegate.equals(responseAsDelegate2)) return false;
        RequestOptions requestOptions = this.options();
        RequestOptions requestOptions2 = request.options();
        if (requestOptions == null) {
            if (requestOptions2 != null) {
                return false;
            }
        } else if (!((Object)requestOptions).equals(requestOptions2)) return false;
        AttributeMap attributeMap = this.attributes();
        AttributeMap attributeMap2 = request.attributes();
        if (attributeMap == null) {
            if (attributeMap2 != null) {
                return false;
            }
        } else if (!attributeMap.equals(attributeMap2)) return false;
        if (!request.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Request;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "Request";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return new Method(this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "method";
            }
            case 1: {
                return "uri";
            }
            case 2: {
                return "body";
            }
            case 3: {
                return "headers";
            }
            case 4: {
                return "response";
            }
            case 5: {
                return "options";
            }
            case 6: {
                return "attributes";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String method() {
        return this.method;
    }

    public Uri uri() {
        return this.uri;
    }

    public BasicBody body() {
        return this.body;
    }

    @Override
    public Seq<Header> headers() {
        return this.headers;
    }

    public ResponseAs<T> response() {
        return this.response;
    }

    @Override
    public RequestOptions options() {
        return this.options;
    }

    @Override
    public AttributeMap attributes() {
        return this.attributes;
    }

    @Override
    public Request<T> method(String method, Uri uri) {
        return this.copy(method, uri, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public Request<T> withHeaders(Seq<Header> headers) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), headers, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public Request<T> withOptions(RequestOptions options) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), options, this.copy$default$7());
    }

    @Override
    public Request<T> withAttributes(AttributeMap attributes) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), attributes);
    }

    @Override
    public Request<T> copyWithBody(BasicBody body) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), body, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public <S> StreamRequest<T, S> multipartStreamBody(Seq<Part<BodyPart<S>>> ps) {
        return StreamRequest$.MODULE$.apply(this.method(), this.uri(), MultipartStreamBody$.MODULE$.apply(ps), this.headers(), StreamResponseAs$.MODULE$.apply(((ResponseAs)this.response()).delegate()), this.options(), this.attributes());
    }

    public <S> StreamRequest<T, S> multipartStreamBody(Part<BodyPart<S>> p1, Seq<Part<BodyPart<S>>> ps) {
        return StreamRequest$.MODULE$.apply(this.method(), this.uri(), MultipartStreamBody$.MODULE$.apply(ps.toList().$colon$colon(p1)), this.headers(), StreamResponseAs$.MODULE$.apply(((ResponseAs)this.response()).delegate()), this.options(), this.attributes());
    }

    public <S> StreamRequest<T, S> streamBody(package.Streams<S> s, Object b) {
        return StreamRequest$.MODULE$.apply(this.method(), this.uri(), StreamBody$.MODULE$.apply(s, b), this.headers(), StreamResponseAs$.MODULE$.apply(((ResponseAs)this.response()).delegate()), this.options(), this.attributes());
    }

    public <T2> Request<T2> response(ResponseAs<T2> ra) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), ra, this.copy$default$6(), this.copy$default$7());
    }

    public <T2> Request<T2> mapResponse(Function1<T, T2> f) {
        return this.response(((ResponseAs)this.response()).map(f));
    }

    public <T2> Request<T2> mapResponseWithMetadata(Function2<T, ResponseMetadata, T2> f) {
        return this.response(((ResponseAs)this.response()).mapWithMetadata(f));
    }

    public <A, B, B2> Request<Either<A, B2>> mapResponseRight(Function1<B, B2> f, .less.colon.less<T, Either<A, B>> tIsEither) {
        return this.response(((ResponseAs)this.response()).mapRight(f, tIsEither));
    }

    public <F, T2> WebSocketRequest<F, T2> response(WebSocketResponseAs<F, T2> ra) {
        return WebSocketRequest$.MODULE$.apply(this.method(), this.uri(), this.body(), this.headers(), ra, this.options(), this.attributes());
    }

    public <T2, S> StreamRequest<T2, S> response(StreamResponseAs<T2, S> ra) {
        return StreamRequest$.MODULE$.apply(this.method(), this.uri(), this.body(), this.headers(), ra, this.options(), this.attributes());
    }

    public <T2, S> WebSocketStreamRequest<T2, S> response(WebSocketStreamResponseAs<T2, S> ra) {
        return WebSocketStreamRequest$.MODULE$.apply(this.method(), this.uri(), this.body(), this.headers(), ra, this.options(), this.attributes());
    }

    public <F> Object send(Backend<F> backend) {
        return backend.send(this);
    }

    public Response<T> send(SyncBackend backend) {
        return (Response)backend.send(this);
    }

    public <T> Request<T> copy(String method, Uri uri, BasicBody body, Seq<Header> headers, ResponseAs<T> response, RequestOptions options, AttributeMap attributes) {
        return new Request<T>(method, uri, body, headers, response, options, attributes);
    }

    public <T> String copy$default$1() {
        return this.method();
    }

    public <T> Uri copy$default$2() {
        return this.uri();
    }

    public <T> BasicBody copy$default$3() {
        return this.body();
    }

    public <T> Seq<Header> copy$default$4() {
        return this.headers();
    }

    public <T> ResponseAs<T> copy$default$5() {
        return this.response();
    }

    public <T> RequestOptions copy$default$6() {
        return this.options();
    }

    public <T> AttributeMap copy$default$7() {
        return this.attributes();
    }

    public String _1() {
        return this.method();
    }

    public Uri _2() {
        return this.uri();
    }

    public BasicBody _3() {
        return this.body();
    }

    public Seq<Header> _4() {
        return this.headers();
    }

    public ResponseAs<T> _5() {
        return this.response();
    }

    public RequestOptions _6() {
        return this.options();
    }

    public AttributeMap _7() {
        return this.attributes();
    }
}

