/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private final InputStream in;
    private long left;
    private long mark;

    public LimitedInputStream(InputStream in, long limit) {
        this.in = in;
        super(in);
        this.left = limit;
        this.mark = -1L;
    }

    public long left() {
        return this.left;
    }

    public void left_$eq(long x$1) {
        this.left = x$1;
    }

    @Override
    public int available() {
        return Math.min(this.in.available(), (int)this.left());
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.left();
    }

    @Override
    public int read() {
        if (this.left() == 0L) {
            return this.onLimit();
        }
        int result = this.in.read();
        if (result != -1) {
            this.left_$eq(this.left() - 1L);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.left() == 0L) {
            int checkRead = this.in.read();
            if (checkRead == -1) {
                return -1;
            }
            return this.onLimit();
        }
        int adjustedLen = Math.min(len, (int)this.left());
        int result = this.in.read(b, off, adjustedLen);
        if (result != -1) {
            this.left_$eq(this.left() - (long)result);
        }
        return result;
    }

    @Override
    public void reset() {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left_$eq(this.mark);
    }

    @Override
    public long skip(long n) {
        long toSkip = Math.min(n, this.left());
        long skipped = this.in.skip(toSkip);
        this.left_$eq(this.left() - skipped);
        return skipped;
    }

    public int onLimit() {
        return -1;
    }
}

