/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal.httpclient;

import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.None$;
import scala.Option;
import sttp.client4.internal.package$;
import sttp.client4.internal.ws.SimpleQueue;
import sttp.client4.internal.ws.WebSocketEvent;
import sttp.client4.internal.ws.WebSocketEvent$Error$;
import sttp.client4.internal.ws.WebSocketEvent$Frame$;
import sttp.client4.internal.ws.WebSocketEvent$Open$;
import sttp.ws.WebSocketFrame;

public class AddToQueueListener<F>
implements WebSocket.Listener {
    private final SimpleQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean isOpen;

    public AddToQueueListener(SimpleQueue<F, WebSocketEvent> queue, AtomicBoolean isOpen) {
        this.queue = queue;
        this.isOpen = isOpen;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.isOpen.set(true);
        this.queue.offer(WebSocketEvent$Open$.MODULE$.apply());
        webSocket.request(1L);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Text$.MODULE$.apply(data.toString(), last, (Option)None$.MODULE$));
        return null;
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Binary$.MODULE$.apply(package$.MODULE$.RichByteBuffer(data).safeRead(), last, (Option)None$.MODULE$));
        return null;
    }

    @Override
    public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Ping$.MODULE$.apply(package$.MODULE$.RichByteBuffer(message).safeRead()));
        return null;
    }

    @Override
    public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Pong$.MODULE$.apply(package$.MODULE$.RichByteBuffer(message).safeRead()));
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.isOpen.set(false);
        this.queue.offer(WebSocketEvent$Frame$.MODULE$.apply((WebSocketFrame)WebSocketFrame.Close$.MODULE$.apply(statusCode, reason)));
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        this.isOpen.set(false);
        this.queue.offer(WebSocketEvent$Error$.MODULE$.apply(error));
        WebSocket.Listener.super.onError(webSocket, error);
    }

    private void onFrame(WebSocketFrame f) {
        this.queue.offer(WebSocketEvent$Frame$.MODULE$.apply(f));
    }
}

