/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.vid;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameUtils;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.nlogo.extensions.vid.BoundedNode;
import org.nlogo.extensions.vid.BoundedNode$;
import org.nlogo.extensions.vid.Camera$;
import org.nlogo.extensions.vid.VideoSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class Camera
implements VideoSource {
    private final int deviceIndex;
    private final OpenCVFrameGrabber grabber;
    private Option<BufferedImage> cachedImage;
    private boolean isClosed;

    public static Seq<String> cameraNames() {
        return Camera$.MODULE$.cameraNames();
    }

    public static Option<String> defaultCameraName() {
        return Camera$.MODULE$.defaultCameraName();
    }

    public static Option<VideoSource> open(String string) {
        return Camera$.MODULE$.open(string);
    }

    public static <A> A withContextClassLoader(Function0<A> function0) {
        return Camera$.MODULE$.withContextClassLoader(function0);
    }

    public Camera(int deviceIndex) {
        this.deviceIndex = deviceIndex;
        this.grabber = (OpenCVFrameGrabber)Camera$.MODULE$.withContextClassLoader((Function0 & Serializable)() -> {
            OpenCVFrameGrabber g = new OpenCVFrameGrabber(deviceIndex);
            g.start();
            return g;
        });
        this.cachedImage = Option$.MODULE$.empty();
        this.isClosed = false;
    }

    public OpenCVFrameGrabber grabber() {
        return this.grabber;
    }

    public Option<BufferedImage> cachedImage() {
        return this.cachedImage;
    }

    public void cachedImage_$eq(Option<BufferedImage> x$1) {
        this.cachedImage = x$1;
    }

    @Override
    public boolean isPlaying() {
        return this.cachedImage().isEmpty();
    }

    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void setTime(double timeInSeconds) {
    }

    @Override
    public void stop() {
        this.cachedImage_$eq((Option<BufferedImage>)Some$.MODULE$.apply((Object)this.captureImage()));
    }

    @Override
    public void play() {
        this.cachedImage_$eq((Option<BufferedImage>)None$.MODULE$);
    }

    @Override
    public void close() {
        this.isClosed = true;
        Camera$.MODULE$.withContextClassLoader((JFunction0.mcV.sp & Serializable)() -> this.grabber().stop());
    }

    @Override
    public BufferedImage captureImage() {
        return (BufferedImage)this.cachedImage().getOrElse(this::captureImage$$anonfun$1);
    }

    private BoundedNode cameraNode(Option<Tuple2<Object, Object>> enforcedBounds) {
        ImageView imageView = new ImageView();
        enforcedBounds.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double w = tuple2._1$mcD$sp();
                double h = tuple2._2$mcD$sp();
                imageView.setFitWidth(w);
                imageView.setFitHeight(h);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        UpdateImage updateImage = new UpdateImage();
        OnUpdateSuccess onUpdate = new OnUpdateSuccess(this, imageView, updateImage);
        updateImage.setOnSucceeded(onUpdate);
        updateImage.start();
        ObjectBinding preferredSize = Bindings.createObjectBinding(() -> new Dimension((int)((Bounds)imageView.boundsInLocalProperty().get()).getWidth(), (int)((Bounds)imageView.boundsInLocalProperty().get()).getHeight()), (Observable[])new Observable[]{imageView.boundsInLocalProperty()});
        return BoundedNode$.MODULE$.apply((Node)imageView, (ObservableValue<Dimension>)preferredSize, enforcedBounds);
    }

    @Override
    public BoundedNode videoNode(Option<Tuple2<Object, Object>> bounds) {
        return this.cameraNode(bounds);
    }

    private final BufferedImage captureImage$$anonfun$1() {
        return (BufferedImage)Camera$.MODULE$.withContextClassLoader((Function0 & Serializable)() -> {
            Frame frame = this.grabber().grab();
            return Java2DFrameUtils.toBufferedImage((Frame)frame);
        });
    }

    public class OnUpdateSuccess
    implements EventHandler<WorkerStateEvent> {
        private final ImageView imageView;
        private final Service<Image> imageUpdate;
        private final /* synthetic */ Camera $outer;

        public OnUpdateSuccess(Camera $outer, ImageView imageView, Service<Image> imageUpdate) {
            this.imageView = imageView;
            this.imageUpdate = imageUpdate;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public void handle(WorkerStateEvent wse) {
            this.imageView.setImage((Image)this.imageUpdate.getValue());
            this.imageUpdate.reset();
            this.imageUpdate.restart();
        }

        public final /* synthetic */ Camera org$nlogo$extensions$vid$Camera$OnUpdateSuccess$$$outer() {
            return this.$outer;
        }
    }

    public class UpdateImage
    extends Service<Image> {
        public UpdateImage() {
            if (Camera.this == null) {
                throw new NullPointerException();
            }
        }

        public Task<Image> createTask() {
            return new Task<Image>(this){
                private final /* synthetic */ UpdateImage $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Image call() {
                    return SwingFXUtils.toFXImage((BufferedImage)this.$outer.org$nlogo$extensions$vid$Camera$UpdateImage$$$outer().captureImage(), null);
                }
            };
        }

        public final /* synthetic */ Camera org$nlogo$extensions$vid$Camera$UpdateImage$$$outer() {
            return Camera.this;
        }
    }
}

