/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.vid;

import java.io.Serializable;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.core.Primitive;
import org.nlogo.extensions.vid.BoundedNode;
import org.nlogo.extensions.vid.Camera$;
import org.nlogo.extensions.vid.CameraFactory;
import org.nlogo.extensions.vid.CameraNames;
import org.nlogo.extensions.vid.CameraOpen;
import org.nlogo.extensions.vid.CameraSelect;
import org.nlogo.extensions.vid.CaptureImage;
import org.nlogo.extensions.vid.CloseVideoSource;
import org.nlogo.extensions.vid.HidePlayer;
import org.nlogo.extensions.vid.JavaFXPlayer;
import org.nlogo.extensions.vid.MP4Recorder;
import org.nlogo.extensions.vid.Movie$;
import org.nlogo.extensions.vid.MovieFactory;
import org.nlogo.extensions.vid.MovieOpen;
import org.nlogo.extensions.vid.MovieOpenRemote;
import org.nlogo.extensions.vid.MovieSelect;
import org.nlogo.extensions.vid.NetLogoSelector$;
import org.nlogo.extensions.vid.Player;
import org.nlogo.extensions.vid.RecordInterface;
import org.nlogo.extensions.vid.RecordSource;
import org.nlogo.extensions.vid.RecordView;
import org.nlogo.extensions.vid.Recorder;
import org.nlogo.extensions.vid.RecorderStatus;
import org.nlogo.extensions.vid.ReportStatus;
import org.nlogo.extensions.vid.ResetRecorder;
import org.nlogo.extensions.vid.SaveRecording;
import org.nlogo.extensions.vid.Selector;
import org.nlogo.extensions.vid.SetTime;
import org.nlogo.extensions.vid.ShowPlayer;
import org.nlogo.extensions.vid.StartRecorder;
import org.nlogo.extensions.vid.StartSource;
import org.nlogo.extensions.vid.StopSource;
import org.nlogo.extensions.vid.VidExtension$;
import org.nlogo.extensions.vid.VideoSource;
import org.nlogo.extensions.vid.VideoSourceContainer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.function.JProcedure1;

public class VidExtension
extends DefaultClassManager
implements VideoSourceContainer {
    private final MovieFactory movies;
    private final CameraFactory cameras;
    private final Player player;
    private final Selector selector;
    private final Recorder recorder;
    private Option<VideoSource> _videoSource;

    public static boolean isHeadless() {
        return VidExtension$.MODULE$.isHeadless();
    }

    public static void isHeadless_$eq(boolean bl) {
        VidExtension$.MODULE$.isHeadless_$eq(bl);
    }

    public VidExtension(MovieFactory movies, CameraFactory cameras, Player player, Selector selector, Recorder recorder) {
        this.movies = movies;
        this.cameras = cameras;
        this.player = player;
        this.selector = selector;
        this.recorder = recorder;
        this._videoSource = None$.MODULE$;
    }

    public VidExtension() {
        this(Movie$.MODULE$, Camera$.MODULE$, new JavaFXPlayer(), NetLogoSelector$.MODULE$, new MP4Recorder());
    }

    public void runOnce(ExtensionManager em) {
        VidExtension$.MODULE$.isHeadless_$eq(!em.workspaceContext().workspaceGUI());
    }

    public void load(PrimitiveManager manager) {
        manager.addPrimitive("camera-names", (Primitive)new CameraNames(this.cameras));
        manager.addPrimitive("camera-open", (Primitive)new CameraOpen(this, this.cameras));
        manager.addPrimitive("camera-select", (Primitive)new CameraSelect(this, this.cameras, this.selector));
        manager.addPrimitive("capture-image", (Primitive)new CaptureImage(this));
        manager.addPrimitive("close", (Primitive)new CloseVideoSource(this));
        manager.addPrimitive("hide-player", (Primitive)new HidePlayer(this.player));
        manager.addPrimitive("movie-open", (Primitive)new MovieOpen(this, this.movies));
        manager.addPrimitive("movie-open-remote", (Primitive)new MovieOpenRemote(this, this.movies));
        manager.addPrimitive("movie-select", (Primitive)new MovieSelect(this, this.movies, this.selector));
        manager.addPrimitive("recorder-status", (Primitive)new RecorderStatus(this.recorder));
        manager.addPrimitive("record-interface", (Primitive)new RecordInterface(this.recorder));
        manager.addPrimitive("record-source", (Primitive)new RecordSource(this.recorder, this));
        manager.addPrimitive("record-view", (Primitive)new RecordView(this.recorder));
        manager.addPrimitive("reset-recorder", (Primitive)new ResetRecorder(this.recorder));
        manager.addPrimitive("save-recording", (Primitive)new SaveRecording(this.recorder));
        manager.addPrimitive("set-time", (Primitive)new SetTime(this));
        manager.addPrimitive("show-player", (Primitive)new ShowPlayer(this.player, this));
        manager.addPrimitive("start", (Primitive)new StartSource(this));
        manager.addPrimitive("start-recorder", (Primitive)new StartRecorder(this.recorder));
        manager.addPrimitive("status", (Primitive)new ReportStatus(this));
        manager.addPrimitive("stop", (Primitive)new StopSource(this));
    }

    public void unload(ExtensionManager em) {
        this.closeSource();
        this.recorder.reset();
    }

    @Override
    public void closeSource() {
        this._videoSource().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.close());
    }

    public Option<VideoSource> _videoSource() {
        return this._videoSource;
    }

    public void _videoSource_$eq(Option<VideoSource> x$1) {
        this._videoSource = x$1;
    }

    @Override
    public Option<VideoSource> videoSource() {
        return this._videoSource();
    }

    @Override
    public void videoSource_$eq(Option<VideoSource> source) {
        try {
            if (this.player.isShowing()) {
                BoundedNode boundedNode = (BoundedNode)((Function1)source.map((Function1 & Serializable)n -> (Function1 & Serializable)b -> n.videoNode((Option<Tuple2<Object, Object>>)b)).getOrElse(this::$anonfun$2)).apply(this.player.boundedSize());
                this.player.present(boundedNode);
            }
            this.closeSource();
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)"VID Extension Exception");
            Predef$.MODULE$.println((Object)e.getMessage());
            e.printStackTrace();
        }
        this._videoSource_$eq(source);
    }

    private final Function1 $anonfun$2() {
        return (Function1 & Serializable)_$2 -> this.player.emptyNode((Option<Tuple2<Object, Object>>)_$2);
    }
}

