/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Dump$;
import org.nlogo.core.Breed;
import org.nlogo.core.Nobody$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class Exporter {
    private final World world;
    private final PrintWriter writer;

    public Exporter(World world, PrintWriter writer) {
        this.world = world;
        this.writer = writer;
    }

    public void exportWorld(boolean full) {
        this.exportRandomState();
        this.exportGlobals();
        if (full) {
            this.exportTurtles();
            this.exportPatches();
            this.exportLinks();
            return;
        }
    }

    private void exportLinks() {
        this.writer.println(Dump$.MODULE$.csv().encode("LINKS"));
        ArrayList<String> allLinkVars = new ArrayList<String>();
        this.world.program().linksOwn().foreach((Function1 & Serializable)v -> allLinkVars.add((String)v));
        int linkVarSize = this.world.program().linksOwn().size();
        Map breedVarIndices = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.world.program().linkBreeds().values().foreach(current -> current.owns().foreach(breedVarName -> {
            if (!breedVarIndices.contains(breedVarName)) {
                allLinkVars.add((String)breedVarName);
                breedVarIndices.update(breedVarName, (Object)BoxesRunTime.boxToInteger((int)(allLinkVars.size() - 1)));
                return;
            }
        }));
        this.writer.println(Dump$.MODULE$.csv().variableNameRow(allLinkVars));
        AgentIterator it = this.world.links().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            AgentSet breed = (AgentSet)link.getLinkVariable(Link.VAR_BREED);
            String key = breed.printName();
            ObjectRef breedOwns = ObjectRef.create(null);
            ObjectRef thisBreedVarIndices = ObjectRef.create((Object)null);
            ObjectRef sortedBreedOwns = ObjectRef.create((Object)null);
            String string = key;
            String string2 = "LINKS";
            if (string == null ? string2 != null : !string.equals(string2)) {
                breedOwns.elem = ((Breed)this.world.program().linkBreeds().apply((Object)key)).owns();
                thisBreedVarIndices.elem = (int[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), Exporter::exportLinks$$anonfun$3, ClassTag$.MODULE$.apply(Integer.TYPE));
                sortedBreedOwns.elem = (String[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), Exporter::exportLinks$$anonfun$4, ClassTag$.MODULE$.apply(String.class));
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ((Seq)breedOwns.elem).size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                    ((String[])sortedBreedOwns$1.elem)[j] = (String)((Seq)breedOwns$1.elem).apply(j);
                    ((int[])thisBreedVarIndices$1.elem)[j] = BoxesRunTime.unboxToInt((Object)breedVarIndices.apply(((Seq)breedOwns$1.elem).apply(j)));
                });
                this.sortIndicesAndVars((String[])sortedBreedOwns.elem, (int[])thisBreedVarIndices.elem);
            } else {
                thisBreedVarIndices.elem = new int[0];
            }
            IntRef index = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), allLinkVars.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                if (j > 0) {
                    this.writer.print(",");
                }
                if (j < linkVarSize) {
                    this.writer.print(Dump$.MODULE$.csv().data(link.getLinkVariable(j)));
                    return;
                }
                if (index$1.elem < ((int[])thisBreedVarIndices$2.elem).length && j == ((int[])thisBreedVarIndices$2.elem)[index$1.elem]) {
                    this.writer.print(Dump$.MODULE$.csv().data(link.getLinkVariable(this.world.linkBreedsOwnIndexOf(breed, ((String[])sortedBreedOwns$2.elem)[index$1.elem]))));
                    ++index$1.elem;
                    return;
                }
            });
            this.writer.println();
        }
        this.writer.println();
    }

    private void exportRandomState() {
        this.writer.println(Dump$.MODULE$.csv().encode("RANDOM STATE"));
        this.writer.println(Dump$.MODULE$.csv().encode(this.world.mainRNG().save()));
        this.writer.println();
    }

    public void exportGlobals() {
        this.writer.println(Dump$.MODULE$.csv().encode("GLOBALS"));
        this.writer.print(Dump$.MODULE$.csv().encode("min-pxcor") + "," + Dump$.MODULE$.csv().encode("max-pxcor") + "," + Dump$.MODULE$.csv().encode("min-pycor") + "," + Dump$.MODULE$.csv().encode("max-pycor") + "," + Dump$.MODULE$.csv().encode("perspective") + "," + Dump$.MODULE$.csv().encode("subject") + "," + Dump$.MODULE$.csv().encode("nextIndex") + "," + Dump$.MODULE$.csv().encode("directed-links") + "," + Dump$.MODULE$.csv().encode("ticks"));
        Seq<String> globals = this.world.program().globals();
        ArrayList<String> sortedGlobals = new ArrayList<String>(globals.size());
        Map globalVarIndices = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        ((IterableOnceOps)globals.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String g = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                globalVarIndices.update((Object)g, (Object)BoxesRunTime.boxToInteger((int)i));
                return sortedGlobals.add(g);
            }
            throw new MatchError((Object)tuple2);
        });
        Collections.sort(sortedGlobals);
        Object subject = Option$.MODULE$.apply((Object)this.world.observer().targetAgent()).getOrElse(Exporter::$anonfun$1);
        if (!sortedGlobals.isEmpty()) {
            this.writer.print("," + Dump$.MODULE$.csv().variableNameRow(sortedGlobals));
        }
        this.writer.println();
        this.writer.print(Dump$.MODULE$.csv().encode(BoxesRunTime.boxToInteger((int)this.world.minPxcor()).toString()) + "," + Dump$.MODULE$.csv().encode(BoxesRunTime.boxToInteger((int)this.world.maxPxcor()).toString()) + "," + Dump$.MODULE$.csv().encode(BoxesRunTime.boxToInteger((int)this.world.minPycor()).toString()) + "," + Dump$.MODULE$.csv().encode(BoxesRunTime.boxToInteger((int)this.world.maxPycor()).toString()) + "," + Dump$.MODULE$.csv().encode(BoxesRunTime.boxToInteger((int)this.world.observer().perspective().export()).toString()) + "," + Dump$.MODULE$.csv().data(subject) + "," + Dump$.MODULE$.csv().encode(Long.toString(this.world.nextTurtleIndex())) + "," + Dump$.MODULE$.csv().data(this.world.links().isDirected() ? "DIRECTED" : (this.world.links().isUndirected() ? "UNDIRECTED" : "NEITHER")) + "," + Dump$.MODULE$.csv().encode(Dump$.MODULE$.number(this.world.tickCounter().ticks())));
        CollectionConverters$.MODULE$.CollectionHasAsScala(sortedGlobals).asScala().foreach(g -> {
            this.writer.print(",");
            this.writer.print(Dump$.MODULE$.csv().data(this.world.observer().getVariable(BoxesRunTime.unboxToInt((Object)globalVarIndices.apply(g)))));
        });
        this.writer.println();
        this.writer.println();
    }

    public void exportTurtles() {
        this.writer.println(Dump$.MODULE$.csv().encode("TURTLES"));
        ArrayList<String> allTurtleVars = new ArrayList<String>(CollectionConverters$.MODULE$.SeqHasAsJava(this.world.program().turtlesOwn()).asJava());
        int turtlesVarSize = this.world.program().turtlesOwn().size();
        Map breedVarIndices = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.world.program().breeds().values().foreach(current -> current.owns().foreach(breedVarName -> {
            if (!breedVarIndices.contains(breedVarName)) {
                allTurtleVars.add((String)breedVarName);
                breedVarIndices.update(breedVarName, (Object)BoxesRunTime.boxToInteger((int)(allTurtleVars.size() - 1)));
                return;
            }
        }));
        this.writer.println(Dump$.MODULE$.csv().variableNameRow(allTurtleVars));
        AgentIterator it = this.world.turtles().iterator();
        while (it.hasNext()) {
            Turtle turtle = (Turtle)it.next();
            this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(Turtle.VAR_WHO)));
            AgentSet breed = (AgentSet)turtle.getTurtleVariable(Turtle.VAR_BREED);
            String key = breed.printName();
            ObjectRef breedOwns = ObjectRef.create(null);
            ObjectRef thisBreedVarIndices = ObjectRef.create((Object)null);
            ObjectRef sortedBreedOwns = ObjectRef.create((Object)null);
            String string = key;
            String string2 = "TURTLES";
            if (string == null ? string2 != null : !string.equals(string2)) {
                breedOwns.elem = ((Breed)this.world.program().breeds().apply((Object)key)).owns();
                thisBreedVarIndices.elem = (int[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), Exporter::exportTurtles$$anonfun$2, ClassTag$.MODULE$.apply(Integer.TYPE));
                sortedBreedOwns.elem = (String[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), Exporter::exportTurtles$$anonfun$3, ClassTag$.MODULE$.apply(String.class));
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ((Seq)breedOwns.elem).size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                    ((String[])sortedBreedOwns$3.elem)[j] = (String)((Seq)breedOwns$2.elem).apply(j);
                    ((int[])thisBreedVarIndices$3.elem)[j] = BoxesRunTime.unboxToInt((Object)breedVarIndices.apply(((Seq)breedOwns$2.elem).apply(j)));
                });
                this.sortIndicesAndVars((String[])sortedBreedOwns.elem, (int[])thisBreedVarIndices.elem);
            } else {
                thisBreedVarIndices.elem = new int[0];
            }
            IntRef index = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), allTurtleVars.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                this.writer.print(",");
                if (j < turtlesVarSize) {
                    this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(j)));
                    return;
                }
                if (index$2.elem < ((int[])thisBreedVarIndices$4.elem).length && j == ((int[])thisBreedVarIndices$4.elem)[index$2.elem]) {
                    this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(this.world.breedsOwnIndexOf(breed, ((String[])sortedBreedOwns$4.elem)[index$2.elem]))));
                    ++index$2.elem;
                    return;
                }
            });
            this.writer.println();
        }
        this.writer.println();
    }

    private void exportPatches() {
        this.writer.println(Dump$.MODULE$.csv().encode("PATCHES"));
        Seq<String> vars = this.world.program().patchesOwn();
        this.writer.println(Dump$.MODULE$.csv().variableNameRow(vars));
        AgentIterator it = this.world.patches().iterator();
        while (it.hasNext()) {
            Patch patch = (Patch)it.next();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), vars.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                if (j > 0) {
                    this.writer.print(",");
                }
                this.writer.print(Dump$.MODULE$.csv().data(patch.getPatchVariable(j)));
            });
            this.writer.println();
        }
        this.writer.println();
    }

    public void sortIndicesAndVars(String[] vars, int[] indices) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])vars);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapIntArray(indices)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(object2, (Function1 & Serializable)_$1 -> BoxesRunTime.unboxToInt((Object)_$1._2()), (Ordering)Ordering.Int$.MODULE$));
        Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(object3, Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Integer.TYPE));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] sortedVars = (String[])tuple2._1();
        int[] sortedIndices = (int[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)sortedVars, (Object)sortedIndices);
        Object[] sortedVars2 = (String[])tuple22._1();
        int[] sortedIndices2 = (int[])tuple22._2();
        Object object4 = Predef$.MODULE$.refArrayOps(sortedVars2);
        ArrayOps$.MODULE$.copyToArray$extension(object4, (Object)vars);
        Object object5 = Predef$.MODULE$.intArrayOps(sortedIndices2);
        ArrayOps$.MODULE$.copyToArray$extension(object5, (Object)indices);
    }

    private static final int exportLinks$$anonfun$3() {
        return 0;
    }

    private static final String exportLinks$$anonfun$4() {
        return null;
    }

    private static final Object $anonfun$1() {
        return Nobody$.MODULE$;
    }

    private static final int exportTurtles$$anonfun$2() {
        return 0;
    }

    private static final String exportTurtles$$anonfun$3() {
        return null;
    }
}

