/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import org.nlogo.agent.Neighbors;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology$;
import org.nlogo.agent.World;
import org.nlogo.agent.World2D;
import org.nlogo.api.AgentException;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public interface Topology
extends Neighbors {
    public static Topology get(World2D world2D, boolean bl, boolean bl2) {
        return Topology$.MODULE$.get(world2D, bl, bl2);
    }

    public static double wrap(double d, double d2, double d3) {
        return Topology$.MODULE$.wrap(d, d2, d3);
    }

    public static int wrapPcor(int n, int n2, int n3) {
        return Topology$.MODULE$.wrapPcor(n, n2, n3);
    }

    public World world();

    public boolean xWraps();

    public boolean yWraps();

    public double wrapX(double var1) throws AgentException;

    public double wrapY(double var1) throws AgentException;

    public double distanceWrap(double var1, double var3, double var5, double var7, double var9, double var11);

    public double towardsWrap(double var1, double var3);

    public double shortestPathX(double var1, double var3);

    public double shortestPathY(double var1, double var3);

    public static double followOffsetX$(Topology $this) {
        return $this.followOffsetX();
    }

    default public double followOffsetX() {
        return this.world().observer().followOffsetX();
    }

    public static double followOffsetY$(Topology $this) {
        return $this.followOffsetY();
    }

    default public double followOffsetY() {
        return this.world().observer().followOffsetY();
    }

    public static void diffuse$(Topology $this, double amount, int vn) {
        $this.diffuse(amount, vn);
    }

    default public void diffuse(double amount, int vn) throws PatchException, AgentException {
        double[][] scratch = this.getPatchScratch(vn);
        this.diffuseCenter(amount, vn, false, scratch);
        this.diffuseXBorder(amount, vn, false, scratch);
        this.diffuseYBorder(amount, vn, false, scratch);
        this.diffuseCorners(amount, vn, false, scratch);
    }

    public static void diffuse4$(Topology $this, double amount, int vn) {
        $this.diffuse4(amount, vn);
    }

    default public void diffuse4(double amount, int vn) throws PatchException, AgentException {
        double[][] scratch = this.getPatchScratch(vn);
        this.diffuseCenter(amount, vn, true, scratch);
        this.diffuseXBorder(amount, vn, true, scratch);
        this.diffuseYBorder(amount, vn, true, scratch);
        this.diffuseCorners(amount, vn, true, scratch);
    }

    public static void diffuseCenter$(Topology $this, double amount, int vn, boolean fourWay, double[][] scratch) {
        $this.diffuseCenter(amount, vn, fourWay, scratch);
    }

    default public void diffuseCenter(double amount, int vn, boolean fourWay, double[][] scratch) {
        int lastX = this.world().worldWidth() - 1;
        int lastY = this.world().worldHeight() - 1;
        for (int x = 1; x < lastX; ++x) {
            double[] e = scratch[x + 1];
            double[] c = scratch[x];
            double[] w = scratch[x - 1];
            for (int y = 1; y < lastY; ++y) {
                double oldVal = c[y];
                double sum = this.sum4(e[y], w[y], c[y - 1], c[y + 1]);
                if (fourWay) {
                    this.updatePatch(amount, vn, 4, x, y, oldVal, sum);
                    continue;
                }
                this.updatePatch(amount, vn, 8, x, y, oldVal, sum + this.sum4(e[y + 1], e[y - 1], w[y + 1], w[y - 1]));
            }
        }
    }

    public void diffuseXBorder(double var1, int var3, boolean var4, double[][] var5);

    public void diffuseYBorder(double var1, int var3, boolean var4, double[][] var5);

    public void diffuseCorners(double var1, int var3, boolean var4, double[][] var5);

    public static double sum4$(Topology $this, double a, double b, double c, double d) {
        return $this.sum4(a, b, c, d);
    }

    default public double sum4(double a, double b, double c, double d) {
        double low1 = 0.0;
        double high1 = 0.0;
        double low2 = 0.0;
        double high2 = 0.0;
        if (a < b) {
            low1 = a;
            high1 = b;
        } else {
            low1 = b;
            high1 = a;
        }
        if (c < d) {
            low2 = c;
            high2 = d;
        } else {
            low2 = d;
            high2 = c;
        }
        if (low2 < high1 && low1 < high2) {
            return low1 + low2 + (high1 + high2);
        }
        return low1 + high1 + (low2 + high2);
    }

    public static void updatePatch$(Topology $this, double amount, int vn, int directions, int x, int y, double oldVal, double sum) {
        $this.updatePatch(amount, vn, directions, x, y, oldVal, sum);
    }

    default public void updatePatch(double amount, int vn, int directions, int x, int y, double oldVal, double sum) {
        double newVal = oldVal + amount * (sum / (double)directions - oldVal);
        if (newVal != oldVal) {
            this.world().patches().getByIndex(y * this.world().worldWidth() + x).setPatchVariable(vn, BoxesRunTime.boxToDouble((double)newVal));
            return;
        }
    }

    public static double[][] getPatchScratch$(Topology $this, int vn) {
        return $this.getPatchScratch(vn);
    }

    default public double[][] getPatchScratch(int vn) {
        int xx = this.world().worldWidth();
        int yy = this.world().worldHeight();
        int minX = this.world().minPxcor();
        int maxY = this.world().maxPycor();
        double[][] scratch = this.world().getPatchScratch();
        int ps = xx * yy;
        for (int i = 0; i < ps; ++i) {
            Patch p = (Patch)this.world().patches().getByIndex(i);
            scratch[p.pxcor - minX][maxY - p.pycor] = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)p.getPatchVariable(vn)));
        }
        return scratch;
    }

    public static ArrayList getRegion$(Topology $this, int initialX, int initialY, int initialR) {
        return $this.getRegion(initialX, initialY, initialR);
    }

    default public ArrayList<Tuple2<Object, Object>> getRegion(int initialX, int initialY, int initialR) {
        int i;
        Tuple2[] tuple2Array;
        boolean high_within;
        int x = initialX - this.world().minPxcor();
        int y = this.world().worldHeight() - 1 - (initialY - this.world().minPycor());
        int r = initialR;
        ArrayList<Tuple2<Object, Object>> ans = new ArrayList<Tuple2<Object, Object>>();
        boolean low_within = y - r >= 0;
        boolean bl = high_within = y + r <= this.world().worldHeight() - 1;
        if (low_within && high_within) {
            tuple2Array = new Tuple2[]{Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(y - r)), (Object)BoxesRunTime.boxToInteger((int)(y + r + 1)))};
        } else if (!low_within && !high_within) {
            tuple2Array = new Tuple2[]{Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.world().worldHeight()))};
        } else if (low_within) {
            if (this.yWraps()) {
                int max1 = y + r - this.world().worldHeight() + 1;
                int min2 = y - r <= max1 ? max1 : y - r;
                tuple2Array = new Tuple2[]{new Tuple2.mcII.sp(0, max1), Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)min2), (Object)BoxesRunTime.boxToInteger((int)this.world().worldHeight()))};
            } else {
                tuple2Array = new Tuple2[]{Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(y - r)), (Object)BoxesRunTime.boxToInteger((int)this.world().worldHeight()))};
            }
        } else if (this.yWraps()) {
            int max1 = y + r + 1;
            int min2 = this.world().worldHeight() + y - r <= max1 ? max1 : this.world().worldHeight() + y - r;
            tuple2Array = new Tuple2[]{new Tuple2.mcII.sp(0, max1), Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)min2), (Object)BoxesRunTime.boxToInteger((int)this.world().worldHeight()))};
        } else {
            tuple2Array = new Tuple2[]{Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)(y + r + 1)))};
        }
        Tuple2[] y_ranges = tuple2Array;
        for (i = y_ranges[0]._1$mcI$sp(); i < y_ranges[0]._2$mcI$sp(); ++i) {
            this.getRegionRow(x, r, i * this.world().worldWidth(), ans);
        }
        if (y_ranges.length > 1) {
            for (i = y_ranges[1]._1$mcI$sp(); i < y_ranges[1]._2$mcI$sp(); ++i) {
                this.getRegionRow(x, r, i * this.world().worldWidth(), ans);
            }
        }
        return ans;
    }

    private void getRegionRow(int x, int r, int offset, ArrayList<Tuple2<Object, Object>> arr) {
        boolean high_within;
        boolean low_within = x - r >= 0;
        boolean bl = high_within = x + r <= this.world().worldWidth() - 1;
        if (low_within && high_within) {
            this.mergeAdd((Tuple2<Object, Object>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(offset + x - r)), (Object)BoxesRunTime.boxToInteger((int)(offset + x + r + 1))), arr);
            return;
        }
        if (!low_within && !high_within) {
            this.mergeAdd((Tuple2<Object, Object>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(offset + 0)), (Object)BoxesRunTime.boxToInteger((int)(offset + this.world().worldWidth()))), arr);
            return;
        }
        if (!low_within) {
            this.mergeAdd((Tuple2<Object, Object>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(offset + 0)), (Object)BoxesRunTime.boxToInteger((int)(offset + x + r + 1))), arr);
            if (this.xWraps()) {
                this.mergeAdd((Tuple2<Object, Object>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(offset + this.world().worldWidth() + x - r)), (Object)BoxesRunTime.boxToInteger((int)(offset + this.world().worldWidth()))), arr);
                return;
            }
            return;
        }
        if (this.xWraps()) {
            this.mergeAdd((Tuple2<Object, Object>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(offset + 0)), (Object)BoxesRunTime.boxToInteger((int)(offset + x + r - this.world().worldWidth() + 1))), arr);
        }
        this.mergeAdd((Tuple2<Object, Object>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(offset + x - r)), (Object)BoxesRunTime.boxToInteger((int)(offset + this.world().worldWidth()))), arr);
    }

    private void mergeAdd(Tuple2<Object, Object> value, ArrayList<Tuple2<Object, Object>> arr) {
        int s = arr.size();
        if (s == 0 || arr.get(s - 1)._2$mcI$sp() < value._1$mcI$sp()) {
            arr.add(value);
            return;
        }
        Tuple2<Object, Object> last = arr.get(s - 1);
        arr.set(s - 1, (Tuple2<Object, Object>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(last._1$mcI$sp()), value._1$mcI$sp())), (Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(value._2$mcI$sp()), last._2$mcI$sp()))));
    }
}

