/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PenLineMaker;
import org.nlogo.agent.Trail;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.TrigTables;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.World2D;
import org.nlogo.api.AgentException;
import org.nlogo.api.Exceptions;
import org.nlogo.core.I18N;

public class Turtle2D
extends Turtle {
    public Turtle2D(World world, AgentSet breed, Double xcor, Double ycor) {
        super(world, breed, xcor, ycor, true);
    }

    private Turtle2D(World world, AgentSet breed, Double xcor, Double ycor, boolean getId) {
        super(world, breed, xcor, ycor, getId);
    }

    Turtle2D(World world, long id) {
        this(world, world.turtles(), World.Zero(), World.Zero(), false);
        this.setId(id);
        this._world.turtles().add(this);
    }

    Turtle2D(World world) {
        super(world);
    }

    @Override
    public Turtle hatch(TreeAgentSet breed) {
        Turtle2D child = new Turtle2D((World2D)this._world);
        child.heading = this.heading;
        child.xcor = this.xcor;
        child.ycor = this.ycor;
        child.setVariables((Object[])this._variables.clone());
        child.setId(this._world.newTurtleId());
        this._world.turtles().add(child);
        if (breed != this.getBreed()) {
            child.setBreed(breed);
        }
        if (breed != this._world.turtles()) {
            breed.add(child);
        }
        child.getPatchHere().addTurtle(child);
        return child;
    }

    @Override
    Turtle makeTurtle(World world) {
        return new Turtle2D(world);
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        org.nlogo.api.Patch target = this._world.getPatchAt(this.xcor + dx, this.ycor + dy);
        if (target == null) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.patchBeyondLimits"));
        }
        return target;
    }

    @Override
    public void jump(double distance) throws AgentException {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int integerHeading = (int)this.heading;
            if (this.heading == (double)integerHeading) {
                this.cachedCosine = TrigTables.cos()[integerHeading];
                this.cachedSine = TrigTables.sin()[integerHeading];
            } else {
                double headingRadians = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(headingRadians);
                this.cachedSine = StrictMath.sin(headingRadians);
            }
        }
        if (this.penMode() != PEN_UP) {
            try {
                Patch ignore = this.getPatchAtHeadingAndDistance(0.0, distance);
                this.drawLine(this.xcor, this.ycor, distance);
            }
            catch (AgentException ex) {
                Exceptions.ignore(ex);
            }
        }
        this.xandycorHelper(this.xcor + distance * this.cachedSine, this.ycor + distance * this.cachedCosine, true);
    }

    @Override
    public Patch getPatchHere() {
        if (this.currentPatch == null) {
            this.currentPatch = ((World2D)this._world).getPatchAtWrap(this.xcor, this.ycor);
        }
        return this.currentPatch;
    }

    void drawLine(double xcor, double ycor, double distance) {
        if (this.penMode() != PEN_UP) {
            Trail[] lines;
            Object color = this.variables()[1];
            double size = this.penSize();
            String mode = this.penMode();
            double minPxcor = (double)this.world().minPxcor() - 0.5;
            double maxPxcor = (double)this.world().maxPxcor() + 0.5;
            double minPycor = (double)this.world().minPycor() - 0.5;
            double maxPycor = (double)this.world().maxPycor() + 0.5;
            for (Trail line : lines = PenLineMaker.jumpLine(xcor, ycor, this.heading, distance, minPxcor, maxPxcor, minPycor, maxPycor)) {
                ((World2D)this._world).drawLine(line.x1(), line.y1(), line.x2(), line.y2(), color, size, mode);
            }
        }
    }

    @Override
    void drawLine(double x0, double y0, double x1, double y1) {
        if (this.penMode() != PEN_UP && (x0 != x1 || y0 != y1)) {
            Trail[] lines;
            Object color = this.variables()[1];
            double size = this.penSize();
            String mode = this.penMode();
            double minPxcor = (double)this.world().minPxcor() - 0.5;
            double maxPxcor = (double)this.world().maxPxcor() + 0.5;
            double minPycor = (double)this.world().minPycor() - 0.5;
            double maxPycor = (double)this.world().maxPycor() + 0.5;
            if (minPxcor < x0 && x0 < maxPxcor && minPxcor < x1 && x1 < maxPxcor && minPycor < y0 && y0 < maxPycor && minPycor < y1 && y1 < maxPycor) {
                lines = PenLineMaker.translate(x0, y0, x1, y1);
            } else {
                double jumpDist = StrictMath.sqrt(StrictMath.pow(x0 - x1, 2.0) + StrictMath.pow(y0 - y1, 2.0));
                double dx = x1 - x0;
                double dy = y1 - y0;
                double jumpHead = this.world().topology().towardsWrap(dx, dy);
                lines = PenLineMaker.jumpLine(x0, y0, jumpHead, jumpDist, minPxcor, maxPxcor, minPycor, maxPycor);
            }
            for (Trail line : lines) {
                ((World2D)this._world).drawLine(line.x1(), line.y1(), line.x2(), line.y2(), color, size, mode);
            }
        }
    }

    @Override
    public void moveToPatchCenter() {
        Patch p = this.getPatchHere();
        double x = p.pxcor;
        double y = p.pycor;
        double oldX = this.xcor;
        double oldY = this.ycor;
        this.drawLine(oldX, oldY, x, y);
        if (x != oldX || y != oldY) {
            this.xcor = x;
            this.ycor = y;
            this._variables[3] = p._variables[0];
            this._variables[4] = p._variables[1];
            Observer observer = this._world.observer();
            if (this == observer.targetAgent()) {
                observer.updatePosition();
            }
            if (this._world.tieManager().hasTies()) {
                this._world.tieManager().turtleMoved(this, x, y, oldX, oldY);
            }
        }
    }

    @Override
    public void home() {
        try {
            this.xandycor(World.Zero(), World.Zero());
        }
        catch (AgentException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void face(Agent agent, boolean wrap) {
        try {
            this.heading(this._world.protractor().towards(this, agent, wrap));
        }
        catch (AgentException ex) {
            Exceptions.ignore(ex);
        }
    }

    @Override
    public double dx() {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int integerHeading = (int)this.heading;
            if (this.heading == (double)integerHeading) {
                this.cachedCosine = TrigTables.cos()[integerHeading];
                this.cachedSine = TrigTables.sin()[integerHeading];
            } else {
                double headingRadians = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(headingRadians);
                this.cachedSine = StrictMath.sin(headingRadians);
            }
        }
        return this.cachedSine;
    }

    @Override
    public double dy() {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int integerHeading = (int)this.heading;
            if (this.heading == (double)integerHeading) {
                this.cachedCosine = TrigTables.cos()[integerHeading];
                this.cachedSine = TrigTables.sin()[integerHeading];
            } else {
                double headingRadians = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(headingRadians);
                this.cachedSine = StrictMath.sin(headingRadians);
            }
        }
        return this.cachedCosine;
    }

    @Override
    public Patch getPatchAtHeadingAndDistance(double delta, double distance) throws AgentException {
        double h = this.heading + delta;
        if (h < 0.0 || h >= 360.0) {
            h = (h % 360.0 + 360.0) % 360.0;
        }
        return this._world.protractor().getPatchAtHeadingAndDistance(this, h, distance);
    }

    @Override
    public void turnRight(double delta) {
        this.heading(this.heading + delta);
    }
}

