/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.api.Advisory$;
import org.nlogo.api.Announcement;
import org.nlogo.api.Announcement$;
import org.nlogo.api.AnnouncementType;
import org.nlogo.api.Event$;
import org.nlogo.api.InfoDownloader;
import org.nlogo.api.Release$;
import org.nlogo.core.NetLogoPreferences$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.deriving.Mirror;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class AnnouncementsInfoDownloader$
implements InfoDownloader,
Serializable {
    private static final String prefsKey;
    private static final URL defaultURL;
    public static final AnnouncementsInfoDownloader$ MODULE$;

    private AnnouncementsInfoDownloader$() {
    }

    static {
        MODULE$ = new AnnouncementsInfoDownloader$();
        prefsKey = "announcements";
        defaultURL = new URL("https://backend.netlogo.org/items/announcements");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AnnouncementsInfoDownloader$.class);
    }

    @Override
    public String prefsKey() {
        return prefsKey;
    }

    public URL defaultURL() {
        return defaultURL;
    }

    public Future<Seq<Announcement>> fetch() {
        return this.apply(this.defaultURL()).map((Function1 & Serializable)_$1 -> (Seq)_$1.fold(AnnouncementsInfoDownloader$::fetch$$anonfun$1$$anonfun$1, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                return MODULE$.parse(file);
            }
            throw new MatchError((Object)tuple2);
        }), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Seq<Announcement> parse(File file) {
        Seq seq;
        block3: {
            String contents = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).mkString();
            JSONParser json = new JSONParser();
            try {
                JSONObject topObj = (JSONObject)json.parse(contents);
                JSONArray arr = (JSONArray)topObj.get((Object)"data");
                Iterator iter = arr.iterator();
                Vector announcements = (Vector)CollectionConverters$.MODULE$.IteratorHasAsScala(iter).asScala().toVector().map((Function1 & Serializable)x$1 -> {
                    Mirror.Singleton singleton;
                    LocalDate date;
                    String content;
                    String summary;
                    long lifespan;
                    String title;
                    int id;
                    block9: {
                        Tuple3 tuple3;
                        Object object;
                        Object object2 = x$1;
                        if (!(object2 instanceof JSONObject)) {
                            Object o = object2;
                            throw new IllegalStateException();
                        }
                        JSONObject obj = (JSONObject)object2;
                        id = ((Number)obj.get((Object)"id")).intValue();
                        title = (String)obj.get((Object)"title");
                        String dateStr = (String)obj.get((Object)"date");
                        lifespan = ((Number)obj.get((Object)"lifespan")).longValue();
                        String typeStr = (String)obj.get((Object)"type");
                        summary = (String)obj.get((Object)"summary");
                        content = (String)obj.get((Object)"content");
                        String[] stringArray = dateStr.split("-");
                        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 3) == 0) {
                            String string;
                            String d;
                            String string2;
                            String m;
                            String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                            String y = string3;
                            tuple3 = Tuple3$.MODULE$.apply((Object)y, (Object)(m = (string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1))), (Object)(d = (string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2))));
                            if (tuple3 == null) {
                                throw new MatchError((Object)tuple3);
                            }
                        } else {
                            String[] a = stringArray;
                            throw new IllegalStateException();
                        }
                        String years = (String)tuple3._1();
                        String months = (String)tuple3._2();
                        String days = (String)tuple3._3();
                        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)years, (Object)months, (Object)days);
                        String years2 = (String)tuple32._1();
                        String months2 = (String)tuple32._2();
                        String days2 = (String)tuple32._3();
                        date = LocalDate.of(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(years2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(months2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(days2)));
                        String string = typeStr;
                        switch (string == null ? 0 : string.hashCode()) {
                            case -711288647: {
                                if (!"advisory".equals(string)) break;
                                singleton = Advisory$.MODULE$;
                                break block9;
                            }
                            case 96891546: {
                                if (!"event".equals(string)) break;
                                singleton = Event$.MODULE$;
                                break block9;
                            }
                            case 1090594823: {
                                if (!"release".equals(string)) break;
                                singleton = Release$.MODULE$;
                                break block9;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    AnnouncementType annType = singleton;
                    None$ endDate = lifespan == 0L ? None$.MODULE$ : Option$.MODULE$.apply((Object)date.plusDays(lifespan));
                    return Announcement$.MODULE$.apply(id, title, date, (Option<LocalDate>)endDate, annType, summary, content);
                });
                String string = NetLogoPreferences$.MODULE$.get("announce.debug", "false");
                String string2 = "true";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    seq = (Seq)announcements.filter((Function1 & Serializable)x -> BoxesRunTime.unboxToBoolean((Object)x.endDate().map((Function1 & Serializable)_$2 -> _$2.isAfter(LocalDate.now())).getOrElse(AnnouncementsInfoDownloader$::parse$$anonfun$1$$anonfun$2)));
                    break block3;
                }
                seq = announcements;
            }
            catch (ParseException ex) {
                Predef$.MODULE$.println((Object)ex);
                seq = (Seq)package$.MODULE$.Seq().empty();
            }
        }
        return seq;
    }

    private static final Seq fetch$$anonfun$1$$anonfun$1() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final boolean parse$$anonfun$1$$anonfun$2() {
        return true;
    }
}

