/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import net.lingala.zip4j.ZipFile;
import org.nlogo.core.LibraryInfo;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;

public class ExtensionInstaller {
    private final Path userExtPath;
    private final Function0<BoxedUnit> unloadExtensions;

    public ExtensionInstaller(Path userExtPath, Function0<BoxedUnit> unloadExtensions) {
        this.userExtPath = userExtPath;
        this.unloadExtensions = unloadExtensions;
    }

    public void install(LibraryInfo ext) {
        HttpURLConnection conn = (HttpURLConnection)ext.downloadURL().openConnection();
        if (conn.getResponseCode() == 200) {
            Path path;
            String urlPath = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(ext.downloadURL().getPath()), "/");
            String basename = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(urlPath.substring(urlPath.lastIndexOf(47) + 1)), 4);
            Path zipPath = Files.createTempFile(basename, ".zip", new FileAttribute[0]);
            Files.copy(conn.getInputStream(), zipPath, StandardCopyOption.REPLACE_EXISTING);
            Path extDir = this.userExtPath.resolve(ext.codeName());
            if (!Files.isDirectory(extDir, new LinkOption[0])) {
                path = Files.createDirectory(extDir, new FileAttribute[0]);
            } else {
                this.unloadExtensions.apply$mcV$sp();
                path = BoxedUnit.UNIT;
            }
            new ZipFile(zipPath.toFile()).extractAll(extDir.toString());
            Files.delete(zipPath);
            return;
        }
        throw new IOException();
    }

    public void uninstall(LibraryInfo ext) {
        Path extDir = this.userExtPath.resolve(ext.codeName());
        if (Files.exists(extDir, new LinkOption[0])) {
            Files.walkFileTree(extDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    return this.delete(file);
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
                    return this.delete(dir);
                }

                private FileVisitResult delete(Path path) {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
            return;
        }
    }
}

