/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.nlogo.core.FileMode;
import org.nlogo.core.FileMode$Append$;
import org.nlogo.core.FileMode$None$;
import org.nlogo.core.FileMode$Read$;
import org.nlogo.core.FileMode$Write$;
import scala.MatchError;

public class LocalFile
extends org.nlogo.core.File {
    private final String filepath;
    private PrintWriter w;

    public LocalFile(String filepath) {
        this.filepath = filepath;
        this.w = null;
    }

    @Override
    public PrintWriter getPrintWriter() {
        return this.w;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getPath());
    }

    @Override
    public void open(FileMode mode) throws IOException {
        if (this.w != null || this.reader() != null) {
            throw new IOException("Attempted to open an already open file");
        }
        FileMode fileMode = mode;
        if (FileMode$Read$.MODULE$.equals(fileMode)) {
            this.pos_$eq(0L);
            this.eof_$eq(false);
            this.reader_$eq(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.filepath)), "UTF-8")));
            this.mode_$eq(mode);
            return;
        }
        if (FileMode$Write$.MODULE$.equals(fileMode)) {
            this.w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.filepath)), "UTF-8"));
            this.mode_$eq(mode);
            return;
        }
        if (FileMode$Append$.MODULE$.equals(fileMode)) {
            this.w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.filepath), true), "UTF-8"));
            this.mode_$eq(mode);
            return;
        }
        if (FileMode$None$.MODULE$.equals(fileMode)) {
            throw new IllegalStateException("file is not open");
        }
        throw new MatchError((Object)fileMode);
    }

    @Override
    public void print(String str) throws IOException {
        if (this.w == null) {
            throw new IOException("Attempted to print to an unopened File");
        }
        this.w.print(str);
    }

    @Override
    public void println(String line) throws IOException {
        if (this.w == null) {
            throw new IOException("Attempted to println to an unopened File");
        }
        this.w.println(line);
    }

    @Override
    public void println() throws IOException {
        if (this.w == null) {
            throw new IOException("Attempted to println to an unopened File");
        }
        this.w.println();
    }

    @Override
    public void flush() {
        if (this.w != null) {
            this.w.flush();
            return;
        }
    }

    @Override
    public void close(boolean ok) throws IOException {
        FileMode fileMode = this.mode();
        if (FileMode$Write$.MODULE$.equals(fileMode) || FileMode$Append$.MODULE$.equals(fileMode)) {
            this.w.close();
            this.w = null;
        } else if (FileMode$Read$.MODULE$.equals(fileMode)) {
            this.reader().close();
            this.reader_$eq(null);
        } else if (!FileMode$None$.MODULE$.equals(fileMode)) {
            throw new MatchError((Object)fileMode);
        }
        this.mode_$eq(FileMode$None$.MODULE$);
    }

    @Override
    public String getAbsolutePath() {
        return new File(this.filepath).getAbsolutePath();
    }

    @Override
    public String getPath() {
        return new File(this.filepath).getPath();
    }
}

