/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Component;
import java.io.Serializable;
import org.nlogo.api.ExtensionManager$;
import org.nlogo.api.LibraryInfoDownloader$;
import org.nlogo.app.common.Events;
import org.nlogo.core.I18N$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.window.Events;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ExtensionAssistant
implements Events.CompiledEvent.Handler {
    private final Component parent;
    private final Function1<String, Object> extExists;
    private final Function1<String, String> lookupExtVersion;
    private final Function2<String, String, BoxedUnit> installExt;

    public ExtensionAssistant(Component parent, Function1<String, Object> extExists, Function1<String, String> lookupExtVersion, Function2<String, String, BoxedUnit> installExt) {
        this.parent = parent;
        this.extExists = extExists;
        this.lookupExtVersion = lookupExtVersion;
        this.installExt = installExt;
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        if (Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled()) && Option$.MODULE$.apply((Object)e.error).exists((Function1 & Serializable)_$1 -> _$1.getMessage().startsWith(ExtensionManager$.MODULE$.extensionNotFoundStr()))) {
            String missingExtName = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(e.error.getMessage()), ExtensionManager$.MODULE$.extensionNotFoundStr());
            if (BoxesRunTime.unboxToBoolean((Object)this.extExists.apply((Object)missingExtName))) {
                String missingExtVersion = (String)this.lookupExtVersion.apply((Object)missingExtName);
                if (this.confirmInstall(missingExtName, missingExtVersion)) {
                    this.installExt.apply((Object)missingExtName, (Object)missingExtVersion);
                    return;
                }
                return;
            }
            if (this.confirmOpen(missingExtName)) {
                new Events.OpenLibrariesDialogEvent().raise(this.parent);
                return;
            }
            return;
        }
    }

    public boolean confirmInstall(String extName, String extVersion) {
        return new OptionPane(this.parent, I18N$.MODULE$.gui().get("tabs.code.extension.installable.title"), I18N$.MODULE$.gui().getN("tabs.code.extension.installable.message", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{extName, extVersion})), OptionPane$Options$.MODULE$.YesNo(), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex() == 0;
    }

    public boolean confirmOpen(String extName) {
        return new OptionPane(this.parent, I18N$.MODULE$.gui().get("tabs.code.extension.notfound.title"), I18N$.MODULE$.gui().getN("tabs.code.extension.notfound.message", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{extName})), OptionPane$Options$.MODULE$.YesNo(), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex() == 0;
    }
}

