/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.nlogo.api.ModelReader$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.convert.StreamExtensions;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.jdk.StreamConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.hashing.MurmurHash3$;
import scala.util.matching.Regex;

public final class ModelConfig$
implements Serializable {
    private static final SimpleDateFormat dateFormat;
    public static final ModelConfig$ MODULE$;

    private ModelConfig$() {
    }

    static {
        MODULE$ = new ModelConfig$();
        dateFormat = new SimpleDateFormat("yyyy-MM-dd.HH_mm_ss", Locale.US);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ModelConfig$.class);
    }

    public Path getModelConfigPath(String modelPath) {
        return Paths.get(System.getProperty("user.home"), ".nlogo", "modelConfigs", BoxesRunTime.boxToInteger((int)(MurmurHash3$.MODULE$.stringHash(modelPath) & Integer.MAX_VALUE)).toString());
    }

    public Option<String> getLastModified(String modelPath) {
        File file = this.getModelConfigPath(modelPath).resolve("lastModified.txt").toFile();
        if (file.exists()) {
            BufferedSource source = Source$.MODULE$.fromFile(file, "UTF-8");
            Option result = Option$.MODULE$.apply((Object)((String)source.getLines().next()).trim());
            source.close();
            return result;
        }
        return None$.MODULE$;
    }

    public void setLastModified(String modelPath) {
        File file = this.getModelConfigPath(modelPath).resolve("lastModified.txt").toFile();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        new PrintWriter(file, modelPath){
            {
                this.println(new File(modelPath$1).lastModified());
            }
        }.close();
    }

    public Option<Path> findAutoSave(String modelPath) {
        Path autosaves = this.getModelConfigPath(modelPath).resolve("autosaves");
        if (autosaves.toFile().exists()) {
            long lastModified = new File(modelPath).lastModified();
            return ((IterableOnceOps)StreamConverters$.MODULE$.StreamHasToScala(Files.list(autosaves)).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).maxByOption((Function1 & Serializable)_$1 -> _$1.toFile().lastModified(), (Ordering)Ordering.Long$.MODULE$).filter((Function1 & Serializable)_$2 -> _$2.toFile().lastModified() > lastModified);
        }
        return None$.MODULE$;
    }

    public Path getAutoSavePath(Option<String> modelPath) {
        String name = "autosave_" + dateFormat.format(new Date());
        Option<String> option = modelPath;
        if (option instanceof Some) {
            String path = (String)((Some)option).value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(path), '.'));
            Path save = this.getModelConfigPath(path).resolve("autosaves/" + name + "." + (String)ArrayOps$.MODULE$.last$extension(object));
            if (!save.toFile().exists()) {
                save.toFile().getParentFile().mkdirs();
            }
            return save;
        }
        return Paths.get(System.getProperty("java.io.tmpdir"), name + "." + ModelReader$.MODULE$.modelSuffix());
    }

    public void discardNewAutoSaves(String modelPath) {
        Path autosaves = this.getModelConfigPath(modelPath).resolve("autosaves");
        if (autosaves.toFile().exists()) {
            long lastModified = new File(modelPath).lastModified();
            ((IterableOnceOps)((IterableOps)StreamConverters$.MODULE$.StreamHasToScala(Files.list(autosaves)).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).filter((Function1 & Serializable)_$3 -> _$3.toFile().lastModified() > lastModified)).foreach((Function1 & Serializable)path -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToBoolean((boolean)path.toFile().delete());
                }
                catch (IOException e) {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            return;
        }
    }

    public void pruneAutoSaves() {
        Path configDir = Paths.get(System.getProperty("user.home"), ".nlogo", "modelConfigs");
        if (configDir.toFile().exists()) {
            ((IterableOnceOps)StreamConverters$.MODULE$.StreamHasToScala(Files.list(configDir)).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).foreach(configPath -> {
                Path autosaves = configPath.resolve("autosaves");
                if (autosaves.toFile().exists()) {
                    ((IterableOnceOps)((IterableOps)((SeqOps)StreamConverters$.MODULE$.StreamHasToScala(Files.list(autosaves)).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).sortBy((Function1 & Serializable)_$4 -> -_$4.toFile().lastModified(), (Ordering)Ordering.Long$.MODULE$)).drop(10)).foreach((Function1 & Serializable)path -> {
                        Object object;
                        try {
                            object = BoxesRunTime.boxToBoolean((boolean)path.toFile().delete());
                        }
                        catch (IOException e) {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    });
                    return;
                }
            });
        }
        Regex autosaveRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^autosave_\\d\\d\\d\\d-\\d\\d-\\d\\d.\\d\\d_\\d\\d_\\d\\d." + ModelReader$.MODULE$.modelSuffix() + "$"));
        ((IterableOnceOps)((IterableOps)((SeqOps)((IterableOps)StreamConverters$.MODULE$.StreamHasToScala(Files.list(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]))).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).filter((Function1 & Serializable)path -> autosaveRegex.matches((CharSequence)path.getFileName().toString()))).sortBy((Function1 & Serializable)_$5 -> -_$5.toFile().lastModified(), (Ordering)Ordering.Long$.MODULE$)).drop(10)).foreach((Function1 & Serializable)path -> {
            Object object;
            try {
                object = BoxesRunTime.boxToBoolean((boolean)path.toFile().delete());
            }
            catch (IOException e) {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }
}

