/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelType$Library$;
import org.nlogo.api.Version$;
import org.nlogo.app.ModelEntry;
import org.nlogo.app.ModelEntry$;
import org.nlogo.core.NetLogoPreferences$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;

public class RecentFiles {
    private final String key = Version$.MODULE$.is3D() ? "recent_files_3d" : "recent_files";
    private final int maxEntries;
    private List<ModelEntry> _models = (List)Nil$.MODULE$;

    public RecentFiles() {
        this.maxEntries = 8;
        this.loadFromPrefs(true);
    }

    public String key() {
        return this.key;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public List<ModelEntry> models() {
        return this._models;
    }

    public void models_$eq(List<ModelEntry> newModels) {
        this._models = ((List)newModels.flatMap((Function1 & Serializable)modelEntry -> this.ensureCanonicalPath((ModelEntry)modelEntry)).distinctBy((Function1 & Serializable)_$1 -> _$1.path())).filter((Function1 & Serializable)x -> Version$.MODULE$.is3D() == (x.path().endsWith(".nlogo3d") || x.path().endsWith(".nlogox3d"))).take(this.maxEntries());
        NetLogoPreferences$.MODULE$.put(this.key(), this._models.mkString("\n"));
    }

    private Option<ModelEntry> ensureCanonicalPath(ModelEntry modelEntry) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)ModelEntry$.MODULE$.apply(new File(modelEntry.path()).getCanonicalPath(), modelEntry.modelType()));
        }
        catch (IOException iOException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void loadFromPrefs(boolean filter) {
        this.models_$eq((List<ModelEntry>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(NetLogoPreferences$.MODULE$.get(this.key(), ""))).toList().map((Function1 & Serializable)_$2 -> new ModelEntry((String)_$2)).filter((Function1 & Serializable)entry -> !filter || new File(entry.path()).exists()));
    }

    public boolean loadFromPrefs$default$1() {
        return false;
    }

    public void add(ModelEntry modelEntry) {
        if (this._models.exists((Function1 & Serializable)entry -> {
            String string = entry.path();
            String string2 = modelEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ModelType modelType = entry.modelType();
            ModelType$Library$ modelType$Library$ = ModelType$Library$.MODULE$;
            if (modelType == null) {
                if (modelType$Library$ == null) return true;
                return false;
            } else {
                if (!modelType.equals(modelType$Library$)) return false;
                return true;
            }
        })) {
            ModelEntry modelEntry2 = ModelEntry$.MODULE$.apply(modelEntry.path(), ModelType$Library$.MODULE$);
            this.models_$eq((List<ModelEntry>)((List)this._models.$plus$colon((Object)modelEntry2)));
            return;
        }
        this.models_$eq((List<ModelEntry>)((List)this._models.$plus$colon((Object)modelEntry)));
    }

    public void clear() {
        this.models_$eq((List<ModelEntry>)package$.MODULE$.Nil());
    }
}

