/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PrinterAbortException;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.SourceOwner;
import org.nlogo.app.App$;
import org.nlogo.app.CodeTabsWindow;
import org.nlogo.app.DirtyMonitor;
import org.nlogo.app.FileManager;
import org.nlogo.app.FileWatcherThread;
import org.nlogo.app.MainMenuBar;
import org.nlogo.app.ModelConfig$;
import org.nlogo.app.OfferSaveExternalsDialog$;
import org.nlogo.app.TabsMenu$;
import org.nlogo.app.TabsPanel;
import org.nlogo.app.codetab.CodeTab;
import org.nlogo.app.codetab.ExternalFileManager;
import org.nlogo.app.codetab.MainCodeTab;
import org.nlogo.app.codetab.TemporaryCodeTab;
import org.nlogo.app.common.CommandLine;
import org.nlogo.app.common.Events;
import org.nlogo.app.common.ExceptionCatchingAction;
import org.nlogo.app.common.MenuTab;
import org.nlogo.app.common.TabsInterface;
import org.nlogo.app.infotab.InfoTab;
import org.nlogo.app.interfacetab.InterfaceTab;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N$;
import org.nlogo.core.NetLogoPreferences$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.Printable;
import org.nlogo.swing.PrinterManager;
import org.nlogo.swing.TabLabel;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$;
import org.nlogo.swing.UserAction$KeyBindings$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileInterface;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.JobWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.Widget;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public class TabManager
implements TabsInterface,
Events.AboutToCloseFilesEvent.Handler,
Events.AboutToSaveExternalFileEvent.Handler,
Events.AboutToSaveModelEvent.Handler,
Events.AutoIndentEvent.Handler,
Events.CompiledEvent.Handler,
Events.ExternalFileSavedEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.LoadErrorEvent.Handler,
Events.LoadEndEvent.Handler,
Events.ModelSavedEvent.Handler,
Events.RuntimeErrorEvent.Handler,
Events.WidgetErrorEvent.Handler,
Events.WidgetRemovedEvent.Handler,
ThemeSync {
    private final GUIWorkspace workspace;
    private final InterfaceTab interfaceTab;
    private final ExternalFileManager externalFileManager;
    private final KeyboardFocusManager focusManager;
    private final SaveAllAction saveAllAction;
    private final PrintAction printAction;
    public boolean org$nlogo$app$TabManager$$printing;
    private final InfoTab infoTab;
    private final MainCodeTab mainCodeTab;
    private final TabsPanel mainTabs;
    private final TabsPanel separateTabs;
    private final CodeTabsWindow separateTabsWindow;
    private Component previousTab;
    private FileManager fileManager;
    private DirtyMonitor dirtyMonitor;
    private MainMenuBar menuBar;
    private Set<Widget> widgetErrors;
    private boolean smartTabbing;
    private FileWatcherThread watcherThread;
    private Seq<UserAction.MenuAction> tabActions;
    private int newFileNumber;
    private boolean reloading;
    private boolean movingTabs;
    private boolean loadingTabs;
    private boolean ignoreChanges;

    public TabManager(GUIWorkspace workspace, InterfaceTab interfaceTab, ExternalFileManager externalFileManager) {
        this.workspace = workspace;
        this.interfaceTab = interfaceTab;
        this.externalFileManager = externalFileManager;
        this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.saveAllAction = new SaveAllAction();
        this.printAction = new PrintAction();
        this.org$nlogo$app$TabManager$$printing = false;
        this.infoTab = new InfoTab((Function1<String, String>)(Function1 & Serializable)_$1 -> workspace.attachModelDir((String)_$1), workspace.getResourceManager());
        this.mainCodeTab = new MainCodeTab(workspace, this, null);
        this.mainTabs = new TabsPanel(this);
        this.separateTabs = new TabsPanel(this);
        this.separateTabsWindow = new CodeTabsWindow(workspace.getFrame(), this.separateTabs());
        this.previousTab = interfaceTab;
        this.fileManager = null;
        this.dirtyMonitor = null;
        this.menuBar = null;
        this.widgetErrors = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Widget[0]));
        this.smartTabbing = true;
        this.watcherThread = null;
        this.tabActions = TabsMenu$.MODULE$.tabActions(this);
        this.newFileNumber = 1;
        this.reloading = false;
        this.movingTabs = true;
        this.loadingTabs = false;
        this.ignoreChanges = false;
        this.addTabWithLabel(this.mainTabs(), I18N$.MODULE$.gui().get("tabs.run"), interfaceTab);
        this.addTabWithLabel(this.mainTabs(), I18N$.MODULE$.gui().get("tabs.info"), this.infoTab());
        this.addTabWithLabel(this.mainTabs(), I18N$.MODULE$.gui().get("tabs.code"), this.mainCodeTab());
        this.movingTabs = false;
        workspace.getFrame().addWindowFocusListener(new WindowFocusListener(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void windowGainedFocus(WindowEvent e) {
                if (this.$outer.separateTabs().getSelectedComponent() != null) {
                    this.$outer.mainTabs().focusSelected();
                    this.$outer.setMenuActions(this.$outer.separateTabs().getSelectedComponent(), this.$outer.mainTabs().getSelectedComponent());
                    this.$outer.switchedTabs(this.$outer.mainTabs().getSelectedComponent());
                    return;
                }
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
        JComponent appComponent = (JComponent)((JFrame)workspace.getFrame()).getContentPane();
        appComponent.getInputMap(2).put(UserAction$KeyBindings$.MODULE$.keystroke(87, true, true, UserAction$KeyBindings$.MODULE$.keystroke$default$4()), "openSeparateCodeTab");
        appComponent.getActionMap().put("openSeparateCodeTab", new AbstractAction(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.switchWindow(true, this.$outer.switchWindow$default$2());
            }
        });
        appComponent.getInputMap(2).put(UserAction$KeyBindings$.MODULE$.keystroke(91, true, true, UserAction$KeyBindings$.MODULE$.keystroke$default$4()), "previousTab");
        appComponent.getActionMap().put("previousTab", new AbstractAction(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.previousTab(this.$outer.mainTabs());
            }
        });
        appComponent.getInputMap(2).put(UserAction$KeyBindings$.MODULE$.keystroke(93, true, true, UserAction$KeyBindings$.MODULE$.keystroke$default$4()), "nextTab");
        appComponent.getActionMap().put("nextTab", new AbstractAction(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.nextTab(this.$outer.mainTabs());
            }
        });
        this.separateTabsWindow().addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void windowClosing(WindowEvent e) {
                this.$outer.switchWindow(false, this.$outer.switchWindow$default$2());
            }
        });
        this.separateTabsWindow().addWindowFocusListener(new WindowFocusListener(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void windowGainedFocus(WindowEvent e) {
                this.$outer.separateTabs().focusSelected();
                this.$outer.setMenuActions(this.$outer.mainTabs().getSelectedComponent(), this.$outer.separateTabs().getSelectedComponent());
                this.$outer.switchedTabs(this.$outer.separateTabs().getSelectedComponent());
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
        JComponent separateComponent = (JComponent)this.separateTabsWindow().getContentPane();
        separateComponent.getInputMap(2).put(UserAction$KeyBindings$.MODULE$.keystroke(87, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()), "closeSeparateCodeTab");
        separateComponent.getActionMap().put("closeSeparateCodeTab", new AbstractAction(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.switchWindow(false, this.$outer.switchWindow$default$2());
            }
        });
        separateComponent.getInputMap(2).put(UserAction$KeyBindings$.MODULE$.keystroke(91, true, true, UserAction$KeyBindings$.MODULE$.keystroke$default$4()), "previousTab");
        separateComponent.getActionMap().put("previousTab", new AbstractAction(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.previousTab(this.$outer.separateTabs());
            }
        });
        separateComponent.getInputMap(2).put(UserAction$KeyBindings$.MODULE$.keystroke(93, true, true, UserAction$KeyBindings$.MODULE$.keystroke$default$4()), "nextTab");
        separateComponent.getActionMap().put("nextTab", new AbstractAction(this){
            private final /* synthetic */ TabManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.nextTab(this.$outer.separateTabs());
            }
        });
        this.smartTabbingEnabled_$eq(NetLogoPreferences$.MODULE$.getBoolean("indentAutomatically", true));
        this.lineNumbersVisible_$eq(NetLogoPreferences$.MODULE$.getBoolean("editorLineNumbers", true));
        this.watchingFiles_$eq(this.getAutoReload());
    }

    public GUIWorkspace workspace() {
        return this.workspace;
    }

    @Override
    public InterfaceTab interfaceTab() {
        return this.interfaceTab;
    }

    public ExternalFileManager externalFileManager() {
        return this.externalFileManager;
    }

    @Override
    public InfoTab infoTab() {
        return this.infoTab;
    }

    @Override
    public MainCodeTab mainCodeTab() {
        return this.mainCodeTab;
    }

    public TabsPanel mainTabs() {
        return this.mainTabs;
    }

    public TabsPanel separateTabs() {
        return this.separateTabs;
    }

    public CodeTabsWindow separateTabsWindow() {
        return this.separateTabsWindow;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    public void fileManager_$eq(FileManager x$1) {
        this.fileManager = x$1;
    }

    public DirtyMonitor dirtyMonitor() {
        return this.dirtyMonitor;
    }

    public void dirtyMonitor_$eq(DirtyMonitor x$1) {
        this.dirtyMonitor = x$1;
    }

    public MainMenuBar menuBar() {
        return this.menuBar;
    }

    public void menuBar_$eq(MainMenuBar x$1) {
        this.menuBar = x$1;
    }

    public void init(FileManager fileManager, DirtyMonitor dirtyMonitor, MainMenuBar menuBar, Seq<UserAction.MenuAction> actions) {
        this.fileManager_$eq(fileManager);
        this.dirtyMonitor_$eq(dirtyMonitor);
        this.menuBar_$eq(menuBar);
        actions.foreach(action -> this.separateTabsWindow().menuBar().offerAction((UserAction.MenuAction)action));
        this.permanentMenuActions().foreach(action -> this.offerAction((UserAction.MenuAction)action));
        this.updateTabActions();
    }

    public void startWatcherThread(String modelPath) {
        this.stopWatcherThread();
        if (modelPath != null && !this.ignoreChanges) {
            List includes = (List)this.mainCodeTab().getIncludesTable().map((Function1 & Serializable)x -> TabManager.f$1(x)).getOrElse(TabManager::$anonfun$2);
            Path path = Paths.get(modelPath, new String[0]);
            this.watcherThread = new FileWatcherThread((List<Path>)includes.$colon$colon((Object)path), (Function0<Object>)(Function0 & Serializable)() -> this.handleFileChange());
            this.watcherThread.start();
            return;
        }
    }

    public String startWatcherThread$default$1() {
        return this.workspace().getModelPath();
    }

    public void stopWatcherThread() {
        if (this.watcherThread != null) {
            this.watcherThread.interrupt();
            this.watcherThread = null;
            return;
        }
    }

    public void setWatchingFiles(boolean value, String modelPath) {
        if (value) {
            this.startWatcherThread(modelPath);
            return;
        }
        this.stopWatcherThread();
    }

    public String setWatchingFiles$default$2() {
        return this.workspace().getModelPath();
    }

    public void setIgnoreChanges(boolean ignore) {
        this.ignoreChanges = ignore;
    }

    private boolean handleFileChange() {
        boolean dirty = this.dirtyMonitor().modelDirty();
        if (dirty) {
            int index = new OptionPane(this.workspace().getFrame(), I18N$.MODULE$.gui().get("dirty.dialog.title"), I18N$.MODULE$.gui().get("dirty.dialog.message"), OptionPane$Options$.MODULE$.OkCancel(), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex();
            if (index == 0) {
                this.okCallback$1();
            } else {
                this.cancelCallback$1();
            }
        } else {
            this.reload();
        }
        return dirty;
    }

    public Seq<UserAction.MenuAction> permanentMenuActions() {
        return (Seq)((SeqOps)((IterableOps)((IterableOps)this.mainCodeTab().permanentMenuActions().$plus$plus((IterableOnce)this.interfaceTab().permanentMenuActions())).$plus$plus(this.interfaceTab().activeMenuActions())).$plus$plus(this.fileManager().saveModelActions(this.workspace().getFrame()))).$colon$plus((Object)this.printAction);
    }

    public void setMenuActions(Component oldTab, Component newTab) {
        Component component;
        Component component2 = oldTab;
        if (component2 instanceof MenuTab) {
            Component mt = (Component)((Object)((MenuTab)((Object)component2)));
            ((MenuTab)((Object)mt)).activeMenuActions().foreach(action -> this.revokeAction((UserAction.MenuAction)action));
        }
        if ((component = newTab) instanceof MenuTab) {
            Component mt = (Component)((Object)((MenuTab)((Object)component)));
            ((MenuTab)((Object)mt)).activeMenuActions().foreach(action -> this.offerAction((UserAction.MenuAction)action));
            return;
        }
    }

    public void updateTabActions() {
        this.tabActions.foreach(action -> this.revokeAction((UserAction.MenuAction)action));
        this.tabActions = TabsMenu$.MODULE$.tabActions(this);
        this.tabActions.foreach(action -> this.offerAction((UserAction.MenuAction)action));
    }

    public void offerAction(UserAction.MenuAction action) {
        this.menuBar().offerAction(action);
        this.separateTabsWindow().menuBar().offerAction(action);
    }

    public void revokeAction(UserAction.MenuAction action) {
        this.menuBar().revokeAction(action);
        this.separateTabsWindow().menuBar().revokeAction(action);
    }

    @Override
    public boolean smartTabbingEnabled() {
        return this.smartTabbing;
    }

    @Override
    public void smartTabbingEnabled_$eq(boolean enabled) {
        this.smartTabbing = enabled;
        this.mainCodeTab().setIndenter(enabled);
        this.getExternalFileTabs().foreach(_$4 -> _$4.setIndenter(enabled));
    }

    @Override
    public boolean lineNumbersVisible() {
        return this.mainCodeTab().lineNumbersVisible();
    }

    @Override
    public void lineNumbersVisible_$eq(boolean visible) {
        this.mainCodeTab().lineNumbersVisible_$eq(visible);
        this.getExternalFileTabs().foreach(_$5 -> _$5.lineNumbersVisible_$eq(visible));
    }

    @Override
    public void setIncludedFilesShown(boolean visible) {
        this.mainCodeTab().setIncludedFilesShown(visible);
        this.getExternalFileTabs().foreach(_$6 -> _$6.setIncludedFilesShown(visible));
    }

    @Override
    public boolean watchingFiles() {
        return this.watcherThread != null;
    }

    @Override
    public void watchingFiles_$eq(boolean value) {
        this.setWatchingFiles(value, this.setWatchingFiles$default$2());
    }

    public boolean getAutoReload() {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(NetLogoPreferences$.MODULE$.get("reloadOnExternalChanges", "false")));
    }

    public boolean focusOnError() {
        return NetLogoPreferences$.MODULE$.getBoolean("focusOnError", true);
    }

    public int getTotalTabCount() {
        return this.mainTabs().getTabCount() + this.separateTabs().getTabCount();
    }

    public String getTabTitle(int index) {
        Tuple2 tuple2 = index >= this.mainTabs().getTabCount() ? Tuple2$.MODULE$.apply((Object)this.separateTabs(), (Object)BoxesRunTime.boxToInteger((int)this.mainTabs().getTabCount())) : Tuple2$.MODULE$.apply((Object)this.mainTabs(), (Object)BoxesRunTime.boxToInteger((int)0));
        TabsPanel tabs = (TabsPanel)tuple2._1();
        int offset = BoxesRunTime.unboxToInt((Object)tuple2._2());
        return (String)tabs.getTabLabelAt(index - offset).fold(TabManager::getTabTitle$$anonfun$1, (Function1 & Serializable)_$7 -> _$7.getText());
    }

    public int getTotalTabIndex(Component tab) {
        int index = this.mainTabs().indexOfComponent(tab);
        if (index == -1) {
            return this.mainTabs().getTabCount() + this.separateTabs().indexOfComponent(tab);
        }
        return index;
    }

    public Option<TemporaryCodeTab> getTabWithFilename(Either<String, String> filename) {
        return this.getExternalFileTabs().find((Function1 & Serializable)_$8 -> {
            Either<String, String> either = _$8.filename();
            Either either2 = filename;
            return !(either != null ? !either.equals((Object)either2) : either2 != null);
        });
    }

    public Component getSelectedTab() {
        if (this.separateTabsWindow().isAncestorOf(this.focusManager.getFocusOwner())) {
            return this.separateTabs().getSelectedComponent();
        }
        return this.mainTabs().getSelectedComponent();
    }

    public Seq<TemporaryCodeTab> getExternalFileTabs() {
        if (this.separateTabsWindow().isVisible()) {
            return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.separateTabs().getTabCount()).map((Function1 & Serializable)i -> this.getExternalFileTabs$$anonfun$1(BoxesRunTime.unboxToInt((Object)i))).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Component x) {
                    Component component = x;
                    if (component instanceof TemporaryCodeTab) {
                        TemporaryCodeTab t = (TemporaryCodeTab)component;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Component x, Function1 function1) {
                    Component component = x;
                    if (component instanceof TemporaryCodeTab) {
                        TemporaryCodeTab t = (TemporaryCodeTab)component;
                        return t;
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(3), this.mainTabs().getTabCount()).map((Function1 & Serializable)i -> this.getExternalFileTabs$$anonfun$2(BoxesRunTime.unboxToInt((Object)i))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Component x) {
                Component component = x;
                if (component instanceof TemporaryCodeTab) {
                    TemporaryCodeTab t = (TemporaryCodeTab)component;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Component x, Function1 function1) {
                Component component = x;
                if (component instanceof TemporaryCodeTab) {
                    TemporaryCodeTab t = (TemporaryCodeTab)component;
                    return t;
                }
                return function1.apply((Object)x);
            }
        });
    }

    private void addTabWithLabel(TabsPanel tabsPanel, String title, Component tab) {
        tabsPanel.addTabWithLabel(tab, new TabLabel(tabsPanel, title, tab));
        Component component = tab;
        if (component instanceof ThemeSync) {
            Component ts = (Component)((Object)((ThemeSync)((Object)component)));
            ((ThemeSync)((Object)ts)).syncTheme();
            return;
        }
    }

    public Seq<String> openTempFiles() {
        return (Seq)((IterableOps)((IterableOps)this.getExternalFileTabs().filter((Function1 & Serializable)_$11 -> _$11 instanceof TemporaryCodeTab)).map((Function1 & Serializable)_$12 -> _$12.filename().toOption())).flatten(Predef$.MODULE$.$conforms());
    }

    public void setSelectedIndex(int index) {
        if (index >= this.mainTabs().getTabCount()) {
            this.separateTabs().setSelectedIndex(index - this.mainTabs().getTabCount());
            this.separateTabs().focusSelected();
            return;
        }
        this.mainTabs().setSelectedIndex(index);
        this.mainTabs().focusSelected();
    }

    public void setSelectedTab(Component tab) {
        if (this.mainTabs().indexOfComponent(tab) == -1) {
            this.separateTabs().setSelectedComponent(tab);
            this.separateTabs().focusSelected();
            return;
        }
        this.mainTabs().setSelectedComponent(tab);
        this.mainTabs().focusSelected();
    }

    public void previousTab(TabsPanel tabsPanel) {
        if (tabsPanel.getSelectedIndex() > 0) {
            tabsPanel.setSelectedIndex(tabsPanel.getSelectedIndex() - 1);
            return;
        }
    }

    public void nextTab(TabsPanel tabsPanel) {
        if (tabsPanel.getSelectedIndex() < tabsPanel.getTabCount() - 1) {
            tabsPanel.setSelectedIndex(tabsPanel.getSelectedIndex() + 1);
            return;
        }
    }

    public void switchedTabs(Component tab) {
        if (!this.movingTabs) {
            Component component = tab;
            Component component2 = this.previousTab;
            if (component == null ? component2 != null : !component.equals(component2)) {
                tab.requestFocus();
                this.setMenuActions(this.previousTab, tab);
                Component prev = this.previousTab;
                this.previousTab = tab;
                new Events.SwitchedTabsEvent(prev, tab).raise(this.workspace().getFrame());
                return;
            }
        }
    }

    private void addExternalFile(Either<String, String> name, boolean focus) {
        if (this.getExternalFileTabs().isEmpty()) {
            this.offerAction(this.saveAllAction);
        }
        TemporaryCodeTab tab = new TemporaryCodeTab(this.workspace(), this, name, this.externalFileManager(), (Function1<TemporaryCodeTab, UserAction.MenuAction>)(Function1 & Serializable)_$13 -> this.fileManager().convertTabAction((TemporaryCodeTab)_$13), this.separateTabsWindow().isVisible());
        if (this.separateTabsWindow().isVisible()) {
            this.addTabWithLabel(this.separateTabs(), tab.filenameForDisplay(), tab);
            if (focus) {
                this.separateTabs().setSelectedComponent(tab);
            }
        } else {
            this.addTabWithLabel(this.mainTabs(), tab.filenameForDisplay(), tab);
            if (focus) {
                this.mainTabs().setSelectedComponent(tab);
            }
        }
        tab.syncTheme();
        this.updateTabActions();
        this.saveOpenTabs();
        this.startWatcherThread(this.startWatcherThread$default$1());
        Event.rehash();
    }

    @Override
    public void newExternalFile() {
        this.addExternalFile((Either<String, String>)package$.MODULE$.Left().apply((Object)I18N$.MODULE$.gui().getN("tabs.external.new", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Predef$.MODULE$.int2Integer(this.newFileNumber)}))), true);
        ++this.newFileNumber;
    }

    public void addTab(Component tab, String name) {
        if (this.separateTabsWindow().isVisible()) {
            this.addTabWithLabel(this.separateTabs(), name, tab);
            this.separateTabs().setSelectedComponent(tab);
            return;
        }
        this.addTabWithLabel(this.mainTabs(), name, tab);
        this.mainTabs().setSelectedComponent(tab);
    }

    @Override
    public void openExternalFile(String filename, boolean focus) {
        Option<TemporaryCodeTab> option = this.getTabWithFilename((Either<String, String>)package$.MODULE$.Right().apply((Object)filename));
        if (option instanceof Some) {
            TemporaryCodeTab tab = (TemporaryCodeTab)((Some)option).value();
            if (this.separateTabsWindow().isVisible()) {
                this.separateTabs().setSelectedComponent(tab);
                return;
            }
            this.mainTabs().setSelectedComponent(tab);
            return;
        }
        this.addExternalFile((Either<String, String>)package$.MODULE$.Right().apply((Object)filename), focus);
        new Events.CompileAllEvent().raise(this.mainCodeTab());
    }

    @Override
    public boolean openExternalFile$default$2() {
        return true;
    }

    public void replaceTab(Component oldTab, Component newTab) {
        int index = this.mainTabs().indexOfComponent(oldTab);
        if (index == -1) {
            this.separateTabs().setComponentAt(this.separateTabs().indexOfComponent(oldTab), newTab);
            return;
        }
        this.mainTabs().setComponentAt(index, newTab);
    }

    @Override
    public void closeExternalFile(Either<String, String> filename) {
        Option<TemporaryCodeTab> option = this.getTabWithFilename(filename);
        if (option instanceof Some) {
            TemporaryCodeTab tab = (TemporaryCodeTab)((Some)option).value();
            this.closeExternalTab(tab);
            return;
        }
    }

    public void closeExternalTab(TemporaryCodeTab tab) {
        if (this.separateTabsWindow().isVisible()) {
            this.separateTabs().remove(tab);
        } else {
            this.mainTabs().remove(tab);
        }
        this.externalFileManager().remove(tab);
        if (this.getExternalFileTabs().isEmpty()) {
            this.revokeAction(this.saveAllAction);
        }
        this.updateTabActions();
        this.saveOpenTabs();
    }

    public void removeTab(Component tab) {
        if (this.mainTabs().indexOfComponent(tab) == -1) {
            this.separateTabs().remove(tab);
            return;
        }
        this.mainTabs().remove(tab);
    }

    @Override
    public void switchWindow(boolean separate, boolean preserveSelected) {
        this.movingTabs = true;
        if (separate) {
            Component selected = this.mainTabs().getSelectedComponent();
            while (this.mainTabs().getTabCount() > 2) {
                this.mainTabs().getTabLabelAt(2).foreach(tabLabel -> {
                    this.separateTabs().addTabWithLabel(this.mainTabs().getComponentAt(2), (TabLabel)tabLabel);
                    tabLabel.setTabbedPane(this.separateTabs());
                });
            }
            this.separateTabsWindow().open();
            this.mainCodeTab().setSeparate(true);
            this.getExternalFileTabs().foreach(_$14 -> _$14.setSeparate(true));
            if (selected instanceof CodeTab) {
                this.mainTabs().setSelectedIndex(0);
                this.separateTabs().setSelectedComponent(selected);
                selected.requestFocus();
            } else {
                this.mainTabs().setSelectedComponent(selected);
                this.separateTabs().setSelectedIndex(0);
                this.mainCodeTab().requestFocus();
            }
        } else {
            Component selected = this.separateTabs().getSelectedComponent();
            while (this.separateTabs().getTabCount() > 0) {
                this.separateTabs().getTabLabelAt(0).foreach(tabLabel -> {
                    this.mainTabs().addTabWithLabel(this.separateTabs().getComponentAt(0), (TabLabel)tabLabel);
                    tabLabel.setTabbedPane(this.mainTabs());
                });
            }
            this.separateTabsWindow().setVisible(false);
            this.mainCodeTab().setSeparate(false);
            this.getExternalFileTabs().foreach(_$15 -> _$15.setSeparate(false));
            if (preserveSelected) {
                this.mainTabs().setSelectedComponent(selected);
            }
            this.mainTabs().getSelectedComponent().requestFocus();
        }
        this.movingTabs = false;
        new Events.CompileAllEvent().raise(this.mainCodeTab());
        App$.MODULE$.app().setWindowTitles();
    }

    public boolean switchWindow$default$2() {
        return false;
    }

    @Override
    public void showCodeTabPreferences() {
        App$.MODULE$.app().showPreferencesDialogAt(1);
    }

    @Override
    public void setJumpOnClick(boolean value) {
        this.interfaceTab().iP().setJumpOnClick(value);
        this.interfaceTab().speedSlider().setJumpOnClick(value);
    }

    public void reload() {
        if (!this.reloading) {
            this.reloading = true;
            this.workspace().reload();
            return;
        }
    }

    @Override
    public void handle(Events.LoadBeginEvent e) {
        if (!this.reloading) {
            this.getExternalFileTabs().foreach(tab -> this.closeExternalTab((TemporaryCodeTab)tab));
            this.mainTabs().setSelectedComponent(this.interfaceTab());
            return;
        }
    }

    @Override
    public void handle(Events.LoadEndEvent e) {
        this.loadOpenTabs();
        this.stopWatcherThread();
        if (this.getAutoReload()) {
            this.startWatcherThread(this.startWatcherThread$default$1());
            this.getExternalFileTabs().foreach((Function1 & Serializable)_$16 -> _$16.reload());
        }
        this.reloading = false;
    }

    @Override
    public void handle(Events.LoadErrorEvent e) {
        this.reloading = false;
    }

    @Override
    public void handle(Events.RuntimeErrorEvent e) {
        if (!(e.jobOwner instanceof MonitorWidget)) {
            SourceOwner sourceOwner = e.sourceOwner;
            MainCodeTab mainCodeTab = this.mainCodeTab();
            SourceOwner sourceOwner2 = sourceOwner;
            if (!(mainCodeTab != null ? !mainCodeTab.equals(sourceOwner2) : sourceOwner2 != null)) {
                this.highlightRuntimeError(this.mainCodeTab(), e);
                return;
            }
            if (sourceOwner instanceof ExternalFileInterface) {
                ExternalFileInterface file = (ExternalFileInterface)sourceOwner;
                String filename = file.getFileName();
                TemporaryCodeTab tab = (TemporaryCodeTab)this.getTabWithFilename((Either<String, String>)package$.MODULE$.Right().apply((Object)filename)).getOrElse(() -> this.$anonfun$4(filename));
                this.highlightRuntimeError(tab, e);
                return;
            }
            return;
        }
    }

    public void highlightRuntimeError(CodeTab tab, Events.RuntimeErrorEvent e) {
        this.setSelectedTab(tab);
        tab.selectError(e.pos, e.pos + e.length);
    }

    public void recolorTab(Component tab, boolean hasError) {
        if (this.separateTabsWindow().isVisible() && tab instanceof CodeTab) {
            this.separateTabs().setError(this.separateTabs().indexOfComponent(tab), hasError);
        } else {
            this.mainTabs().setError(this.mainTabs().indexOfComponent(tab), hasError);
        }
        if (hasError && this.focusOnError()) {
            this.setSelectedTab(tab);
            return;
        }
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        JobWidget jobWidget;
        SourceOwner sourceOwner = e.sourceOwner;
        MainCodeTab mainCodeTab = this.mainCodeTab();
        SourceOwner sourceOwner2 = sourceOwner;
        if (!(mainCodeTab != null ? !mainCodeTab.equals(sourceOwner2) : sourceOwner2 != null)) {
            if (e.error == null) {
                this.clearErrors$1();
            } else {
                this.recolorTab(this.mainCodeTab(), true);
            }
        } else if (sourceOwner instanceof ExternalFileInterface) {
            ExternalFileInterface file = (ExternalFileInterface)sourceOwner;
            String filename = file.getFileName();
            Option<TemporaryCodeTab> tab = this.getTabWithFilename((Either<String, String>)package$.MODULE$.Right().apply((Object)filename));
            if (!tab.isDefined() && e.error != null) {
                this.openExternalFile(filename, this.focusOnError());
                tab = this.getTabWithFilename((Either<String, String>)package$.MODULE$.Right().apply((Object)filename));
                ((TemporaryCodeTab)tab.get()).handle(e);
            }
            this.recolorTab((Component)tab.get(), e.error != null);
        } else if (sourceOwner == null) {
            this.recolorTab(this.interfaceTab(), e.error != null);
        } else if (sourceOwner instanceof JobWidget && !(jobWidget = (JobWidget)sourceOwner).isCommandCenter()) {
            this.recolorTab(this.interfaceTab(), e.error != null);
        }
        this.mainTabs().repaint();
        this.separateTabs().repaint();
    }

    @Override
    public void handle(Events.WidgetErrorEvent e) {
        Widget widget = e.widget;
        if (widget instanceof CommandLine) {
            CommandLine cl = (CommandLine)widget;
            return;
        }
        Widget w = widget;
        boolean changed = false;
        Option<Exception> option = e.error;
        if (option instanceof Some) {
            Exception err = (Exception)((Some)option).value();
            changed = !this.widgetErrors.contains((Object)w);
            this.widgetErrors = (Set)this.widgetErrors.$plus((Object)w);
        } else if (None$.MODULE$.equals(option)) {
            changed = this.widgetErrors.contains((Object)w);
            this.widgetErrors = (Set)this.widgetErrors.$minus((Object)w);
        } else {
            throw new MatchError(option);
        }
        if (changed) {
            this.recolorTab(this.interfaceTab(), this.widgetErrors.nonEmpty());
            this.mainTabs().repaint();
            return;
        }
    }

    @Override
    public void handle(Events.WidgetRemovedEvent e) {
        this.widgetErrors = (Set)this.widgetErrors.$minus((Object)e.widget);
        this.recolorTab(this.interfaceTab(), this.widgetErrors.nonEmpty());
        this.mainTabs().repaint();
    }

    @Override
    public void handle(Events.AboutToSaveExternalFileEvent e) {
        this.stopWatcherThread();
    }

    @Override
    public void handle(Events.AboutToSaveModelEvent e) {
        this.stopWatcherThread();
    }

    @Override
    public void handle(Events.ExternalFileSavedEvent e) {
        this.getTabWithFilename((Either<String, String>)package$.MODULE$.Right().apply((Object)e.path)).foreach(tab -> {
            if (this.separateTabsWindow().isVisible()) {
                this.separateTabs().getTabLabelAt(this.separateTabs().indexOfComponent((Component)tab)).foreach(_$17 -> _$17.setText(tab.filenameForDisplay()));
                return;
            }
            this.mainTabs().getTabLabelAt(this.mainTabs().indexOfComponent((Component)tab)).foreach(_$18 -> _$18.setText(tab.filenameForDisplay()));
        });
        this.startWatcherThread(this.startWatcherThread$default$1());
    }

    @Override
    public void handle(Events.AboutToCloseFilesEvent e) {
        OfferSaveExternalsDialog$.MODULE$.offer((Set<TemporaryCodeTab>)((IterableOnceOps)this.getExternalFileTabs().filter((Function1 & Serializable)_$19 -> _$19.saveNeeded())).toSet(), this.workspace().getFrame());
    }

    @Override
    public void handle(Events.ModelSavedEvent e) {
        this.startWatcherThread(this.startWatcherThread$default$1());
    }

    @Override
    public void handle(Events.AutoIndentEvent e) {
        this.smartTabbingEnabled_$eq(Predef$.MODULE$.Boolean2boolean(e.smart));
    }

    @Override
    public void syncTheme() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.mainTabs().getComponents());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)this.separateTabs().getComponents(), ClassTag$.MODULE$.apply(Component.class)));
        ArrayOps$.MODULE$.foreach$extension(object2, _$20 -> {
            Component component = _$20;
            if (component instanceof ThemeSync) {
                Component ts = (Component)((Object)((ThemeSync)((Object)component)));
                ((ThemeSync)((Object)ts)).syncTheme();
                return;
            }
        });
        this.mainTabs().syncTheme();
        this.separateTabs().syncTheme();
        this.separateTabsWindow().syncTheme();
    }

    private Option<Path> tabFilePath() {
        return Option$.MODULE$.apply((Object)this.workspace().getModelPath()).map((Function1 & Serializable)_$21 -> ModelConfig$.MODULE$.getModelConfigPath((String)_$21).resolve("openTempFiles.txt"));
    }

    private void loadOpenTabs() {
        this.loadingTabs = true;
        this.tabFilePath().filter((Function1 & Serializable)_$22 -> _$22.toFile().exists()).foreach(path -> {
            String storedLastModified = (String)ModelConfig$.MODULE$.getLastModified(this.workspace().getModelPath()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            String actualLastModified = BoxesRunTime.boxToLong((long)new File(this.workspace().getModelPath()).lastModified()).toString();
            if (path.toFile().exists()) {
                String string = storedLastModified;
                String string2 = actualLastModified;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach(_$23 -> this.openExternalFile((String)_$23, false));
                    return;
                }
            }
        });
        this.loadingTabs = false;
    }

    public void saveOpenTabs() {
        if (!this.loadingTabs) {
            this.tabFilePath().foreach(path -> {
                File file = path.toFile();
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                new PrintWriter(file, this){
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        super(file$1);
                        $outer.openTempFiles().foreach(x$0 -> this.println((String)x$0));
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$2(java.lang.String )}, serializedLambda);
                    }
                }.close();
            });
            return;
        }
    }

    private static final List f$1(Map x) {
        return ((IterableOnceOps)x.values().map((Function1 & Serializable)_$2 -> Paths.get(_$2, new String[0]))).toList();
    }

    private static final List $anonfun$2() {
        return package$.MODULE$.List().empty();
    }

    private final void cancelCallback$1() {
        this.startWatcherThread(this.startWatcherThread$default$1());
    }

    private final void okCallback$1() {
        this.reload();
        this.startWatcherThread(this.startWatcherThread$default$1());
    }

    public static final /* synthetic */ void org$nlogo$app$TabManager$SaveAllAction$$_$action$$anonfun$1(TemporaryCodeTab _$3) {
        _$3.save(false);
    }

    private static final String getTabTitle$$anonfun$1() {
        return "";
    }

    private final /* synthetic */ Component getExternalFileTabs$$anonfun$1(int i) {
        return this.separateTabs().getComponentAt(i);
    }

    private final /* synthetic */ Component getExternalFileTabs$$anonfun$2(int i) {
        return this.mainTabs().getComponentAt(i);
    }

    private final TemporaryCodeTab $anonfun$4(String filename$2) {
        this.openExternalFile(filename$2, this.openExternalFile$default$2());
        return (TemporaryCodeTab)this.getTabWithFilename((Either<String, String>)package$.MODULE$.Right().apply((Object)filename$2)).get();
    }

    private final void clearErrors$1() {
        TabsPanel tabs = this.separateTabsWindow().isVisible() ? this.separateTabs() : this.mainTabs();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), tabs.getTabCount()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> tabs.setError(i, false));
    }

    public class PrintAction
    extends AbstractAction
    implements UserAction.MenuAction {
        public PrintAction() {
            if (TabManager.this == null) {
                throw new NullPointerException();
            }
            super(I18N$.MODULE$.gui().get("menu.file.print"));
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FilePrintGroup());
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(80, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component component = TabManager.this.getSelectedTab();
            if (component instanceof Printable) {
                Component printable = (Component)((Object)((Printable)((Object)component)));
                if (!TabManager.this.org$nlogo$app$TabManager$$printing) {
                    TabManager.this.org$nlogo$app$TabManager$$printing = true;
                    try {
                        PrinterManager.print((Printable)((Object)printable), TabManager.this.workspace().modelNameForDisplay());
                    }
                    catch (PrinterAbortException abortEx) {
                        Exceptions$.MODULE$.ignore(abortEx);
                    }
                    TabManager.this.org$nlogo$app$TabManager$$printing = false;
                    return;
                }
            }
        }

        public final /* synthetic */ TabManager org$nlogo$app$TabManager$PrintAction$$$outer() {
            return TabManager.this;
        }
    }

    public class SaveAllAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        public SaveAllAction() {
            if (TabManager.this == null) {
                throw new NullPointerException();
            }
            super(I18N$.MODULE$.gui().get("menu.file.saveAll"), TabManager.this.workspace().getFrame());
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FileSaveGroup());
            this.rank_$eq(1.0);
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(83, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), true));
        }

        @Override
        public void action() throws UserCancelException {
            TabManager.this.fileManager().saveModel(false);
            TabManager.this.getExternalFileTabs().foreach(TabManager::org$nlogo$app$TabManager$SaveAllAction$$_$action$$anonfun$1);
        }

        public final /* synthetic */ TabManager org$nlogo$app$TabManager$SaveAllAction$$$outer() {
            return TabManager.this;
        }
    }
}

