/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.app.TabManager;
import org.nlogo.app.codetab.CodeTab;
import org.nlogo.swing.FloatingTabbedPane;
import org.nlogo.swing.TabLabel;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;

public class TabsPanel
extends FloatingTabbedPane
implements ChangeListener,
ThemeSync {
    private final TabManager tabManager;

    public TabsPanel(TabManager tabManager) {
        this.tabManager = tabManager;
        this.addChangeListener(this);
        this.addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ TabsPanel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.isControlDown() && this.$outer.tabManager().getSelectedTab() instanceof CodeTab) {
                    if (this.$outer.tabManager().separateTabsWindow().isAncestorOf(this.$outer.tabManager().getSelectedTab())) {
                        this.$outer.tabManager().switchWindow(false, true);
                        return;
                    }
                    this.$outer.tabManager().switchWindow(true, this.$outer.tabManager().switchWindow$default$2());
                    return;
                }
            }
        });
    }

    public TabManager tabManager() {
        return this.tabManager;
    }

    @Override
    public void addTabWithLabel(Component tab, TabLabel label) {
        super.addTabWithLabel(tab, label);
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            this.setToolTipTextAt(this.getTabCount() - 1, "Cmd+" + (this.tabManager().getTotalTabIndex(tab) + 1));
            return;
        }
        this.setToolTipTextAt(this.getTabCount() - 1, "Ctrl+" + (this.tabManager().getTotalTabIndex(tab) + 1));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tabManager().switchedTabs(this.getSelectedComponent());
    }

    @Override
    public void syncTheme() {
        this.setBackground(InterfaceColors$.MODULE$.toolbarBackground());
    }
}

