/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.tools;

import java.awt.Window;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import org.nlogo.agent.Agent;
import org.nlogo.app.tools.AgentMonitorWindow;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.swing.Tiler$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.Event;
import org.nlogo.window.GUIWorkspace;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class AgentMonitorManager
implements Event.LinkChild,
Event.LinkParent,
ThemeSync {
    private final GUIWorkspace workspace;
    private final Map<Agent, AgentMonitorWindow> monitorWindows;
    private final Map<AgentKind, AgentMonitorWindow> emptyMonitorWindows;
    private final Buffer<Agent> monitorList;

    public AgentMonitorManager(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.monitorWindows = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.emptyMonitorWindows = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.monitorList = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Agent[0]));
    }

    public GUIWorkspace workspace() {
        return this.workspace;
    }

    public void closeAll() {
        this.monitorWindows.values().foreach(w -> {
            w.setVisible(false);
            w.dispose();
        });
        this.monitorWindows.clear();
        this.emptyMonitorWindows.values().foreach(w -> {
            w.setVisible(false);
            w.dispose();
        });
        this.emptyMonitorWindows.clear();
        Event.rehash();
        this.monitorList.clear();
    }

    public void closeTopMonitor() {
        this.monitorList.headOption().map(this.monitorWindows).foreach(topMonitor -> {
            topMonitor.setVisible(false);
            topMonitor.dispose();
            this.remove((AgentMonitorWindow)topMonitor);
        });
    }

    @Override
    public GUIWorkspace getLinkParent() {
        return this.workspace();
    }

    @Override
    public Object[] getLinkChildren() {
        ListBuffer list = (ListBuffer)ListBuffer$.MODULE$.apply(this.monitorWindows.values().toSeq());
        this.emptyMonitorWindows.values().foreach((Function1 & Serializable)w -> (ListBuffer)list.$plus$eq(w));
        return (Object[])list.toArray(ClassTag$.MODULE$.apply(Object.class));
    }

    public void agentChangeNotify(AgentMonitorWindow window, Agent oldAgent) {
        BoxedUnit boxedUnit;
        if (oldAgent == null) {
            if (window.agent() != null) {
                this.emptyMonitorWindows.remove((Object)window.agent().kind());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.monitorWindows.$minus$eq((Object)oldAgent);
            boxedUnit = this.monitorList.$minus$eq((Object)oldAgent);
        }
        if (window.agent() != null) {
            this.monitorWindows.put((Object)window.agent(), (Object)window);
            this.monitorList.prepend((Object)window.agent());
            return;
        }
    }

    public void remove(AgentMonitorWindow window) {
        if (window.agent() != null) {
            this.monitorWindows.$minus$eq((Object)window.agent());
            this.monitorList.$minus$eq((Object)window.agent());
            return;
        }
        this.emptyMonitorWindows.remove((Object)window.agentKind());
    }

    private AgentMonitorWindow newWindow(AgentKind agentKind, Agent agent, double radius) {
        Option option;
        AgentMonitorWindow window = new AgentMonitorWindow(agentKind, agent, radius, this, this.workspace().getFrame());
        ArrayList<Window> otherWindows = new ArrayList<Window>();
        this.monitorWindows.values().foreach((Function1 & Serializable)_$1 -> otherWindows.add((Window)_$1));
        this.emptyMonitorWindows.values().foreach((Function1 & Serializable)_$2 -> otherWindows.add((Window)_$2));
        window.setLocation(Tiler$.MODULE$.findEmptyLocation(otherWindows, window));
        if (agent != null) {
            this.monitorWindows.put((Object)agent, (Object)window);
            option = this.monitorList.prepend((Object)window.agent());
        } else {
            option = this.emptyMonitorWindows.put((Object)agentKind, (Object)window);
        }
        return window;
    }

    /*
     * Unable to fully structure code
     */
    public void inspect(AgentKind agentKind, Agent a0, double radius) {
        if (a0 != null) ** GOTO lbl-1000
        v0 = agentKind;
        var6_4 = AgentKind$Observer$.MODULE$;
        if (!(v0 != null ? v0.equals(var6_4) == false : var6_4 != null)) {
            v1 = this.workspace().world().observer();
        } else lbl-1000:
        // 2 sources

        {
            v1 = a0;
        }
        agent = v1;
        window = agent != null ? (AgentMonitorWindow)this.monitorWindows.getOrElse((Object)agent, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$1(org.nlogo.core.AgentKind org.nlogo.agent.Agent double ), ()Lorg/nlogo/app/tools/AgentMonitorWindow;)((AgentMonitorManager)this, (AgentKind)agentKind, (Agent)agent, (double)radius)) : (AgentMonitorWindow)this.emptyMonitorWindows.getOrElse((Object)agentKind, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$2(org.nlogo.core.AgentKind org.nlogo.agent.Agent double ), ()Lorg/nlogo/app/tools/AgentMonitorWindow;)((AgentMonitorManager)this, (AgentKind)agentKind, (Agent)agent, (double)radius));
        window.syncTheme();
        window.radius(radius);
        window.setVisible(true);
        Event.rehash();
        if (agent == null) {
            v2 = agentKind;
            var8_7 = AgentKind$Observer$.MODULE$;
            if (v2 == null ? var8_7 != null : v2.equals(var8_7) == false) {
                window.requestFocus();
                return;
            }
        }
    }

    public void stopInspecting(Agent agent) {
        if (agent != null) {
            this.monitorWindows.get((Object)agent).collect((PartialFunction)new Serializable(this){
                private final /* synthetic */ AgentMonitorManager $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(AgentMonitorWindow x) {
                    AgentMonitorWindow agentMonitorWindow = x;
                    if (agentMonitorWindow != null) {
                        AgentMonitorWindow window = agentMonitorWindow;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(AgentMonitorWindow x, Function1 function1) {
                    AgentMonitorWindow agentMonitorWindow = x;
                    if (agentMonitorWindow != null) {
                        AgentMonitorWindow window = agentMonitorWindow;
                        window.setVisible(false);
                        window.dispose();
                        this.$outer.remove(window);
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }
            });
            return;
        }
    }

    public void stopInspectingDeadAgents() {
        this.monitorWindows.keys().foreach(x$1 -> {
            Agent agent = x$1;
            Agent agent2 = agent;
            if (agent2.id() == -1L) {
                this.stopInspecting(agent2);
                return;
            }
        });
    }

    public void showAll() {
        this.showOrHideAll(true);
    }

    public void hideAll() {
        this.showOrHideAll(false);
    }

    private void showOrHideAll(boolean show) {
        this.monitorWindows.values().foreach(monitor -> {
            monitor.syncTheme();
            monitor.setVisible(show);
        });
        this.emptyMonitorWindows.values().foreach(_$3 -> _$3.setVisible(show));
    }

    public boolean areAnyVisible() {
        return this.monitorWindows.values().exists((Function1 & Serializable)_$4 -> _$4.isVisible()) || this.emptyMonitorWindows.values().exists((Function1 & Serializable)_$5 -> _$5.isVisible());
    }

    public void refresh() {
        this.monitorWindows.values().foreach(_$6 -> _$6.refresh());
    }

    @Override
    public void syncTheme() {
        this.monitorWindows.values().foreach(_$7 -> _$7.syncTheme());
        this.emptyMonitorWindows.values().foreach(_$8 -> _$8.syncTheme());
    }

    private final AgentMonitorWindow $anonfun$1(AgentKind agentKind$1, Agent agent$1, double radius$1) {
        return this.newWindow(agentKind$1, agent$1, radius$1);
    }

    private final AgentMonitorWindow $anonfun$2(AgentKind agentKind$2, Agent agent$2, double radius$2) {
        return this.newWindow(agentKind$2, agent$2, radius$2);
    }
}

